/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.core;

import fr.inria.aoste.timesquare.launcher.debug.model.ISimulationInterface;
import fr.inria.aoste.timesquare.launcher.debug.model.StateEngine;
import fr.inria.aoste.timesquare.launcher.debug.model.proxy.ISimulatorControl;
import fr.inria.aoste.trace.LogicalStep;
import fr.inria.aoste.trace.Trace;

public class SimulatorControl
implements ISimulatorControl {
    private ISimulationInterface isimulation;
    private Thread thread = null;

    public SimulatorControl(Thread t, ISimulationInterface isimulation) {
        assert (isimulation != null);
        this.thread = t;
        this.isimulation = isimulation;
    }

    @Override
    public Trace getTrace() {
        return this.isimulation.getTrace();
    }

    @Override
    public synchronized boolean isJoinable() {
        if (this.thread != null) {
            if (this.thread.isAlive()) {
                return true;
            }
            this.thread = null;
            return false;
        }
        return false;
    }

    @Override
    public synchronized void join() throws InterruptedException, Exception {
        if (this.thread != null) {
            this.thread.join();
            if (this.thread instanceof ThreadwithExceptionNotification) {
                ((ThreadwithExceptionNotification)this.thread).reThrows();
            }
        }
        this.thread = null;
    }

    @Override
    public synchronized void syncRunStep() throws Exception {
        if (this.thread == null) {
            this.isimulation.step(true);
        }
    }

    @Override
    public synchronized void syncRunStep(int nb) throws Exception {
        if (this.thread == null) {
            this.isimulation.step(nb);
        }
    }

    @Override
    public synchronized void syncRunAllStep() throws Exception {
        if (this.thread == null) {
            this.isimulation.steprun();
        }
    }

    @Override
    public synchronized void syncPreviousStep() throws Exception {
        int vstep;
        if (this.thread == null && (vstep = this.isimulation.getViewStepIndice() - 1) >= 0) {
            this.isimulation.viewStep(vstep);
        }
    }

    @Override
    public synchronized void asyncPreviousStep() throws Exception {
        if (this.thread == null) {
            this.thread = new ThreadwithExceptionNotification("Prog : Previous Step (Prog)"){

                @Override
                protected void runwithException() throws Throwable {
                    int vstep = SimulatorControl.this.isimulation.getViewStepIndice() - 1;
                    if (vstep >= 0) {
                        SimulatorControl.this.isimulation.viewStep(vstep);
                    }
                }
            };
            this.thread.start();
        }
    }

    @Override
    public synchronized void asyncRunAllStep() throws Exception {
        if (this.thread == null) {
            this.thread = new ThreadwithExceptionNotification("Prog : Run All Step (Prog)"){

                @Override
                protected void runwithException() throws Throwable {
                    SimulatorControl.this.isimulation.steprun();
                }
            };
            this.thread.start();
        }
    }

    @Override
    public synchronized void asyncRunStep() throws Exception {
        if (this.thread == null) {
            this.thread = new ThreadwithExceptionNotification("Prog : Run One Step(prog)"){

                @Override
                protected void runwithException() throws Throwable {
                    SimulatorControl.this.isimulation.step(true);
                }
            };
            this.thread.start();
        }
    }

    @Override
    public synchronized void asyncRunStep(final int nb) throws Exception {
        if (this.thread == null) {
            this.thread = new ThreadwithExceptionNotification("Prog : Run  " + nb + " Step(s) )"){

                @Override
                protected void runwithException() throws Throwable {
                    SimulatorControl.this.isimulation.step(nb);
                }
            };
            this.thread.start();
        }
    }

    @Override
    public synchronized LogicalStep getCurrentSolverStep() {
        if (this.thread == null) {
            return this.isimulation.getStep();
        }
        return null;
    }

    @Override
    public synchronized LogicalStep getStepView() {
        if (this.thread == null) {
            return this.isimulation.getStepview();
        }
        return null;
    }

    @Override
    public synchronized boolean isTerminated() {
        if (this.thread == null) {
            return this.isimulation.isTerminated();
        }
        return false;
    }

    @Override
    public synchronized void terminate() throws InterruptedException, Exception {
        try {
            this.join();
        }
        finally {
            this.isimulation.finish();
            this.isimulation.disconnect();
        }
    }

    @Override
    public void pause() {
        this.isimulation.stopstep();
    }

    @Override
    public StateEngine getStateEngine() {
        return this.isimulation.getStateEngine();
    }

    public static abstract class ThreadwithExceptionNotification
    extends Thread {
        protected Throwable throwable = null;

        public ThreadwithExceptionNotification(String name) {
            super(name);
        }

        @Override
        public final void run() {
            try {
                this.runwithException();
            }
            catch (Throwable e) {
                this.throwable = e;
            }
        }

        protected abstract void runwithException() throws Throwable;

        public void reThrows() throws Exception {
            if (this.throwable instanceof Exception) {
                throw (Exception)this.throwable;
            }
            if (this.throwable instanceof Error) {
                throw (Error)this.throwable;
            }
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

