/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.debug.model;

import fr.inria.aoste.timesquare.launcher.debug.model.CCSLDebugElement;
import fr.inria.aoste.timesquare.launcher.debug.model.ICCSLDebugTarget;
import fr.inria.aoste.timesquare.trace.util.adapter.AdapterRegistry;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.NamedReference;
import fr.inria.aoste.trace.Reference;
import fr.inria.aoste.trace.State;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.ecore.EObject;

public abstract class CCSLValue
extends CCSLDebugElement
implements IValue {
    private String type;

    protected CCSLValue(ICCSLDebugTarget target, String type) {
        super(target);
        this.type = type;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.type;
    }

    public IVariable[] getVariables() throws DebugException {
        return new IVariable[0];
    }

    public boolean hasVariables() throws DebugException {
        return false;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    protected String getClockName(State cs) {
        StringBuilder sb = new StringBuilder("");
        Reference rf = cs.getReferedElement();
        if (rf != null) {
            sb.append(this.getname(rf));
        } else {
            sb.append(cs.toString());
        }
        sb.append("");
        return sb.toString();
    }

    public final String getname(Reference rf) {
        if (rf == null) {
            return "null";
        }
        if (rf instanceof NamedReference) {
            return ((NamedReference)rf).getValue();
        }
        if (rf instanceof ModelElementReference) {
            return AdapterRegistry.getAdapter((EObject)rf).getReferenceName((EObject)rf);
        }
        return rf.toString();
    }
}

