/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.debug.model;

public enum StateEngine {
    init("init", 0),
    run("run", 1),
    pause("pause", 2),
    terminate("terminate", 3),
    ter_back("replay", 4),
    ter_replay("replay", 5),
    error("error", 6),
    errorInitModel("errorInitModel", 7),
    errorInitView("errorInitView", 8);

    private final int id;
    private final String name;

    private StateEngine(String _name, int n2) {
        this.id = n2;
        this.name = _name;
    }

    public boolean isFinish() {
        switch (this) {
            case terminate: 
            case ter_back: 
            case ter_replay: 
            case error: 
            case errorInitModel: 
            case errorInitView: {
                return true;
            }
        }
        return false;
    }

    public boolean isTerminate() {
        switch (this) {
            case terminate: 
            case error: 
            case errorInitModel: 
            case errorInitView: {
                return true;
            }
        }
        return false;
    }

    public boolean isRunning() {
        return this == run || this == ter_replay;
    }

    public boolean isRunnable() {
        switch (this) {
            case pause: 
            case ter_back: {
                return true;
            }
        }
        return false;
    }

    public boolean isError() {
        switch (this) {
            case error: 
            case errorInitModel: 
            case errorInitView: {
                return true;
            }
        }
        return false;
    }

    public final int getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }
}

