/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.model.visitor;

import fr.inria.aoste.timesquare.vcd.model.Value;
import fr.inria.aoste.timesquare.vcd.model.ValueChange;
import fr.inria.aoste.timesquare.vcd.model.command.VarCommand;
import fr.inria.aoste.timesquare.vcd.model.keyword.ScopeType;
import fr.inria.aoste.timesquare.vcd.model.keyword.SimulationKeyword;
import fr.inria.aoste.timesquare.vcd.model.keyword.TimeUnit;
import fr.inria.aoste.timesquare.vcd.model.keyword.VarType;
import fr.inria.aoste.timesquare.vcd.model.visitor.IDeclarationVisitor;
import fr.inria.aoste.timesquare.vcd.model.visitor.IScopeVisitor;
import fr.inria.aoste.timesquare.vcd.model.visitor.ISimulationCollector;
import fr.inria.aoste.timesquare.vcd.model.visitor.IStringVisitor;

public final class StringVisitor
implements IStringVisitor {
    private StringBuffer _strBuffer = new StringBuffer();

    public String toString() {
        return this._strBuffer.toString();
    }

    @Override
    public IDeclarationVisitor getDeclarationVisitor() {
        return new MyDeclarationVisitor();
    }

    @Override
    public IScopeVisitor getScopeVisitor() {
        return new MyScopeVisitor();
    }

    @Override
    public ISimulationCollector getSimulationVisitor() {
        return new VCDTextFileSimulationVisitor();
    }

    class MyDeclarationVisitor
    implements IDeclarationVisitor {
        MyDeclarationVisitor() {
        }

        @Override
        public void visitDate(String date) {
            StringVisitor.this._strBuffer.append("$date \n").append(date).append("\n$end\n\n");
        }

        @Override
        public void visitEndDefinitions() {
            StringVisitor.this._strBuffer.append("$enddefinitions $end\n\n");
        }

        @Override
        public void visitVersion(String text, String task) {
            StringVisitor.this._strBuffer.append("$version \n").append(text).append(' ').append(task).append("\n$end\n\n");
        }

        @Override
        public void visitConstraintComment(String comment) {
            if (comment == null) {
                return;
            }
            StringVisitor.this._strBuffer.append("$comment ").append(comment);
            StringVisitor.this._strBuffer.append(" $end\n");
        }

        @Override
        public void visitStatusComment(String func, String ident, int time) {
        }

        @Override
        public void visitTimeScale(int number, TimeUnit unit) {
            StringVisitor.this._strBuffer.append("$timescale \n").append(number).append(' ').append((Object)unit).append(" $end\n\n");
        }
    }

    class MyScopeVisitor
    implements IScopeVisitor {
        MyScopeVisitor() {
        }

        @Override
        public void visitScope(ScopeType type, String name) {
            StringVisitor.this._strBuffer.append("$scope ").append((Object)type).append(' ').append(name).append(" $end\n");
        }

        @Override
        public void visitVar(VarCommand command, VarType type, String ident) {
            StringVisitor.this._strBuffer.append("$var ").append((Object)type).append(' ').append(command.getSize()).append(' ').append(ident).append(' ').append(command.getName()).append(" $end\n");
        }

        @Override
        public void visitUpscope() {
            StringVisitor.this._strBuffer.append("$upscope $end\n");
        }
    }

    private class VCDTextFileSimulationVisitor
    implements ISimulationCollector {
        private VCDTextFileSimulationVisitor() {
        }

        @Override
        public void visitTimeLine(int time) {
            StringVisitor.this._strBuffer.append('#').append(time).append('\n');
        }

        @Override
        public void visitKeyword(SimulationKeyword keyword) {
            if (keyword != null) {
                StringVisitor.this._strBuffer.append('$').append((Object)keyword).append('\n');
            }
        }

        @Override
        public void visitValueChange(ValueChange value, int time) {
            if (value == null) {
                return;
            }
            if (value.getValue() instanceof Value) {
                if ((Value)((Object)value.getValue()) != Value._0) {
                    StringVisitor.this._strBuffer.append(value).append('\n');
                }
            } else {
                StringVisitor.this._strBuffer.append(value).append('\n');
            }
        }

        @Override
        public void visitEnd(SimulationKeyword keyword) {
            if (keyword != null) {
                StringVisitor.this._strBuffer.append("$end\n");
            }
        }

        @Override
        public void endSimulation() {
        }
    }
}

