/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.preferences;

import fr.inria.aoste.timesquare.vcd.VcdActivator;
import fr.inria.aoste.timesquare.vcd.preferences.ColorSelection;
import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import fr.inria.aoste.timesquare.vcd.view.figure.CountFigure;
import java.util.ArrayList;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class VCDeditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public VCDeditorPreferencePage() {
        super(0);
        this.setPreferenceStore(VcdActivator.getDefault().getPreferenceStore());
        this.setDescription("VCD editor : ");
    }

    protected Control createContents(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        c.setFont(parent.getFont());
        GridData gd = new GridData(4);
        gd.horizontalSpan = 1;
        c.setLayoutData((Object)gd);
        this.CreateVCDColor(c, "", VcdColorPreferences.getDefault().getSelection());
        this.CreateVCDColor(c, "printing", VcdColorPreferences.getDefault().getSelectionprint());
        Group length = new Group(c, 4);
        length.setLayout((Layout)new GridLayout(1, false));
        length.setFont(c.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        length.setLayoutData((Object)gd);
        length.setText("VCD length");
        IntegerFieldEditor ife = new IntegerFieldEditor("namesize", "Width of the column name", (Composite)length);
        ife.setValidRange(115, 300);
        this.addField((FieldEditor)ife);
        new Text(parent, 4).setText("Count Figure :" + CountFigure.countvalue());
        this.initialize();
        this.checkState();
        return c;
    }

    private int CreateVCDColor(Composite parent, String option, ColorSelection colsel) {
        ArrayList<FieldEditor> listfd = new ArrayList<FieldEditor>();
        Group vcd = new Group(parent, 4);
        vcd.setLayout((Layout)new GridLayout(1, true));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 5;
        vcd.setLayoutData((Object)gd);
        vcd.setText("VCD Color " + option);
        Composite list = new Composite((Composite)vcd, 0);
        GridLayout gde = new GridLayout(3, true);
        gde.horizontalSpacing = 10;
        list.setLayout((Layout)gde);
        gd = new GridData(1);
        gd.horizontalSpan = 0;
        gd.verticalSpan = 0;
        gd.verticalAlignment = 1;
        gd.grabExcessVerticalSpace = true;
        list.setLayoutData((Object)gd);
        Composite local1 = new Composite(list, 4);
        RowLayout rl = new RowLayout(512);
        rl.marginBottom = 2;
        rl.center = false;
        local1.setLayout((Layout)rl);
        local1.setLayoutData((Object)new GridData(2));
        Composite local2 = new Composite(list, 4);
        rl = new RowLayout(512);
        rl.marginBottom = 2;
        rl.center = false;
        local2.setLayout((Layout)rl);
        local2.setLayoutData((Object)new GridData(2));
        Composite local3 = new Composite(list, 4);
        rl = new RowLayout(512);
        rl.marginBottom = 2;
        rl.center = false;
        local3.setLayout((Layout)rl);
        local3.setLayoutData((Object)new GridData(2));
        int n = 0;
        for (ColorSelection.ColorData cd : colsel.getArrayColor()) {
            Composite tmp = null;
            if (n == 0) {
                tmp = local1;
            }
            if (n == 1) {
                tmp = local2;
            }
            if (n == 2) {
                tmp = local3;
            }
            ColorFieldEditor fd = new ColorFieldEditor(cd.name, cd.title, tmp);
            this.addField((FieldEditor)fd);
            listfd.add((FieldEditor)fd);
            if (++n != 3) continue;
            n = 0;
        }
        Button but = new Button((Composite)vcd, 0);
        but.setText("Restore Default Color");
        but.addSelectionListener((SelectionListener)new RestoreColor(colsel, listfd));
        local1.pack();
        local2.pack();
        local1.layout();
        local2.layout();
        vcd.pack();
        return 0;
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
    }

    public static final class RestoreColor
    implements SelectionListener {
        ColorSelection sel;
        ArrayList<FieldEditor> listfd;

        public void widgetDefaultSelected(SelectionEvent e) {
            this.sel.defaultColor();
        }

        public RestoreColor(ColorSelection in, ArrayList<FieldEditor> list) {
            this.sel = in;
            this.listfd = list;
        }

        public void widgetSelected(SelectionEvent e) {
            this.sel.defaultColor();
            for (FieldEditor fe : this.listfd) {
                fe.loadDefault();
            }
        }
    }
}

