/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.java;

import java.util.HashMap;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.Database;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.IndexException;

public abstract class TagTreeReader {
    public static final int[] UNUSED_RESULT = new int[1];
    private TagHandler<?>[] readers = new TagHandler[256];
    private Map<TagHandler<?>, Integer> values = new HashMap();

    public final void add(byte key, TagHandler<?> reader) {
        this.readers[key] = reader;
        this.values.put(reader, Integer.valueOf(key));
    }

    public final Object read(Nd nd, long address) {
        return this.read(nd, address, UNUSED_RESULT);
    }

    public final Object read(Nd nd, long address, int[] bytesRead) {
        long readAddress = address;
        Database db = nd.getDB();
        byte nextByte = db.getByte(address);
        ++readAddress;
        TagHandler<?> reader = this.readers[nextByte];
        if (reader == null) {
            throw nd.describeProblem().addProblemAddress("tag", address, 1).build("Found unknown tag with value " + nextByte + " at address " + address);
        }
        return reader.read(nd, readAddress, this, bytesRead);
    }

    protected abstract byte getKeyFor(Object var1);

    public final void write(Nd nd, long address, Object toWrite) {
        this.write(nd, address, toWrite, UNUSED_RESULT);
    }

    public final void write(Nd nd, long address, Object toWrite, int[] bytesWritten) {
        byte key = this.getKeyFor(toWrite);
        TagHandler<?> handler = this.readers[key];
        if (handler == null) {
            throw nd.describeProblem().build("Invalid key " + key + " returned from getKeyFor(...)");
        }
        handler.write(nd, address, this, toWrite, bytesWritten);
    }

    public final void destruct(Nd nd, long address) {
        Database db = nd.getDB();
        long readAddress = address;
        byte nextByte = db.getByte(readAddress);
        ++readAddress;
        TagHandler<?> handler = this.readers[nextByte];
        if (handler == null) {
            throw nd.describeProblem().addProblemAddress("tag", address, 1).build("Found unknown tag with value " + nextByte + " at address " + address);
        }
        handler.destruct(nd, readAddress, this);
    }

    public final int getSize(Nd nd, Object toMeasure) {
        byte key = this.getKeyFor(toMeasure);
        TagHandler<?> handler = this.readers[key];
        if (handler == null) {
            throw new IndexException("Attempted to get size of object " + toMeasure.toString() + " with unknown key " + key);
        }
        return handler.getSize(nd, toMeasure, this);
    }

    public static abstract class FixedSizeTagHandler<T>
    extends TagHandler<T> {
        protected abstract T read(Nd var1, long var2);

        protected abstract void write(Nd var1, long var2, T var4);

        protected abstract int getSize();

        protected void destruct(Nd nd, long address) {
        }

        @Override
        public final T read(Nd nd, long address, TagTreeReader reader, int[] bytesRead) {
            bytesRead[0] = this.getSize();
            return this.read(nd, address);
        }

        @Override
        public final void write(Nd nd, long address, TagTreeReader reader, T value, int[] bytesWritten) {
            bytesWritten[0] = this.getSize();
            this.write(nd, address, value);
        }

        @Override
        public final int getSize(Nd nd, T object, TagTreeReader reader) {
            return this.getSize();
        }

        @Override
        public final void destruct(Nd nd, long address, TagTreeReader reader) {
            this.destruct(nd, address);
        }
    }

    public static abstract class TagHandler<T> {
        public abstract T read(Nd var1, long var2, TagTreeReader var4, int[] var5);

        public abstract void write(Nd var1, long var2, TagTreeReader var4, T var5, int[] var6);

        public abstract int getSize(Nd var1, T var2, TagTreeReader var3);

        public void destruct(Nd nd, long address, TagTreeReader reader) {
        }
    }
}

