/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.IOException;
import org.aspectj.weaver.CompressingDataOutputStream;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.patterns.PatternNode;
import org.aspectj.weaver.patterns.PatternNodeVisitor;
import org.aspectj.weaver.patterns.TypeVariablePattern;

public class TypeVariablePatternList
extends PatternNode {
    public static final TypeVariablePatternList EMPTY = new TypeVariablePatternList(new TypeVariablePattern[0]);
    private TypeVariablePattern[] patterns;

    public TypeVariablePatternList(TypeVariablePattern[] typeVars) {
        this.patterns = typeVars;
    }

    public TypeVariablePattern[] getTypeVariablePatterns() {
        return this.patterns;
    }

    public TypeVariablePattern lookupTypeVariable(String name) {
        int i = 0;
        while (i < this.patterns.length) {
            if (this.patterns[i].getName().equals(name)) {
                return this.patterns[i];
            }
            ++i;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.patterns == null || this.patterns.length == 0;
    }

    @Override
    public void write(CompressingDataOutputStream s) throws IOException {
        s.writeInt(this.patterns.length);
        int i = 0;
        while (i < this.patterns.length) {
            this.patterns[i].write(s);
            ++i;
        }
        this.writeLocation(s);
    }

    public static TypeVariablePatternList read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        TypeVariablePatternList ret = EMPTY;
        int length = s.readInt();
        if (length > 0) {
            TypeVariablePattern[] patterns = new TypeVariablePattern[length];
            int i = 0;
            while (i < patterns.length) {
                patterns[i] = TypeVariablePattern.read(s, context);
                ++i;
            }
            ret = new TypeVariablePatternList(patterns);
        }
        ret.readLocation(context, s);
        return ret;
    }

    @Override
    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public Object traverse(PatternNodeVisitor visitor, Object data) {
        Object ret = this.accept(visitor, data);
        int i = 0;
        while (i < this.patterns.length) {
            this.patterns[i].traverse(visitor, ret);
            ++i;
        }
        return ret;
    }
}

