/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.progress;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.util.SWTUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.internal.progress.ProgressMessages;

public class JobProgressInfoComposite
extends Composite {
    private ProgressBar progressBar;
    private Label jobImageLabel;
    private Label jobNameLabel;
    private Label taskNameLabel;
    private ToolBar actionBar;
    private ToolItem actionButton;
    private final Job job;
    private final TaskNameUpdater taskNameUpdater = new TaskNameUpdater();
    private final PercentUpdater percentUpdater = new PercentUpdater();

    public JobProgressInfoComposite(Job job, Composite parent, int progressBarStyle, int style) {
        super(parent, style);
        this.job = job;
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 2;
        gridLayout.marginBottom = 2;
        gridLayout.marginLeft = 2;
        gridLayout.marginRight = 2;
        gridLayout.verticalSpacing = 2;
        gridLayout.horizontalSpacing = 2;
        this.setLayout((Layout)gridLayout);
        Image jobImage = EMFCompareIDEUIPlugin.getImage("icons/full/eobj16/task.gif");
        this.jobNameLabel = new Label((Composite)this, 0);
        int horizontalIndent = jobImage.getBounds().width + 2;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = horizontalIndent;
        gridData.horizontalSpan = 3;
        this.jobNameLabel.setLayoutData((Object)gridData);
        this.jobNameLabel.setText(job.getName());
        this.jobImageLabel = new Label((Composite)this, 0);
        this.jobImageLabel.setImage(jobImage);
        this.jobImageLabel.setLayoutData((Object)new GridData());
        this.progressBar = new ProgressBar((Composite)this, 0x100 | progressBarStyle);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.progressBar.setLayoutData((Object)gridData);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.actionBar = new ToolBar((Composite)this, 0x800000);
        this.actionBar.setCursor(this.getDisplay().getSystemCursor(0));
        this.actionBar.setLayoutData((Object)new GridData());
        this.actionButton = new ToolItem(this.actionBar, 0);
        this.actionButton.setToolTipText(ProgressMessages.NewProgressView_CancelJobToolTip);
        this.actionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobProgressInfoComposite.this.actionButton.setEnabled(false);
                JobProgressInfoComposite.this.job.cancel();
            }
        });
        this.actionButton.setImage(EMFCompareIDEUIPlugin.getImage("icons/full/eobj16/stop.gif"));
        this.actionButton.setDisabledImage(EMFCompareIDEUIPlugin.getImage("icons/full/dobj16/stop.gif"));
        this.taskNameLabel = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = horizontalIndent;
        gridData.horizontalSpan = 3;
        this.taskNameLabel.setLayoutData((Object)gridData);
    }

    void init() {
        SWTUtil.safeAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!JobProgressInfoComposite.this.taskNameLabel.isDisposed() && !JobProgressInfoComposite.this.progressBar.isDisposed()) {
                    JobProgressInfoComposite.this.actionButton.setEnabled(true);
                    JobProgressInfoComposite.this.progressBar.setSelection(0);
                }
            }
        });
    }

    public void setTaskName(String taskName) {
        this.taskNameUpdater.setTaskName(taskName);
    }

    public void setPercentDone(int percent) {
        this.percentUpdater.setPercent(percent);
    }

    private class PercentUpdater
    implements Runnable {
        final AtomicInteger percent = new AtomicInteger(-1);

        private PercentUpdater() {
        }

        @Override
        public void run() {
            int newPercent = this.percent.getAndSet(-1);
            if (!JobProgressInfoComposite.this.progressBar.isDisposed()) {
                JobProgressInfoComposite.this.progressBar.setSelection(newPercent);
            }
        }

        public void setPercent(int percent) {
            int oldPercent = this.percent.getAndSet(percent);
            if (oldPercent == -1) {
                SWTUtil.safeAsyncExec((Runnable)this);
            }
        }
    }

    private class TaskNameUpdater
    implements Runnable {
        final AtomicReference<String> taskName = new AtomicReference();

        private TaskNameUpdater() {
        }

        @Override
        public void run() {
            String newTaskName = this.taskName.getAndSet(null);
            if (!JobProgressInfoComposite.this.taskNameLabel.isDisposed() && !JobProgressInfoComposite.this.isDisposed()) {
                JobProgressInfoComposite.this.taskNameLabel.setText(newTaskName);
                JobProgressInfoComposite.this.layout();
            }
        }

        public void setTaskName(String taskName) {
            String oldTaskName = this.taskName.getAndSet(taskName);
            if (oldTaskName == null) {
                SWTUtil.safeAsyncExec((Runnable)this);
            }
        }
    }
}

