/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.serialization;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class Serializer {
    public static String toString(EStructuralFeature feature) {
        StringBuffer result = new StringBuffer();
        result.append(feature.getEType().getName());
        result.append(" ");
        result.append(feature.getName());
        String initialValue = EcoreUtil.getAnnotation((EModelElement)feature, (String)"http://implementation/", (String)"initial");
        if (initialValue != null) {
            result.append(" := ");
            result.append(initialValue);
        }
        result.append(";");
        return result.toString();
    }

    public static String toString(EOperation operation) {
        StringBuffer result = new StringBuffer();
        String body = EcoreUtil.getAnnotation((EModelElement)operation, (String)"http://implementation/", (String)"body");
        if (body != null) {
            result.append("override ");
            if (operation.getEType() == null) {
                result.append("void");
            } else {
                result.append(operation.getEType().getName());
            }
            result.append(" ");
            result.append(operation.getName());
            result.append(operation.getEParameters().stream().map(param -> String.valueOf(param.getEType().getName()) + " " + param.getName()).collect(Collectors.joining(", ", "(", ")")));
            if (!body.startsWith("{")) {
                result.append("{\n");
            }
            result.append(body);
            if (!body.endsWith("}")) {
                result.append("}");
            }
        }
        return result.toString();
    }

    public static String runtimeToString(EClass cls) {
        StringBuffer result = new StringBuffer();
        if (EcoreUtil.getAnnotation((EModelElement)cls, (String)"http://implementation/", (String)"runtime") != null) {
            result.append("class ");
            result.append(cls.getName());
            result.append("{\n");
            cls.getEStructuralFeatures().forEach(feature -> {
                result.append(Serializer.toString(feature));
                result.append("\n");
            });
            cls.getEOperations().forEach(operation -> {
                result.append(Serializer.toString(operation));
                result.append("\n");
            });
            result.append("}");
        }
        return result.toString();
    }

    public static String openclassToString(EClass cls) {
        StringBuffer result = new StringBuffer();
        if (EcoreUtil.getAnnotation((EModelElement)cls, (String)"http://implementation/", (String)"runtime") == null) {
            ArrayList implems = new ArrayList();
            cls.getEOperations().forEach(operation -> {
                String implem = Serializer.toString(operation);
                if (!implem.isEmpty()) {
                    implems.add(implem);
                }
            });
            if (!implems.isEmpty()) {
                result.append("open class ");
                result.append(cls.getName());
                result.append("{\n");
                implems.forEach(implem -> {
                    result.append((String)implem);
                    result.append("{\n");
                });
                result.append("}");
            }
        }
        return result.toString();
    }
}

