/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecoretools.ale.core.parser.Dsl;
import org.osgi.framework.Bundle;

public class WorkbenchDsl
extends Dsl {
    public WorkbenchDsl(List<String> syntaxes, List<String> semantics) {
        super(syntaxes, semantics);
        this.resolveUris();
    }

    public WorkbenchDsl(String dslFile) throws FileNotFoundException {
        super(WorkbenchDsl.convertToFile(dslFile));
        this.resolveUris();
    }

    public WorkbenchDsl(InputStream input) {
        super(input);
        this.resolveUris();
    }

    private void resolveUris() {
        ArrayList newSemantics = new ArrayList();
        this.getAllSemantics().stream().forEach(elem -> {
            boolean bl = newSemantics.add(URI.createFileURI((String)WorkbenchDsl.convertToFile(elem)).toFileString());
        });
        this.getAllSemantics().clear();
        this.getAllSemantics().addAll(newSemantics);
    }

    public static String convertToFile(String path) {
        URI uri = URI.createURI((String)path);
        String res = null;
        if (uri.isPlatformResource()) {
            res = WorkbenchDsl.resourceToFile(uri);
            if (res == null) {
                res = WorkbenchDsl.pluginToFile(WorkbenchDsl.resourceToPlugin(uri));
            }
        } else if (uri.isPlatformPlugin()) {
            res = WorkbenchDsl.pluginToFile(uri);
        }
        if (res == null) {
            res = path;
        }
        return res;
    }

    private static String resourceToFile(URI uri) {
        IResource file;
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        if (ws != null && (file = ws.getRoot().findMember(uri.toPlatformString(true))) != null) {
            return file.getLocationURI().getRawPath();
        }
        return null;
    }

    private static String pluginToFile(URI uri) {
        String pluginName = uri.segment(1);
        String path = uri.toPlatformString(true).substring(pluginName.length() + 1);
        Bundle plugin = Platform.getBundle((String)pluginName);
        URL pluginURL = plugin.getEntry("/");
        try {
            String pluginFilePath = FileLocator.toFileURL((URL)pluginURL).getFile();
            return String.valueOf(pluginFilePath.toString()) + path.substring(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static URI resourceToPlugin(URI uri) {
        return URI.createPlatformPluginURI((String)uri.toPlatformString(true), (boolean)true);
    }
}

