/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.messagingsystem.api.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.MessagingSystem;
import org.eclipse.gemoc.commons.messagingsystem.api.reference.Reference;

public class StdioSimpleMessagingSystem
extends MessagingSystem {
    protected BufferedReader reader;

    @Override
    public void clearLog() {
    }

    @Override
    public void log(MessagingSystem.Kind msgKind, String message, String messageGroup) {
        if (messageGroup.isEmpty()) {
            System.out.println(message);
        } else {
            System.out.println(String.format("%7s [%s] %s %s", this.getKindString(msgKind), StdioSimpleMessagingSystem.shortenMessageGroup(messageGroup), message, this.getCallerString()));
        }
    }

    @Override
    public void log(MessagingSystem.Kind msgKind, String message, String messageGroup, Throwable throwable) {
        String stackTrace = "";
        StringWriter sw = new StringWriter();
        if (throwable != null) {
            throwable.printStackTrace(new PrintWriter(sw));
            stackTrace = "\n" + sw.toString();
        }
        if (messageGroup.isEmpty()) {
            System.out.println(String.valueOf(message) + stackTrace);
        } else {
            System.out.println(String.format("%7s [%s] %s %s\n%s", this.getKindString(msgKind), StdioSimpleMessagingSystem.shortenMessageGroup(messageGroup), message, this.getCallerString(), stackTrace));
        }
    }

    @Override
    public void logProblem(MessagingSystem.Kind msgKind, String message, String messageGroup, Reference causeObject) {
        System.out.println(String.valueOf(this.getKindString(msgKind)) + " [" + messageGroup + "] " + message + " " + causeObject + " " + this.getCallerString());
    }

    @Override
    public void logProblem(MessagingSystem.Kind msgKind, String message, String messageGroup, Throwable throwable, Reference causeObject) {
        String stackTrace = "";
        StringWriter sw = new StringWriter();
        if (throwable != null) {
            throwable.printStackTrace(new PrintWriter(sw));
            stackTrace = "\n" + sw.toString();
        }
        System.out.println(String.valueOf(this.getKindString(msgKind)) + " [" + messageGroup + "] " + message + " " + causeObject + " " + this.getCallerString() + stackTrace);
    }

    @Override
    public void initProgress(String progressGroup, String message, String messageGroup, int nbWorkUnit) {
        this.info("[BEGIN_" + progressGroup + "] " + message, messageGroup);
    }

    @Override
    public void progress(String progressGroup, String message, String messageGroup, int workedUnit) {
        this.info("[" + progressGroup + "] " + message, messageGroup);
    }

    @Override
    public void doneProgress(String progressGroup, String message, String messageGroup) {
        this.info("[END_" + progressGroup + "] " + message, messageGroup);
    }

    protected String getKindString(MessagingSystem.Kind kind) {
        switch (kind) {
            case UserINFO: {
                return "INFO";
            }
            case UserImportantINFO: {
                return "IMPORTANT";
            }
            case UserWARNING: {
                return "WARNING";
            }
            case UserERROR: {
                return "ERROR";
            }
            case DevINFO: {
                return "INFO";
            }
            case DevWARNING: {
                return "WARNING";
            }
            case DevERROR: {
                return "ERROR";
            }
            case DevDEBUG: {
                return "DEBUG";
            }
        }
        return "";
    }

    protected String getCallerString() {
        StackTraceElement[] stackTraceElements;
        Exception e = new Exception();
        StackTraceElement[] stackTraceElementArray = stackTraceElements = e.getStackTrace();
        int n = stackTraceElements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            if (!(stackTraceElement.getMethodName().equals("log") || stackTraceElement.getMethodName().equals("info") || stackTraceElement.getMethodName().equals("debug") || stackTraceElement.getMethodName().equals("warn") || stackTraceElement.getMethodName().equals("error") || stackTraceElement.getClassName().contains("org.eclipse.gemoc.commons.eclipse.messagingsystem") || stackTraceElement.getClassName().contains("org.eclipse.gemoc.commons.messagingsystem"))) {
                return stackTraceElement.toString();
            }
            ++n2;
        }
        return "";
    }

    @Override
    public void flushAllProblems(URL uri) {
    }

    @Override
    public void flushProblem(String messageGroup, URL uri) {
    }

    @Override
    public String readLine() {
        String result = "";
        try {
            InputStreamReader isr = new InputStreamReader(System.in);
            BufferedReader bufferedReader = new BufferedReader(isr);
            return bufferedReader.readLine();
        }
        catch (IOException e) {
            this.error("Failed to read line", "", e);
            return result;
        }
    }

    @Override
    public String readLine(String prompt) {
        this.info(prompt, "");
        return this.readLine();
    }

    @Override
    public BufferedReader getReader() {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(System.in));
        }
        return this.reader;
    }

    public static String shortenMessageGroup(String messageGroup) {
        StringBuilder sb = new StringBuilder();
        String[] f = messageGroup.split("\\.");
        int idx = 0;
        int limit = f.length - 2;
        String[] stringArray = f;
        int n = f.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (idx < limit && !string.isEmpty()) {
                sb.append(string.charAt(0));
            } else {
                sb.append(string);
            }
            if (idx < f.length - 1) {
                sb.append(".");
            }
            ++idx;
            ++n2;
        }
        return sb.toString();
    }
}

