/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.metamodel.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opsemanticsview.OperationalSemanticsView;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gemoc.trace.commons.EcoreCraftingUtil;
import org.eclipse.gemoc.trace.commons.ExecutionMetamodelTraceability;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMExplorer;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMGenerationTraceability;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMStrings;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TraceMMGeneratorStates {
    private final OperationalSemanticsView mmext;
    private final TraceMMExplorer traceMMExplorer;
    private final String languageName;
    private final boolean gemoc;
    private final EPackage tracemmresult;
    private final TraceMMGenerationTraceability traceability;
    private final Map<EClass, EClass> runtimeToTraced = new HashMap<EClass, EClass>();
    private final Set<EClass> allRuntimeClasses = new HashSet<EClass>();
    private final Set<EClass> allStaticClasses = new HashSet<EClass>();
    private final Set<EClass> allNewEClasses;
    private final Set<EClass> multipleOrig = new HashSet<EClass>();

    public TraceMMGeneratorStates(OperationalSemanticsView mmext, TraceMMGenerationTraceability traceability, TraceMMExplorer traceMMExplorer, String languageName, EPackage tracemmresult, boolean gemoc) {
        this.mmext = mmext;
        this.allNewEClasses = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)IteratorExtensions.toSet((Iterator)mmext.eAllContents()), EClass.class));
        this.traceability = traceability;
        this.traceMMExplorer = traceMMExplorer;
        this.languageName = languageName;
        this.tracemmresult = tracemmresult;
        this.gemoc = gemoc;
    }

    private void cleanup() {
        Set allCreatedEClasses = IteratorExtensions.toSet((Iterator)Iterators.filter((Iterator)this.tracemmresult.eAllContents(), EClass.class));
        for (EClass c : allCreatedEClasses) {
            this.cleanupAnnotations(c);
        }
        Iterable _filter = Iterables.filter(this.runtimeToTraced.values(), EReference.class);
        for (EReference r : _filter) {
            r.setEOpposite(null);
        }
    }

    public void process() {
        this.handleTraceClasses();
        this.cleanup();
    }

    private void cleanupAnnotations(EClass eClass) {
        boolean _notEquals;
        EAnnotation traceabilityAnnotation = ExecutionMetamodelTraceability.getTraceabilityAnnotation((EModelElement)eClass);
        eClass.getEAnnotations().clear();
        boolean bl = _notEquals = !Objects.equal((Object)traceabilityAnnotation, null);
        if (_notEquals) {
            eClass.getEAnnotations().add((Object)traceabilityAnnotation);
        }
    }

    private EPackage obtainTracedPackage(EPackage runtimePackage) {
        boolean _notEquals;
        EPackage result = this.traceMMExplorer.statesPackage;
        boolean bl = _notEquals = !Objects.equal((Object)runtimePackage, null);
        if (_notEquals) {
            EPackage tracedSuperPackage = this.obtainTracedPackage(runtimePackage.getESuperPackage());
            final String tracedPackageName = TraceMMStrings.package_createTracedPackage(runtimePackage);
            Functions.Function1<EPackage, Boolean> _function = new Functions.Function1<EPackage, Boolean>(){

                public Boolean apply(EPackage p) {
                    return p.getName().equals(tracedPackageName);
                }
            };
            result = (EPackage)IterableExtensions.findFirst((Iterable)tracedSuperPackage.getESubpackages(), (Functions.Function1)_function);
            boolean _equals = Objects.equal((Object)result, null);
            if (_equals) {
                result = EcoreFactory.eINSTANCE.createEPackage();
                result.setName(tracedPackageName);
                String _name = result.getName();
                String _plus = String.valueOf(this.languageName) + "_" + _name;
                result.setNsURI(_plus);
                result.setNsPrefix("");
                tracedSuperPackage.getESubpackages().add((Object)result);
            }
        }
        return result;
    }

    private String computeTraceabilityAnnotationValue(EClass extendedClass) {
        boolean _not;
        String traceabilityAnnotationValue = null;
        Functions.Function1<EStructuralFeature, Boolean> _function = new Functions.Function1<EStructuralFeature, Boolean>(){

            public Boolean apply(EStructuralFeature f) {
                return TraceMMGeneratorStates.this.mmext.getDynamicProperties().contains((Object)f);
            }
        };
        Set dynamicProperties = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)extendedClass.getEStructuralFeatures(), (Functions.Function1)_function));
        boolean _isEmpty = dynamicProperties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _notEquals;
            EStructuralFeature mutableProperty = ((EStructuralFeature[])Conversions.unwrapArray((Object)dynamicProperties, EStructuralFeature.class))[0];
            String mutablePropertyTraceabilityValue = ExecutionMetamodelTraceability.getTraceabilityAnnotationValue((EModelElement)mutableProperty);
            boolean bl2 = _notEquals = !Objects.equal((Object)mutablePropertyTraceabilityValue, null);
            if (_notEquals) {
                int classSubstringStartIndex = mutablePropertyTraceabilityValue.lastIndexOf("/");
                traceabilityAnnotationValue = mutablePropertyTraceabilityValue.substring(0, classSubstringStartIndex);
            }
        }
        return traceabilityAnnotationValue;
    }

    private boolean isInPackage(EPackage c, EPackage p) {
        boolean _notEquals;
        if (!Objects.equal((Object)c, null) && !Objects.equal((Object)p, null) && Objects.equal((Object)c, (Object)p)) {
            return true;
        }
        EPackage _eSuperPackage = c.getESuperPackage();
        boolean bl = _notEquals = !Objects.equal((Object)_eSuperPackage, null);
        if (_notEquals) {
            return this.isInPackage(c.getESuperPackage(), p);
        }
        return false;
    }

    private Set<EClass> getSubTypesOf(EClass c) {
        HashSet<EClass> result = new HashSet<EClass>();
        Iterable _filter = Iterables.filter((Iterable)IteratorExtensions.toSet((Iterator)this.mmext.getExecutionMetamodel().eAllContents()), EClass.class);
        for (EClass someEClass : _filter) {
            boolean _contains = someEClass.getESuperTypes().contains((Object)c);
            if (!_contains) continue;
            result.add(someEClass);
        }
        return result;
    }

    private void getAllInheritance(Set<EClass> result, EClass c) {
        boolean _not;
        boolean _contains = result.contains(c);
        boolean bl = _not = !_contains;
        if (_not) {
            result.add(c);
            EList _eSuperTypes = c.getESuperTypes();
            for (EClass sup : _eSuperTypes) {
                this.getAllInheritance(result, sup);
            }
            Set<EClass> _subTypesOf = this.getSubTypesOf(c);
            for (EClass sub : _subTypesOf) {
                this.getAllInheritance(result, sub);
            }
        }
    }

    private Set<EClass> getAllInheritance(EClass c) {
        HashSet<EClass> result = new HashSet<EClass>();
        this.getAllInheritance(result, c);
        return result;
    }

    private void handleTraceClasses() {
        Object _function_2;
        EList _dynamicProperties = this.mmext.getDynamicProperties();
        for (EStructuralFeature dp : _dynamicProperties) {
            EClass extendedExistingClass = dp.getEContainingClass();
            this.allRuntimeClasses.add(extendedExistingClass);
            Set<EClass> allInheritance = this.getAllInheritance(extendedExistingClass);
            this.allRuntimeClasses.addAll(allInheritance);
        }
        final HashMap<EClass, EClass> baseClassToNewEClass = new HashMap<EClass, EClass>();
        for (final EClass c : this.allNewEClasses) {
            Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass cls) {
                    String _name = cls.getName();
                    String _name_1 = c.getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                }
            };
            baseClassToNewEClass.put((EClass)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)IteratorExtensions.toSet((Iterator)this.mmext.getExecutionMetamodel().eAllContents()), EClass.class), (Functions.Function1)_function), c);
        }
        for (final EClass c_1 : this.allNewEClasses) {
            Functions.Function1<EClass, Boolean> _function_1 = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass cls) {
                    String _name = cls.getName();
                    String _name_1 = c_1.getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                }
            };
            Set<EClass> allInheritance = this.getAllInheritance((EClass)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)IteratorExtensions.toSet((Iterator)this.mmext.getExecutionMetamodel().eAllContents()), EClass.class), (Functions.Function1)_function_1));
            Functions.Function1<EClass, EClass> _function_22 = new Functions.Function1<EClass, EClass>(){

                public EClass apply(EClass cls) {
                    EClass _xblockexpression = null;
                    EClass newEClass = (EClass)baseClassToNewEClass.get(cls);
                    EClass _xifexpression = null;
                    boolean _equals = Objects.equal((Object)newEClass, null);
                    _xifexpression = _equals ? cls : newEClass;
                    _xblockexpression = _xifexpression;
                    return _xblockexpression;
                }
            };
            Iterables.addAll(this.allRuntimeClasses, (Iterable)IterableExtensions.map(allInheritance, (Functions.Function1)_function_22));
        }
        Functions.Function1<EClass, Boolean> _function_1 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                boolean _contains = TraceMMGeneratorStates.this.allRuntimeClasses.contains(c);
                return !_contains;
            }
        };
        Iterables.addAll(this.allStaticClasses, (Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)IteratorExtensions.toSet((Iterator)this.mmext.getExecutionMetamodel().eAllContents()), EClass.class), (Functions.Function1)_function_1));
        for (EClass rc : this.allRuntimeClasses) {
            _function_2 = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass c) {
                    return !c.isAbstract() && TraceMMGeneratorStates.this.allRuntimeClasses.contains(c);
                }
            };
            Set concreteSuperTypes = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)rc.getEAllSuperTypes(), (Functions.Function1)_function_2));
            this.multipleOrig.addAll(concreteSuperTypes);
        }
        ArrayList<EClass> tracedClasses = new ArrayList<EClass>();
        List runtimeClasses = IterableExtensions.toList(this.allRuntimeClasses);
        _function_2 = new Functions.Function1<EClass, String>(){

            public String apply(EClass it) {
                return it.getName();
            }
        };
        List runtimeClassesSorted = IterableExtensions.sortBy((Iterable)runtimeClasses, (Functions.Function1)_function_2);
        for (EClass runtimeClass : runtimeClassesSorted) {
            EClass tracedClass = this.handleTraceClass(runtimeClass);
            tracedClasses.add(tracedClass);
        }
    }

    private EClass handleTraceClass(EClass runtimeClass) {
        boolean _not_1;
        boolean _not;
        boolean _contains = this.allRuntimeClasses.contains(runtimeClass);
        boolean bl = _not = !_contains;
        if (_not) {
            return runtimeClass;
        }
        boolean _containsKey = this.runtimeToTraced.containsKey(runtimeClass);
        boolean bl2 = _not_1 = !_containsKey;
        if (_not_1) {
            boolean _not_3;
            EClass tracedClass = EcoreFactory.eINSTANCE.createEClass();
            tracedClass.setName(TraceMMStrings.class_createTraceClassName(runtimeClass));
            tracedClass.setAbstract(runtimeClass.isAbstract() || runtimeClass.isInterface());
            this.runtimeToTraced.put(runtimeClass, tracedClass);
            this.traceability.putTracedClasses(runtimeClass, tracedClass);
            Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass t) {
                    return TraceMMGeneratorStates.this.allRuntimeClasses.contains(t);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)runtimeClass.getESuperTypes(), (Functions.Function1)_function);
            for (EClass superType : _filter) {
                EClass tracedSuperType = this.handleTraceClass(superType);
                tracedClass.getESuperTypes().add((Object)tracedSuperType);
            }
            boolean _contains_1 = this.allNewEClasses.contains(runtimeClass);
            boolean notNewClass = !_contains_1;
            boolean _isAbstract = tracedClass.isAbstract();
            boolean notAbstract = !_isAbstract;
            boolean _isEmpty = tracedClass.getESuperTypes().isEmpty();
            if (_isEmpty) {
                EGenericType tracedObjectGenericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
                tracedObjectGenericSuperType.setEClassifier((EClassifier)this.traceMMExplorer.specificTracedObjectClass);
                EGenericType dimensionClassTracedObjectTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
                tracedObjectGenericSuperType.getETypeArguments().add((Object)dimensionClassTracedObjectTypeBinding);
                dimensionClassTracedObjectTypeBinding.setEClassifier((EClassifier)this.traceMMExplorer.specificDimensionClass);
                dimensionClassTracedObjectTypeBinding.getETypeArguments().add((Object)EcoreFactory.eINSTANCE.createEGenericType());
                tracedClass.getEGenericSuperTypes().add((Object)tracedObjectGenericSuperType);
            }
            EPackage tracedPackage = this.obtainTracedPackage(runtimeClass.getEPackage());
            tracedPackage.getEClassifiers().add((Object)tracedClass);
            Functions.Function1<EStructuralFeature, Boolean> _function_1 = new Functions.Function1<EStructuralFeature, Boolean>(){

                public Boolean apply(EStructuralFeature f) {
                    return TraceMMGeneratorStates.this.mmext.getDynamicProperties().contains((Object)f);
                }
            };
            Iterable dynamicProperties = IterableExtensions.filter((Iterable)runtimeClass.getEStructuralFeatures(), (Functions.Function1)_function_1);
            if (notNewClass && !IterableExtensions.isEmpty((Iterable)dynamicProperties)) {
                boolean _notEquals;
                String traceabilityAnnotationValue = this.computeTraceabilityAnnotationValue(runtimeClass);
                boolean bl3 = _notEquals = !Objects.equal((Object)traceabilityAnnotationValue, null);
                if (_notEquals) {
                    ExecutionMetamodelTraceability.createTraceabilityAnnotation((EModelElement)tracedClass, (String)traceabilityAnnotationValue);
                }
            }
            Functions.Function1<EClass, Boolean> _function_2 = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass c) {
                    return !TraceMMGeneratorStates.this.allRuntimeClasses.contains(c) || c.isAbstract();
                }
            };
            boolean onlyAbstractSuperTypes = IterableExtensions.forall((Iterable)runtimeClass.getEAllSuperTypes(), (Functions.Function1)_function_2);
            if (notNewClass && notAbstract && onlyAbstractSuperTypes) {
                String _xifexpression = null;
                boolean _contains_2 = this.multipleOrig.contains(runtimeClass);
                _xifexpression = _contains_2 ? TraceMMStrings.ref_OriginalObject_MultipleInheritance(runtimeClass) : "originalObject";
                String refName = _xifexpression;
                EReference ref = EcoreCraftingUtil.addReferenceToClass((EClass)tracedClass, (String)refName, (EClass)runtimeClass);
                this.traceability.addRefs_originalObject(tracedClass, ref);
            }
            HashSet runtimeProperties = new HashSet();
            boolean _contains_3 = this.allNewEClasses.contains(runtimeClass);
            if (_contains_3) {
                runtimeProperties.addAll(runtimeClass.getEStructuralFeatures());
            } else {
                boolean _not_2;
                boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)dynamicProperties);
                boolean bl4 = _not_2 = !_isEmpty_1;
                if (_not_2) {
                    Iterables.addAll(runtimeProperties, (Iterable)dynamicProperties);
                }
            }
            boolean _isEmpty_2 = runtimeProperties.isEmpty();
            boolean bl5 = _not_3 = !_isEmpty_2;
            if (_not_3) {
                this.traceability.addRuntimeClass(runtimeClass);
            }
            ArrayList<String> dimensionsGetters = new ArrayList<String>();
            for (EStructuralFeature runtimeProperty : runtimeProperties) {
                EStructuralFeature _copy;
                this.traceability.addMutableProperty(runtimeClass, runtimeProperty);
                EClass valueClass = EcoreFactory.eINSTANCE.createEClass();
                valueClass.setName(TraceMMStrings.class_createStateClassName(runtimeClass, runtimeProperty));
                EStructuralFeature copiedProperty = _copy = (EStructuralFeature)EcoreUtil.copy((EObject)runtimeProperty);
                if (copiedProperty instanceof EReference) {
                    ((EReference)copiedProperty).setContainment(false);
                    ((EReference)copiedProperty).setEOpposite(null);
                    EClassifier _eType = runtimeProperty.getEType();
                    ((EReference)copiedProperty).setEType((EClassifier)this.handleTraceClass((EClass)_eType));
                    ((EReference)copiedProperty).setDerived(false);
                    ((EReference)copiedProperty).setChangeable(true);
                    ((EReference)copiedProperty).setVolatile(false);
                    EGenericType valueGenericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
                    valueGenericSuperType.setEClassifier((EClassifier)this.traceMMExplorer.specificReferenceValueClass);
                    EGenericType valueTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
                    valueGenericSuperType.getETypeArguments().add((Object)valueTypeBinding);
                    valueTypeBinding.setEClassifier(((EReference)copiedProperty).getEType());
                    valueClass.getEGenericSuperTypes().add((Object)valueGenericSuperType);
                } else {
                    valueClass.getESuperTypes().add((Object)this.traceMMExplorer.specificAttributeValueClass);
                }
                valueClass.getEStructuralFeatures().add((Object)copiedProperty);
                this.traceMMExplorer.statesPackage.getEClassifiers().add((Object)valueClass);
                this.traceability.putMutablePropertyToValueProperty(runtimeProperty, copiedProperty);
                ExecutionMetamodelTraceability.createTraceabilityAnnotation((EModelElement)valueClass, (String)ExecutionMetamodelTraceability.getTraceabilityAnnotationValue((EModelElement)runtimeProperty));
                EClass dimensionClass = EcoreFactory.eINSTANCE.createEClass();
                dimensionClass.setName(TraceMMStrings.class_createDimensionClassName(runtimeClass, runtimeProperty));
                EGenericType dimensionGenericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
                dimensionGenericSuperType.setEClassifier((EClassifier)this.traceMMExplorer.specificDimensionClass);
                EGenericType dimensionTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
                dimensionGenericSuperType.getETypeArguments().add((Object)dimensionTypeBinding);
                dimensionTypeBinding.setEClassifier((EClassifier)valueClass);
                dimensionClass.getEGenericSuperTypes().add((Object)dimensionGenericSuperType);
                this.traceMMExplorer.statesPackage.getEClassifiers().add((Object)dimensionClass);
                EReference dimensionRef = EcoreCraftingUtil.addReferenceToClass((EClass)tracedClass, (String)StringExtensions.toFirstLower((String)dimensionClass.getName()), (EClass)dimensionClass);
                dimensionRef.setContainment(true);
                dimensionRef.setLowerBound(0);
                dimensionRef.setUpperBound(1);
                dimensionsGetters.add(EcoreCraftingUtil.stringGetter((EStructuralFeature)dimensionRef));
                this.traceability.putDimensionClass(runtimeProperty, dimensionClass);
                this.traceability.putDimensionRef(runtimeProperty, dimensionRef);
                this.traceability.putValueClass(runtimeProperty, valueClass);
            }
            EOperation getDimensionsInternal = EcoreFactory.eINSTANCE.createEOperation();
            EAnnotation getDimensionsAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            getDimensionsInternal.getEAnnotations().add((Object)getDimensionsAnnotation);
            getDimensionsInternal.setName("getDimensionsInternal");
            getDimensionsInternal.setLowerBound(0);
            getDimensionsInternal.setUpperBound(-1);
            EGenericType dimensionGenericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
            dimensionGenericSuperType.setEClassifier((EClassifier)this.traceMMExplorer.specificDimensionClass);
            EGenericType dimensionTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
            dimensionGenericSuperType.getETypeArguments().add((Object)dimensionTypeBinding);
            getDimensionsInternal.setEGenericType(dimensionGenericSuperType);
            getDimensionsAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
            EMap _details = getDimensionsAnnotation.getDetails();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("final EList<SpecificDimension<?>> result = new org.eclipse.emf.ecore.util.BasicInternalEList<SpecificDimension<?>>(Object.class);");
            _builder.newLine();
            _builder.append("result.addAll(super.getDimensionsInternal());");
            _builder.newLine();
            for (String getter : dimensionsGetters) {
                _builder.append("result.add(");
                _builder.append(getter);
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("return result;");
            _builder.newLine();
            _details.put((Object)"body", (Object)_builder.toString());
            tracedClass.getEOperations().add((Object)getDimensionsInternal);
            return tracedClass;
        }
        return this.runtimeToTraced.get(runtimeClass);
    }
}

