/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.m2e.editor.MavenEditorPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenEditorImages {
    private static final Logger log = LoggerFactory.getLogger(MavenEditorImages.class);
    public static final Image IMG_CLEAR = MavenEditorImages.createImage("clear.gif");
    public static final Image IMG_CLEAR_DISABLED = MavenEditorImages.createImage("clear_disabled.gif");
    public static final Image IMG_PROJECT = MavenEditorImages.createImage("project_obj.gif");
    public static final Image IMG_JAR = MavenEditorImages.createImage("jar_obj.gif");
    public static final Image IMG_INHERITED = MavenEditorImages.createImage("inherited_obj.gif");
    public static final Image IMG_REPOSITORY = MavenEditorImages.createImage("repository_obj.gif");
    public static final Image IMG_PLUGIN = MavenEditorImages.createImage("plugin_obj.gif");
    public static final Image IMG_EXECUTION = MavenEditorImages.createImage("execution_obj.gif");
    public static final Image IMG_GOAL = MavenEditorImages.createImage("goal_obj.gif");
    public static final Image IMG_FILTER = MavenEditorImages.createImage("filter_obj.gif");
    public static final Image IMG_RESOURCE = MavenEditorImages.createImage("resource_obj.gif");
    public static final Image IMG_INCLUDE = MavenEditorImages.createImage("include_obj.gif");
    public static final Image IMG_EXCLUDE = MavenEditorImages.createImage("exclude_obj.gif");
    public static final Image IMG_PERSON = MavenEditorImages.createImage("person_obj.gif");
    public static final Image IMG_ROLE = MavenEditorImages.createImage("role_obj.gif");
    public static final Image IMG_PROPERTY = MavenEditorImages.createImage("property_obj.gif");
    public static final Image IMG_REPORT = MavenEditorImages.createImage("report_obj.gif");
    public static final Image IMG_PROFILE = MavenEditorImages.createImage("profile_obj.gif");
    public static final Image IMG_SCOPE = MavenEditorImages.createImage("scope_obj.gif");
    public static final ImageDescriptor REFRESH = MavenEditorImages.create("refresh.gif");
    public static final ImageDescriptor COLLAPSE_ALL = MavenEditorImages.create("collapseall.gif");
    public static final ImageDescriptor EXPAND_ALL = MavenEditorImages.create("expandall.gif");
    public static final ImageDescriptor SHOW_GROUP = MavenEditorImages.create("show_group.gif");
    public static final ImageDescriptor SHOW_INHERITED_DEPENDENCIES = MavenEditorImages.create("show_inherited_dependencies.gif");
    public static final ImageDescriptor ADD_MODULE = MavenEditorImages.create("new_project.gif");
    public static final ImageDescriptor ADD_ARTIFACT = MavenEditorImages.create("new_jar.gif");
    public static final ImageDescriptor SELECT_ARTIFACT = MavenEditorImages.create("select_jar.gif");
    public static final ImageDescriptor ADD_PLUGIN = MavenEditorImages.create("new_plugin.gif");
    public static final ImageDescriptor SELECT_PLUGIN = MavenEditorImages.create("select_plugin.gif");
    public static final ImageDescriptor SORT = MavenEditorImages.create("sort.gif");
    public static final ImageDescriptor FILTER = MavenEditorImages.create("filter.gif");
    public static final ImageDescriptor EFFECTIVE_POM = MavenEditorImages.create("effective_pom.gif");
    public static final ImageDescriptor PARENT_POM = MavenEditorImages.create("parent_pom.gif");
    public static final ImageDescriptor WEB_PAGE = MavenEditorImages.create("web.gif");
    public static final ImageDescriptor HIERARCHY = MavenEditorImages.create("hierarchy.gif");
    public static final ImageDescriptor SCOPE = MavenEditorImages.create("scope.gif");
    public static final ImageDescriptor ADVANCED_TABS = MavenEditorImages.create("advanced_tabs.gif");
    public static final ImageDescriptor ELEMENT_OBJECT = MavenEditorImages.create("element_obj.gif");

    private static ImageDescriptor create(String key) {
        try {
            ImageDescriptor imageDescriptor = MavenEditorImages.createDescriptor(key);
            ImageRegistry imageRegistry = MavenEditorImages.getImageRegistry();
            if (imageRegistry != null) {
                imageRegistry.put(key, imageDescriptor);
            }
            return imageDescriptor;
        }
        catch (Exception ex) {
            log.error(key, (Throwable)ex);
            return null;
        }
    }

    private static Image createImage(String key) {
        MavenEditorImages.create(key);
        ImageRegistry imageRegistry = MavenEditorImages.getImageRegistry();
        return imageRegistry == null ? null : imageRegistry.get(key);
    }

    private static ImageRegistry getImageRegistry() {
        MavenEditorPlugin plugin = MavenEditorPlugin.getDefault();
        return plugin == null ? null : plugin.getImageRegistry();
    }

    private static ImageDescriptor createDescriptor(String image) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.m2e.editor", (String)("icons/" + image));
    }
}

