/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IPresetFactory;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.PresetDefinition;
import org.eclipse.wst.common.project.facet.core.internal.DefaultFacetsExtensionPoint;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigurationPresetFactory
implements IPresetFactory {
    public static final String PRESET_ID = "default.configuration";

    @Override
    public PresetDefinition createPreset(String presetId, Map<String, Object> context) throws CoreException {
        String description;
        String label;
        IFacetedProjectBase fproj = (IFacetedProjectBase)context.get("CONTEXT_KEY_FACETED_PROJECT");
        IRuntime runtime = fproj.getPrimaryRuntime();
        if (runtime != null) {
            label = Resources.bind((String)Resources.presetLabel, (Object)runtime.getLocalizedName());
            description = Resources.bind((String)Resources.presetDescription, (Object)runtime.getLocalizedName());
        } else {
            label = Resources.presetLabelNoRuntime;
            description = Resources.presetDescriptionNoRuntime;
        }
        Set<IProjectFacetVersion> facets = DefaultFacetsExtensionPoint.getDefaultFacets(fproj);
        if (facets == null) {
            return null;
        }
        return new PresetDefinition(label, description, facets);
    }

    private static final class Resources
    extends NLS {
        public static String presetLabel;
        public static String presetDescription;
        public static String presetLabelNoRuntime;
        public static String presetDescriptionNoRuntime;

        static {
            Resources.initializeMessages((String)DefaultConfigurationPresetFactory.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

