/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.clocktree.generator;

import fr.inria.aoste.timesquare.ccslkernel.clocktree.generator.VertexKind;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class CoincidentClocks
extends ArrayList<InstantiatedElement> {
    private static final long serialVersionUID = 8298231586333190464L;
    private final int hashCode = System.identityHashCode(this);
    private VertexKind kind = VertexKind.ClockSet;

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CoincidentClocks)) {
            return false;
        }
        return this.hashCode == ((CoincidentClocks)o).hashCode;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean add(InstantiatedElement e) {
        if (this.contains(e)) {
            return false;
        }
        return super.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends InstantiatedElement> lce) {
        for (InstantiatedElement instantiatedElement : lce) {
            this.add(instantiatedElement);
        }
        return true;
    }

    public VertexKind getKind() {
        return this.kind;
    }

    public void setKind(VertexKind kind) {
        this.kind = kind;
    }

    public String getVertexLabel() {
        if (this.kind == VertexKind.ImplicitSuperClock) {
            return "ImplicitSuperClock";
        }
        StringBuilder res = new StringBuilder("");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            InstantiatedElement c = (InstantiatedElement)it.next();
            if (c == null) continue;
            if (c.isClock()) {
                res.append(c.getInstantiationPath().getLast().getName());
            } else if (c.isExpression()) {
                if (c.isTopLevel()) {
                    res.append(c.getInstantiationPath().getLast().getName());
                } else {
                    res.append("IC");
                    res.append(c.getId());
                }
            } else {
                res.append(c.getQualifiedName("::"));
            }
            if (!it.hasNext()) continue;
            res.append("==");
        }
        return res.toString();
    }

    public String getLongVertexLabel() {
        if (this.kind == VertexKind.ImplicitSuperClock) {
            return "ImplicitSuperClock";
        }
        StringBuilder res = new StringBuilder("");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            InstantiatedElement c = (InstantiatedElement)it.next();
            if (c == null) continue;
            res.append(c.getQualifiedName("::"));
            if (!it.hasNext()) continue;
            res.append("==");
        }
        return res.toString();
    }

    public Color getEdgeColor(Display d) {
        switch (this.kind) {
            case ClockSet: {
                return new Color((Device)d, 0, 0, 255);
            }
            case ChoiceVertex: {
                return new Color((Device)d, 0, 255, 0);
            }
            case ImplicitSuperClock: {
                return new Color((Device)d, 255, 0, 255);
            }
        }
        return new Color((Device)d, 0, 0, 0);
    }

    public boolean containsByInstantiationPathName(String instanciationPathName) {
        for (InstantiatedElement ie : this) {
            if (ie.getQualifiedName().compareTo(instanciationPathName) != 0) continue;
            return true;
        }
        return false;
    }
}

