/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.elements;

import fr.inria.aoste.timesquare.ccslkernel.runtime.INamedElement;
import fr.inria.aoste.timesquare.ccslkernel.runtime.IRuntimeContainer;
import fr.inria.aoste.timesquare.ccslkernel.runtime.QualifiedName;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RuntimeClock
implements INamedElement,
IRuntimeContainer {
    public ArrayList<String> linkedElements = new ArrayList();
    private String name;
    private QualifiedName qualifiedName;
    public int tickCount;
    public int bddVariableNumber;
    private boolean dense;
    private IRuntimeContainer parent;
    public static int UNALLOCATEDBDDVARIABLE = -1;
    protected ClockState state;

    public boolean isDense() {
        return this.dense;
    }

    public void setDense(boolean dense) {
        this.dense = dense;
    }

    public RuntimeClock(String name) {
        this.name = name;
        this.tickCount = 0;
        this.state = ClockState.ALIVE;
    }

    public RuntimeClock() {
        this.tickCount = 0;
        this.state = ClockState.ALIVE;
    }

    @Override
    public IRuntimeContainer getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IRuntimeContainer parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addContent(this);
        }
    }

    @Override
    public void addContent(IRuntimeContainer element) {
    }

    @Override
    public List<IRuntimeContainer> getContents() {
        return Collections.emptyList();
    }

    public void setName(String s) {
        this.name = s;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = new QualifiedName(qualifiedName);
    }

    @Override
    public void setQualifiedName(QualifiedName qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    @Override
    public QualifiedName getQualifiedName() {
        if (this.qualifiedName != null) {
            return this.qualifiedName;
        }
        if (this.parent != null && this.parent instanceof INamedElement) {
            QualifiedName qname = new QualifiedName(((INamedElement)((Object)this.parent)).getQualifiedName()).append(this.getName());
            this.setQualifiedName(qname);
            return qname;
        }
        return new QualifiedName(this.getName());
    }

    public String toString() {
        return "[" + this.name + "/" + this.tickCount + "]";
    }

    protected ClockState getState() {
        return this.state;
    }

    public void start() {
        this.state = ClockState.ALIVE;
    }

    public void terminate(AbstractUpdateHelper helper) throws SimulationException {
        this.state = ClockState.DEAD;
    }

    public boolean isDead() {
        return this.state == ClockState.DEAD;
    }

    public void setDead(boolean isDead) {
        this.state = isDead ? ClockState.DEAD : ClockState.ALIVE;
    }

    public static enum ClockState {
        ALIVE,
        DEAD;

    }
}

