/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver.priorities;

import fr.inria.aoste.timesquare.ccslkernel.clocktree.generator.CoincidentClocks;
import fr.inria.aoste.timesquare.ccslkernel.clocktree.generator.Edge;
import fr.inria.aoste.timesquare.ccslkernel.clocktree.generator.GrphClockTreeConstructor;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockConstraintSystem;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ConcreteEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.NamedElement;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiatedElement;
import fr.inria.aoste.timesquare.ccslkernel.solver.CCSLKernelSolver;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.SolverClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.priorities.SolverPriorityRelation;
import fr.inria.aoste.timesquare.ccslkernel.solver.priorities.SolverPrioritySpecification;
import grph.oo.ObjectGrph;
import org.eclipse.emf.ecore.EObject;

public class PriorityPropagator {
    private ObjectGrph<CoincidentClocks, Edge> _clockTree = null;
    private SolverPrioritySpecification _prioSpec = null;
    private CCSLKernelSolver _solver;
    private boolean _relationAdded = true;

    public PriorityPropagator(SolverPrioritySpecification p, CCSLKernelSolver s) {
        this._prioSpec = p;
        this._solver = s;
        GrphClockTreeConstructor treeConstructor = new GrphClockTreeConstructor();
        this._clockTree = treeConstructor.createClockGrphDag(s.getUnfoldModel());
    }

    public void addPriorityRelationsToSpec() {
        while (this._relationAdded) {
            this._relationAdded = false;
            for (CoincidentClocks coincidentClocks : this._clockTree.getVertices()) {
                this.addPriorityRelation(coincidentClocks);
            }
        }
        for (Edge edge : this._clockTree.getEdges()) {
            if (!edge.isPriorityPropagator()) continue;
            this.addPriorityRelation(edge);
        }
    }

    private void addPriorityRelation(Edge edge) {
        CoincidentClocks ccS = (CoincidentClocks)this._clockTree.getDirectedSimpleEdgeTail((Object)edge);
        CoincidentClocks ccT = (CoincidentClocks)this._clockTree.getDirectedSimpleEdgeHead((Object)edge);
        SolverPrioritySpecification tmpSpec = new SolverPrioritySpecification(this._prioSpec);
        for (SolverPriorityRelation pr : tmpSpec.getPriorityRelations()) {
            if (!ccS.containsByInstantiationPathName(pr.getLower().getInstantiationPath().toString())) continue;
            this.propagate(ccT, pr.getLower(), pr.getHigher());
            this.propagate(ccS, pr.getLower(), pr.getHigher());
        }
    }

    private void addPriorityRelation(CoincidentClocks cc) {
        SolverPrioritySpecification tmpSpec = new SolverPrioritySpecification(this._prioSpec);
        for (SolverPriorityRelation pr : tmpSpec.getPriorityRelations()) {
            if (!cc.containsByInstantiationPathName(pr.getLower().getInstantiationPath().toString())) continue;
            this.propagate(cc, pr.getLower(), pr.getHigher());
        }
    }

    private void propagate(CoincidentClocks pr, SolverClock lower, SolverClock higher) {
        for (InstantiatedElement ie : pr) {
            if (ie.getInstantiationPath().toString().compareTo(lower.getInstantiationPath().toString()) == 0) continue;
            SolverPriorityRelation newPR = new SolverPriorityRelation();
            newPR.setHigher(higher);
            newPR.setLower(this._solver.findClockByPath(ie.getQualifiedName()));
            if (!this._prioSpec.add(newPR)) continue;
            this._relationAdded = true;
        }
    }

    private String getInstantiationPathName(ConcreteEntity ce) {
        return this.getQualifiedName((EObject)ce);
    }

    private String getQualifiedName(EObject eo) {
        String res = "";
        if (!(eo.eContainer() instanceof ClockConstraintSystem)) {
            res = String.valueOf(res) + this.getQualifiedName(eo.eContainer());
            res = String.valueOf(res) + "::";
        }
        res = String.valueOf(res) + ((NamedElement)eo).getName();
        return res;
    }

    public SolverPrioritySpecification getPrioSpec() {
        return this._prioSpec;
    }

    public void setPrioSpec(SolverPrioritySpecification _prioSpec) {
        this._prioSpec = _prioSpec;
    }

    public ObjectGrph<CoincidentClocks, Edge> getClockTree() {
        return this._clockTree;
    }

    public void setClockTree(ObjectGrph<CoincidentClocks, Edge> _clockTree) {
        this._clockTree = _clockTree;
    }
}

