/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.swt.widgets.Display;

public final class AcceleoTemplateReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private static final String COMMENT_STATEMENT_NAME = "comment";
    private static final String MACRO_STATEMENT_NAME = "macro";
    private static final String QUERY_STATEMENT_NAME = "query";
    private static final String TEMPLATE_STATEMENT_NAME = "template";
    protected final Map<Annotation, Position> addedAnnotations = new HashMap<Annotation, Position>();
    protected final Map<Annotation, Position> currentAnnotations = new HashMap<Annotation, Position>();
    protected final List<Annotation> deletedAnnotations = new ArrayList<Annotation>();
    protected final AcceleoEditor editor;
    protected final Map<Annotation, Position> modifiedAnnotations = new HashMap<Annotation, Position>();
    private IDocument document;
    private int offset;
    private boolean seekSelfClosing;
    private char statementStart = (char)91;

    public AcceleoTemplateReconcilingStrategy(AcceleoEditor editor) {
        this.editor = editor;
    }

    public void initialReconcile() {
        this.offset = 0;
        this.computePositions();
        this.updateFoldingStructure();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void reconcile(IRegion partition) {
        this.offset = partition.getOffset();
        this.computePositions();
        this.updateFoldingStructure();
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    private void computePositions() {
        this.deletedAnnotations.clear();
        this.modifiedAnnotations.clear();
        this.addedAnnotations.clear();
        this.deletedAnnotations.addAll(this.currentAnnotations.keySet());
        for (Map.Entry<Annotation, Position> entry : this.currentAnnotations.entrySet()) {
            Position position = entry.getValue();
            if (position.getOffset() + position.getLength() >= this.offset) continue;
            this.deletedAnnotations.remove(entry.getKey());
        }
        try {
            boolean eof = this.seekStatementStart();
            int startOffset = this.offset;
            while (!eof) {
                ++this.offset;
                if (COMMENT_STATEMENT_NAME.equals(this.document.get(this.offset, COMMENT_STATEMENT_NAME.length()))) {
                    int endOffset;
                    eof = this.seekCommentEnd();
                    ++this.offset;
                    if (this.document.getNumberOfLines(startOffset, endOffset - startOffset) > 2) {
                        this.createOrUpdateAnnotation(startOffset, endOffset - startOffset, false);
                    }
                } else {
                    String moduleElement = null;
                    if (MACRO_STATEMENT_NAME.equals(this.document.get(this.offset, MACRO_STATEMENT_NAME.length()))) {
                        moduleElement = MACRO_STATEMENT_NAME;
                    } else if (TEMPLATE_STATEMENT_NAME.equals(this.document.get(this.offset, TEMPLATE_STATEMENT_NAME.length()))) {
                        moduleElement = TEMPLATE_STATEMENT_NAME;
                    } else if (QUERY_STATEMENT_NAME.equals(this.document.get(this.offset, QUERY_STATEMENT_NAME.length()))) {
                        moduleElement = QUERY_STATEMENT_NAME;
                    }
                    if (moduleElement != null) {
                        eof = this.seekModuleElementEnd(moduleElement);
                        this.alignModuleElementEnd(moduleElement);
                        if (this.document.getNumberOfLines(startOffset, this.offset - startOffset) > 2) {
                            this.createOrUpdateAnnotation(startOffset, this.offset - startOffset, false);
                        }
                    }
                }
                eof = this.seekStatementStart();
                startOffset = this.offset;
            }
        }
        catch (BadLocationException badLocationException) {}
        for (Annotation deleted : this.deletedAnnotations) {
            this.currentAnnotations.remove(deleted);
        }
    }

    private void alignModuleElementEnd(String moduleElement) throws BadLocationException {
        if ("/".equals(String.valueOf(this.document.getChar(this.offset))) && this.document.get().length() >= this.offset + 1 + moduleElement.length() + 1) {
            String next = this.document.get().substring(this.offset, this.offset + 1 + moduleElement.length() + 1);
            String nextToFind = "/" + moduleElement + "]";
            if (nextToFind.equals(next)) {
                this.offset = this.offset + 1 + moduleElement.length() + 1;
            }
        }
    }

    private void createOrUpdateAnnotation(int newOffset, int newLength, boolean initiallyCollapsed) throws BadLocationException {
        boolean createAnnotation = true;
        HashMap<Annotation, Position> copy = new HashMap<Annotation, Position>(this.currentAnnotations);
        String text = this.document.get(newOffset, newLength);
        for (Map.Entry entry : copy.entrySet()) {
            if (!((Annotation)entry.getKey()).getText().equals(text)) continue;
            createAnnotation = false;
            Position oldPosition = (Position)entry.getValue();
            if (oldPosition.getOffset() != newOffset || oldPosition.getLength() != newLength) {
                Position newPosition = new Position(newOffset, newLength);
                this.modifiedAnnotations.put((Annotation)entry.getKey(), newPosition);
                this.currentAnnotations.put((Annotation)entry.getKey(), newPosition);
            }
            this.deletedAnnotations.remove(entry.getKey());
            break;
        }
        if (createAnnotation) {
            ProjectionAnnotation annotation = new ProjectionAnnotation(initiallyCollapsed);
            annotation.setText(text);
            Position position = new Position(newOffset, newLength);
            this.currentAnnotations.put((Annotation)annotation, position);
            this.addedAnnotations.put((Annotation)annotation, position);
        }
    }

    private boolean seekCommentEnd() throws BadLocationException {
        boolean isCommentEnd;
        char next = this.document.getChar(this.offset);
        boolean eof = this.offset + 1 >= this.document.getLength();
        while (!(eof || next == this.statementStart || next == ']' && this.document.getChar(this.offset - 1) == '/')) {
            ++this.offset;
            eof = this.offset + 1 >= this.document.getLength();
            next = this.document.getChar(this.offset);
            if (!this.seekSelfClosing || next != ']' || this.document.getChar(this.offset - 1) == '/') continue;
            this.seekSelfClosing = false;
        }
        boolean isSelfClosing = !eof && this.seekSelfClosing && next == ']' && this.document.getChar(this.offset - 1) == '/';
        boolean bl = isCommentEnd = !isSelfClosing && !eof && '/' != this.document.getChar(this.offset + 1) && COMMENT_STATEMENT_NAME != this.document.get(this.offset + 2, COMMENT_STATEMENT_NAME.length());
        if (!(eof || isSelfClosing || isCommentEnd)) {
            ++this.offset;
            this.seekCommentEnd();
        }
        this.seekSelfClosing = true;
        return eof;
    }

    private boolean seekModuleElementEnd(String moduleElement) throws BadLocationException {
        boolean eof = this.offset + moduleElement.length() + 2 >= this.document.getLength();
        char next = this.document.getChar(this.offset);
        while (!eof && next != this.statementStart) {
            eof = this.offset + moduleElement.length() + 2 >= this.document.getLength();
            next = this.document.getChar(this.offset++);
        }
        if ('/' != this.document.getChar(this.offset) || !moduleElement.equals(this.document.get(this.offset + 1, moduleElement.length()))) {
            ++this.offset;
            this.seekModuleElementEnd(moduleElement);
        }
        eof = this.offset + moduleElement.length() + 2 >= this.document.getLength();
        return eof;
    }

    private boolean seekStatementStart() throws BadLocationException {
        char next = this.document.getChar(this.offset);
        boolean eof = this.offset + 1 >= this.document.getLength();
        while (!eof && next != this.statementStart) {
            ++this.offset;
            next = this.document.getChar(this.offset);
            boolean bl = eof = this.offset + 1 == this.document.getLength();
        }
        return eof;
    }

    private void updateFoldingStructure() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AcceleoTemplateReconcilingStrategy.this.editor.updateFoldingStructure(AcceleoTemplateReconcilingStrategy.this.addedAnnotations, AcceleoTemplateReconcilingStrategy.this.deletedAnnotations, AcceleoTemplateReconcilingStrategy.this.modifiedAnnotations);
            }
        });
    }
}

