/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecoretools.ale.core.interpreter.CriticalFailure;
import org.eclipse.emf.ecoretools.ale.core.parser.visitor.ParseResult;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;

public class DiagnosticLogger {
    List<Diagnostic> log = new ArrayList<Diagnostic>();
    List<ParseResult<ModelUnit>> parseResults;

    public DiagnosticLogger(List<ParseResult<ModelUnit>> parseResults) {
        this.parseResults = parseResults;
    }

    public void notify(Diagnostic diag) {
        this.log.add(diag);
    }

    public List<Diagnostic> getLog() {
        return this.log;
    }

    public void diagnosticForHuman() {
        this.log.stream().forEach(diagnotic -> {
            if (diagnotic instanceof BasicDiagnostic) {
                this.diagnosticForHuman((BasicDiagnostic)diagnotic);
            }
        });
    }

    public void diagnosticForHuman(BasicDiagnostic diagnostic) {
        diagnostic.getChildren().stream().forEach(diag -> {
            if (diag.getSource().equals("interpreter")) {
                Expression failedExp = (Expression)diag.getData().get(0);
                Diagnostic diagExp = diag;
                if (diag.getData().size() > 1) {
                    diagExp = (Diagnostic)diag.getData().get(1);
                }
                this.printError(failedExp, diagExp.toString());
                if (diagExp instanceof BasicDiagnostic) {
                    this.diagnosticForHuman((BasicDiagnostic)diagExp);
                }
            } else if (!diag.getData().isEmpty() && diag.getData().get(0) instanceof Exception) {
                Exception e = (Exception)diag.getData().get(0);
                if (e.getCause() instanceof CriticalFailure) {
                    CriticalFailure interpreterFailure = (CriticalFailure)e.getCause();
                    this.diagnosticForHuman(interpreterFailure.diagnostics);
                } else if (e.getCause() != null) {
                    e.getCause().printStackTrace();
                }
            }
        });
    }

    private void printError(Expression expr, String errorMsg) {
        for (ParseResult<ModelUnit> p : this.parseResults) {
            Integer startPos = p.getStartPositions().get(expr);
            if (startPos == null) continue;
            String file = p.getSourceFile();
            int line = this.getLine(startPos, file);
            System.out.println("\n[AQL eval fail] At line " + line + " in " + file + " :\n" + errorMsg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getLine(int offset, String file) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                int n;
                LineNumberReader r = new LineNumberReader(new FileReader(file));
                try {
                    r.setLineNumber(1);
                    int count = 0;
                    while (true) {
                        if (r.read() == -1 || count >= offset) {
                            if (count != offset) break;
                            n = r.getLineNumber();
                            return n;
                        }
                        ++count;
                    }
                    System.out.println("File is not long enough");
                    return 0;
                }
                finally {
                    if (r == null) return n;
                    r.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }
}

