/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.validation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.runtime.impl.ValidationMessage;
import org.eclipse.acceleo.query.validation.type.AbstractCollectionType;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecoretools.ale.core.validation.BaseValidator;
import org.eclipse.emf.ecoretools.ale.core.validation.IValidator;
import org.eclipse.emf.ecoretools.ale.core.validation.QualifiedNames;
import org.eclipse.emf.ecoretools.ale.implementation.Attribute;
import org.eclipse.emf.ecoretools.ale.implementation.BehavioredClass;
import org.eclipse.emf.ecoretools.ale.implementation.Block;
import org.eclipse.emf.ecoretools.ale.implementation.ConditionalBlock;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureInsert;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureRemove;
import org.eclipse.emf.ecoretools.ale.implementation.ForEach;
import org.eclipse.emf.ecoretools.ale.implementation.If;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationPackage;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;
import org.eclipse.emf.ecoretools.ale.implementation.Statement;
import org.eclipse.emf.ecoretools.ale.implementation.VariableAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.VariableDeclaration;
import org.eclipse.emf.ecoretools.ale.implementation.VariableInsert;
import org.eclipse.emf.ecoretools.ale.implementation.VariableRemove;
import org.eclipse.emf.ecoretools.ale.implementation.While;

public class TypeValidator
implements IValidator {
    public static final String INCOMPATIBLE_TYPE = "Expected %s but was %s";
    public static final String BOOLEAN_TYPE = "Expected ecore::EBoolean but was %s";
    public static final String COLLECTION_TYPE = "Expected Collection but was %s";
    public static final String VOID_RESULT_ASSIGN = "'result' is assigned in void operation";
    public static final String EXTENDS_ITSELF = "Reopened %s is extending itself";
    public static final String INDIRECT_EXTENSION = "Can't extend %s since it is not a direct super type of %s";
    public static final String SELF_INSERT = "Cannot insert anything into 'self'";
    public static final String SELF_REMOVE = "Cannot remove anything from 'self'";
    public static final String UNRESOLVED_TYPE = "Unresolved type %s";
    public static final String UNRESOLVED_TYPE_EXT = "Unresolved type %s, it cannot be found in any of the declared packages: %s";
    BaseValidator base;

    @Override
    public void setBase(BaseValidator base) {
        this.base = base;
    }

    @Override
    public List<IValidationMessage> validateModelBehavior(List<ModelUnit> units) {
        return new ArrayList<IValidationMessage>();
    }

    @Override
    public List<IValidationMessage> validateModelUnit(ModelUnit unit) {
        return new ArrayList<IValidationMessage>();
    }

    @Override
    public List<IValidationMessage> validateExtendedClass(ExtendedClass xtdClass) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        msgs.addAll(this.validateBehavioredClass(xtdClass));
        if (this.isExtendingItself(xtdClass)) {
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(EXTENDS_ITSELF, QualifiedNames.getQualifiedName((EClassifier)xtdClass.getBaseClass())), this.base.getStartOffset(xtdClass), this.base.getEndOffset(xtdClass)));
        }
        EClass baseCls = xtdClass.getBaseClass();
        EList superTypes = baseCls.getESuperTypes();
        List<EClass> extendsBaseClasses = xtdClass.getExtends().stream().map(xtd -> xtd.getBaseClass()).collect(Collectors.toList());
        extendsBaseClasses.forEach(superBase -> {
            if (!superTypes.contains(superBase) && baseCls != superBase) {
                msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(INDIRECT_EXTENSION, QualifiedNames.getQualifiedName((EClassifier)superBase), QualifiedNames.getQualifiedName((EClassifier)baseCls)), this.base.getStartOffset(xtdClass), this.base.getEndOffset(xtdClass)));
            }
        });
        return msgs;
    }

    @Override
    public List<IValidationMessage> validateRuntimeClass(RuntimeClass classDef) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        msgs.addAll(this.validateBehavioredClass(classDef));
        return msgs;
    }

    private List<IValidationMessage> validateBehavioredClass(BehavioredClass clazz) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        clazz.getAttributes().stream().filter(att -> att.getInitialValue() != null).forEach(att -> {
            Set<IType> inferredTypes = this.base.getPossibleTypes(att.getInitialValue());
            EClassifierType declaredType = new EClassifierType((IReadOnlyQueryEnvironment)this.base.getQryEnv(), att.getFeatureRef().getEType());
            Optional<IType> existResult = inferredTypes.stream().filter(type -> declaredType.isAssignableFrom(type)).findAny();
            if (!existResult.isPresent()) {
                String types = inferredTypes.stream().map(type -> QualifiedNames.getQualifiedName(type)).collect(Collectors.joining(",", "[", "]"));
                msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(INCOMPATIBLE_TYPE, QualifiedNames.getQualifiedName(att.getFeatureRef().getEType()), types), this.base.getStartOffset(att), this.base.getEndOffset(att)));
            }
        });
        clazz.getAttributes().stream().filter(att -> this.isUnresolvedType(att.getFeatureRef().getEType())).forEach(att -> {
            String declaredPackages = this.base.qryEnv.getEPackageProvider().getRegisteredEPackages().stream().map(p -> p.getName()).collect(Collectors.joining(", ", "[", "]"));
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(UNRESOLVED_TYPE_EXT, "", declaredPackages), this.base.getStartOffset(att), this.base.getEndOffset(att)));
        });
        return msgs;
    }

    @Override
    public List<IValidationMessage> validateMethod(Method mtd) {
        return new ArrayList<IValidationMessage>();
    }

    @Override
    public List<IValidationMessage> validateFeatureAssignment(FeatureAssignment featAssign) {
        return this.validateAssignment(featAssign, featAssign.getTarget(), featAssign.getTargetFeature(), featAssign.getValue(), false);
    }

    @Override
    public List<IValidationMessage> validateFeatureInsert(FeatureInsert featInsert) {
        return this.validateAssignment(featInsert, featInsert.getTarget(), featInsert.getTargetFeature(), featInsert.getValue(), true);
    }

    @Override
    public List<IValidationMessage> validateFeatureRemove(FeatureRemove featRemove) {
        return this.validateAssignment(featRemove, featRemove.getTarget(), featRemove.getTargetFeature(), featRemove.getValue(), true);
    }

    private List<IValidationMessage> validateAssignment(Statement stmt, Expression targetExp, String featureName, Expression valueExp, boolean isInsert) {
        boolean scalarAcceptsInsertion;
        boolean isTryingToInsertSomeValueWithinAScalar;
        List<ExtendedClass> extensions;
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        Set<IType> targetTypes = this.base.getPossibleTypes(targetExp);
        HashSet<EClassifierType> featureTypes = new HashSet<EClassifierType>();
        boolean isCollection = false;
        for (IType type2 : targetTypes) {
            if (!(type2.getType() instanceof EClass)) continue;
            EClass realType = (EClass)type2.getType();
            EStructuralFeature eStructuralFeature = realType.getEStructuralFeature(featureName);
            if (eStructuralFeature != null) {
                EClassifierType featureType = new EClassifierType((IReadOnlyQueryEnvironment)this.base.getQryEnv(), eStructuralFeature.getEType());
                featureTypes.add(featureType);
                isCollection = eStructuralFeature.isMany();
                continue;
            }
            extensions = this.base.findExtensions(realType);
            Optional<Attribute> foundDynamicAttribute = extensions.stream().flatMap(xtdCls -> xtdCls.getAttributes().stream()).filter(field -> field.getFeatureRef().getName().equals(featureName)).findFirst();
            if (!foundDynamicAttribute.isPresent()) continue;
            EClassifierType featureType = new EClassifierType((IReadOnlyQueryEnvironment)this.base.getQryEnv(), foundDynamicAttribute.get().getFeatureRef().getEType());
            featureTypes.add(featureType);
            isCollection = foundDynamicAttribute.get().getFeatureRef().isMany();
        }
        boolean bl = isTryingToInsertSomeValueWithinAScalar = isInsert && !isCollection && !featureTypes.isEmpty();
        if (isTryingToInsertSomeValueWithinAScalar && !(scalarAcceptsInsertion = this.canInsert(featureTypes, this.base.getPossibleTypes(valueExp)))) {
            String inferredToString = featureTypes.stream().map(type -> QualifiedNames.getQualifiedName((IType)type)).collect(Collectors.joining(",", "[", "]"));
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(COLLECTION_TYPE, inferredToString), this.base.getStartOffset(targetExp), this.base.getEndOffset(targetExp)));
        }
        if (!featureTypes.isEmpty()) {
            Object featureToString;
            Optional<IType> existResult;
            Set<IType> inferredTypes = this.base.getPossibleTypes(valueExp);
            if (!isInsert && isCollection) {
                for (IType inferredType : inferredTypes) {
                    if (!(inferredType instanceof AbstractCollectionType)) continue;
                    extensions = ((AbstractCollectionType)inferredType).getCollectionType();
                }
                boolean isAnyAssignable = false;
                for (IType iType : featureTypes) {
                    existResult = inferredTypes.stream().filter(t -> t instanceof AbstractCollectionType).map(t -> ((AbstractCollectionType)t).getCollectionType()).filter(t -> featureType.isAssignableFrom(t)).findAny();
                    if (!existResult.isPresent()) continue;
                    isAnyAssignable = true;
                    break;
                }
                if (!isAnyAssignable) {
                    String string = inferredTypes.stream().map(type -> QualifiedNames.getQualifiedName(type)).collect(Collectors.joining(",", "[", "]"));
                    featureToString = featureTypes.stream().map(type -> QualifiedNames.getQualifiedName(type.getType())).collect(Collectors.joining(",", "(", ")"));
                    msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(INCOMPATIBLE_TYPE, "[Collection" + (String)featureToString + "]", string), this.base.getStartOffset(stmt), this.base.getEndOffset(stmt)));
                }
            } else {
                boolean isAnyAssignable = false;
                for (IType iType : featureTypes) {
                    existResult = inferredTypes.stream().filter(t -> this.isAssignable(featureType, (IType)t) || featureType.getType() == EcorePackage.eINSTANCE.getEEList() && t instanceof AbstractCollectionType).findAny();
                    if (!existResult.isPresent()) continue;
                    isAnyAssignable = true;
                    break;
                }
                if (!isAnyAssignable) {
                    String string = inferredTypes.stream().map(type -> QualifiedNames.getQualifiedName(type)).collect(Collectors.joining(",", "[", "]"));
                    featureToString = featureTypes.stream().map(type -> QualifiedNames.getQualifiedName(type.getType())).collect(Collectors.joining(",", "[", "]"));
                    msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(INCOMPATIBLE_TYPE, featureToString, string), this.base.getStartOffset(stmt), this.base.getEndOffset(stmt)));
                }
            }
        }
        return msgs;
    }

    private boolean canInsert(Set<EClassifierType> featureTypes, Set<IType> possibleTypes) {
        for (EClassifierType eClassifierType : featureTypes) {
            if (!(eClassifierType.getType() instanceof EDataType)) continue;
            EDataType eDataType = (EDataType)eClassifierType.getType();
            if (String.class.equals((Object)eDataType.getInstanceClass())) {
                for (IType iType : possibleTypes) {
                    if (!String.class.equals(iType.getType())) continue;
                    return true;
                }
            }
            if (!Integer.TYPE.equals(eDataType.getInstanceClass())) continue;
            for (IType iType : possibleTypes) {
                Object type = iType.getType();
                if (Integer.class.equals(type)) {
                    return true;
                }
                if (!(type instanceof EDataType)) continue;
                return Integer.TYPE.equals(((EDataType)type).getInstanceClass());
            }
        }
        return false;
    }

    @Override
    public List<IValidationMessage> validateVariableAssignment(VariableAssignment varAssign) {
        Set<IType> inferredTypes;
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        Set<IType> declaringTypes = this.findDeclaredTypes(varAssign);
        if (varAssign.getName().equals("result")) {
            Method op = this.base.getContainingOperation(varAssign);
            EOperation eOp = op.getOperationRef();
            if (eOp != null) {
                boolean isVoidOp;
                boolean bl = isVoidOp = eOp.getEType() == null && eOp.getEGenericType() == null;
                if (isVoidOp) {
                    msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(VOID_RESULT_ASSIGN, varAssign.getName()), this.base.getStartOffset(varAssign), this.base.getEndOffset(varAssign)));
                } else {
                    Optional<EOperation> eOperation = this.findContainingEOperation(varAssign);
                    EClassifier returnType = eOp.getEType();
                    EClassifierType declaredType = new EClassifierType((IReadOnlyQueryEnvironment)this.base.getQryEnv(), returnType);
                    Set<IType> inferredTypes2 = this.base.getPossibleTypes(varAssign.getValue());
                    Optional<IType> matchingType = inferredTypes2.stream().filter(inferredType -> this.isInferredTypeCompatibleForResultVar((IType)declaredType, eOperation, (IType)inferredType)).findAny();
                    if (!matchingType.isPresent()) {
                        String types = inferredTypes2.stream().map(type -> QualifiedNames.getQualifiedName(type)).collect(Collectors.joining(",", "[", "]"));
                        msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(INCOMPATIBLE_TYPE, "[" + this.getTypeQualifiedNameForOperationResult((IType)declaredType, eOperation) + "]", types), this.base.getStartOffset(varAssign), this.base.getEndOffset(varAssign)));
                    }
                }
            }
        } else if (declaringTypes != null && !varAssign.getName().equals("self") && (inferredTypes = this.base.getPossibleTypes(varAssign.getValue())) != null && !declaringTypes.isEmpty()) {
            Optional<VariableDeclaration> declaration = this.findDeclaration(varAssign);
            Optional<IType> existResult = declaringTypes.stream().filter(declType -> inferredTypes.stream().filter(inferredType -> this.isInferredTypeCompatibleForVar((IType)declType, declaration, (IType)inferredType)).findAny().isPresent()).findAny();
            if (!existResult.isPresent()) {
                String declaredToString = declaringTypes.stream().map(type -> this.getTypeQualifiedNameForVar((IType)type, declaration)).collect(Collectors.joining(",", "[", "]"));
                String inferredToString = inferredTypes.stream().map(type -> QualifiedNames.getQualifiedName(type)).collect(Collectors.joining(",", "[", "]"));
                msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(INCOMPATIBLE_TYPE, declaredToString, inferredToString), this.base.getStartOffset(varAssign), this.base.getEndOffset(varAssign)));
            }
        }
        return msgs;
    }

    private boolean isAssignable(IType targetType, IType valueType) {
        return targetType.isAssignableFrom(valueType);
    }

    private String getTypeQualifiedNameForOperationResult(IType declaredType, Optional<EOperation> eOperation) {
        if (declaredType.getType() == EcorePackage.eINSTANCE.getEEList() && eOperation.isPresent()) {
            if (eOperation.get().getEGenericType().getETypeArguments().isEmpty()) {
                return "Collection(?)";
            }
            EClassifierType varTypeParam = new EClassifierType((IReadOnlyQueryEnvironment)this.base.getQryEnv(), ((EGenericType)eOperation.get().getEGenericType().getETypeArguments().get(0)).getEClassifier());
            return "Collection(" + QualifiedNames.getQualifiedName((IType)varTypeParam) + ")";
        }
        return QualifiedNames.getQualifiedName(declaredType);
    }

    private String getTypeQualifiedNameForVar(IType declaredType, Optional<VariableDeclaration> declaration) {
        if (declaredType.getType() == EcorePackage.eINSTANCE.getEEList() && declaration.isPresent()) {
            EClassifierType varTypeParam = new EClassifierType((IReadOnlyQueryEnvironment)this.base.getQryEnv(), declaration.get().getTypeParameter());
            return "Collection(" + QualifiedNames.getQualifiedName((IType)varTypeParam) + ")";
        }
        return QualifiedNames.getQualifiedName(declaredType);
    }

    private boolean isInferredTypeCompatibleForVar(IType declaredType, Optional<VariableDeclaration> declaration, IType inferredType) {
        if (declaredType.getType() == EcorePackage.eINSTANCE.getEEList() && inferredType instanceof AbstractCollectionType && declaration.isPresent()) {
            IType collectionType;
            EClassifierType varTypeParam = new EClassifierType((IReadOnlyQueryEnvironment)this.base.getQryEnv(), declaration.get().getTypeParameter());
            return varTypeParam.isAssignableFrom(collectionType = ((AbstractCollectionType)inferredType).getCollectionType()) || collectionType instanceof NothingType;
        }
        return declaredType.isAssignableFrom(inferredType);
    }

    private boolean isInferredTypeCompatibleForResultVar(IType declaredType, Optional<EOperation> eOperation, IType inferredType) {
        if (declaredType.getType() == EcorePackage.eINSTANCE.getEEList() && inferredType instanceof AbstractCollectionType && eOperation.isPresent() && inferredType instanceof AbstractCollectionType) {
            IType collectionType = ((AbstractCollectionType)inferredType).getCollectionType();
            if (eOperation.get().getEGenericType().getETypeArguments().isEmpty()) {
                return true;
            }
            if (collectionType instanceof NothingType) {
                return true;
            }
            EClassifierType varTypeParam = new EClassifierType((IReadOnlyQueryEnvironment)this.base.getQryEnv(), ((EGenericType)eOperation.get().getEGenericType().getETypeArguments().get(0)).getEClassifier());
            return varTypeParam.isAssignableFrom(collectionType);
        }
        return declaredType.isAssignableFrom(inferredType);
    }

    @Override
    public List<IValidationMessage> validateVariableDeclaration(VariableDeclaration varDecl) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        if (varDecl.getInitialValue() != null) {
            EClassifier declaredType = varDecl.getType();
            Set<IType> inferredTypes = this.base.getPossibleTypes(varDecl.getInitialValue());
            if (inferredTypes != null) {
                if (declaredType == EcorePackage.eINSTANCE.getEEList()) {
                    EClassifierType varTypeParam = new EClassifierType((IReadOnlyQueryEnvironment)this.base.getQryEnv(), varDecl.getTypeParameter());
                    Optional<IType> existResult = inferredTypes.stream().filter(t -> t instanceof AbstractCollectionType).map(t -> ((AbstractCollectionType)t).getCollectionType()).filter(t -> varTypeParam.isAssignableFrom(t) || t instanceof NothingType).findAny();
                    if (!existResult.isPresent()) {
                        String inferredToString = inferredTypes.stream().map(type -> QualifiedNames.getQualifiedName(type)).collect(Collectors.joining(",", "[", "]"));
                        msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(INCOMPATIBLE_TYPE, "Collection(" + QualifiedNames.getQualifiedName((IType)varTypeParam) + ")", inferredToString), this.base.getStartOffset(varDecl), this.base.getEndOffset(varDecl)));
                    }
                } else {
                    EClassifierType varType = new EClassifierType((IReadOnlyQueryEnvironment)this.base.getQryEnv(), varDecl.getType());
                    Optional<IType> existResult = inferredTypes.stream().filter(t -> varType.isAssignableFrom(t) || t instanceof AbstractCollectionType && varDecl.getType() == EcorePackage.eINSTANCE.getEEList()).findAny();
                    if (!existResult.isPresent()) {
                        String inferredToString = inferredTypes.stream().map(type -> QualifiedNames.getQualifiedName(type)).collect(Collectors.joining(",", "[", "]"));
                        msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(INCOMPATIBLE_TYPE, QualifiedNames.getQualifiedName(varDecl.getType()), inferredToString), this.base.getStartOffset(varDecl), this.base.getEndOffset(varDecl)));
                    }
                }
            }
        }
        if (this.isUnresolvedType(varDecl.getType())) {
            String declaredPackages = this.base.qryEnv.getEPackageProvider().getRegisteredEPackages().stream().map(p -> p.getName()).collect(Collectors.joining(", ", "[", "]"));
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(UNRESOLVED_TYPE_EXT, "", declaredPackages), this.base.getStartOffset(varDecl), this.base.getEndOffset(varDecl)));
        }
        return msgs;
    }

    @Override
    public List<IValidationMessage> validateVariableInsert(VariableInsert varInsert) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        if (varInsert.getName().equals("self")) {
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, SELF_INSERT, this.base.getStartOffset(varInsert), this.base.getEndOffset(varInsert)));
        } else {
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.WARNING, String.format("Unable to ensure that %s supports '+=' operator here", varInsert.getName()), this.base.getStartOffset(varInsert), this.base.getEndOffset(varInsert)));
        }
        return msgs;
    }

    @Override
    public List<IValidationMessage> validateVariableRemove(VariableRemove varInsert) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        if (varInsert.getName().equals("self")) {
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, SELF_REMOVE, this.base.getStartOffset(varInsert), this.base.getEndOffset(varInsert)));
        } else {
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.WARNING, String.format("Unable to ensure that %s supports '-=' operator here", varInsert.getName()), this.base.getStartOffset(varInsert), this.base.getEndOffset(varInsert)));
        }
        return msgs;
    }

    @Override
    public List<IValidationMessage> validateForEach(ForEach loop) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        Optional<IType> existResult = this.base.getPossibleTypes(loop.getCollectionExpression()).stream().filter(type -> type instanceof ICollectionType).findAny();
        if (!existResult.isPresent()) {
            String inferredToString = this.base.getPossibleTypes(loop.getCollectionExpression()).stream().map(type -> QualifiedNames.getQualifiedName(type)).collect(Collectors.joining(",", "[", "]"));
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(COLLECTION_TYPE, inferredToString), this.base.getStartOffset(loop.getCollectionExpression()), this.base.getEndOffset(loop.getCollectionExpression())));
        }
        return msgs;
    }

    @Override
    public List<IValidationMessage> validateIf(If ifStmt) {
        ArrayList<IValidationMessage> res = new ArrayList<IValidationMessage>();
        for (ConditionalBlock cBlock : ifStmt.getBlocks()) {
            res.addAll(this.validateIsBoolean(cBlock.getCondition()));
        }
        return res;
    }

    @Override
    public List<IValidationMessage> validateWhile(While loop) {
        return this.validateIsBoolean(loop.getCondition());
    }

    private List<IValidationMessage> validateIsBoolean(Expression exp) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        Set<IType> selectorTypes = this.base.getPossibleTypes(exp);
        boolean onlyNotBoolean = true;
        ClassType booleanObjectType = new ClassType((IReadOnlyQueryEnvironment)this.base.getQryEnv(), Boolean.class);
        ClassType booleanType = new ClassType((IReadOnlyQueryEnvironment)this.base.getQryEnv(), Boolean.TYPE);
        for (IType type2 : selectorTypes) {
            boolean assignableFrom = booleanObjectType.isAssignableFrom(type2) || booleanType.isAssignableFrom(type2);
            boolean bl = onlyNotBoolean = onlyNotBoolean && !assignableFrom;
        }
        if (onlyNotBoolean) {
            String inferredToString = selectorTypes.stream().map(type -> QualifiedNames.getQualifiedName(type)).collect(Collectors.joining(",", "[", "]"));
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(BOOLEAN_TYPE, inferredToString), this.base.getStartOffset(exp), this.base.getEndOffset(exp)));
        }
        return msgs;
    }

    private boolean isExtendingItself(ExtendedClass xtdClass) {
        ArrayList todo = Lists.newArrayList((Object[])new ExtendedClass[]{xtdClass});
        ArrayList done = Lists.newArrayList();
        while (!todo.isEmpty()) {
            ExtendedClass current = (ExtendedClass)todo.get(0);
            if (done.contains(current)) {
                return true;
            }
            todo.addAll(current.getExtends());
            done.add(current);
            todo.remove(0);
        }
        return false;
    }

    private Optional<EOperation> findContainingEOperation(Statement statement) {
        EObject current = statement.eContainer();
        EClass type = ImplementationPackage.eINSTANCE.getMethod();
        while (current != null && !type.isSuperTypeOf(current.eClass()) && !type.isInstance((Object)current)) {
            current = current.eContainer();
        }
        if (current != null && (type.isSuperTypeOf(current.eClass()) || type.isInstance((Object)current))) {
            return Optional.ofNullable(((Method)current).getOperationRef());
        }
        return Optional.empty();
    }

    private Optional<VariableDeclaration> findDeclaration(VariableAssignment varAssign) {
        String variableName = varAssign.getName();
        VariableAssignment currentObject = varAssign;
        EObject currentScope = varAssign.eContainer();
        while (currentScope != null) {
            Optional<VariableDeclaration> candidate;
            Block block;
            int index;
            if (currentScope instanceof Block && (index = (block = (Block)currentScope).getStatements().indexOf((Object)currentObject)) != -1 && (candidate = block.getStatements().stream().limit(index).filter(stmt -> stmt instanceof VariableDeclaration).map(stmt -> (VariableDeclaration)stmt).filter(varDecl -> varDecl.getName().equals(variableName)).findFirst()).isPresent()) {
                return candidate;
            }
            currentObject = currentScope;
            currentScope = currentScope.eContainer();
        }
        return Optional.empty();
    }

    private Set<IType> findDeclaredTypes(VariableAssignment varAssign) {
        HashSet<IType> res = new HashSet<IType>();
        String variableName = varAssign.getName();
        VariableAssignment currentObject = varAssign;
        EObject currentScope = varAssign.eContainer();
        while (currentScope != null) {
            ExtendedClass extension;
            Optional<EStructuralFeature> feature;
            EClassifier type;
            if (currentScope instanceof Block) {
                Optional<VariableDeclaration> candidate;
                Block block = (Block)currentScope;
                int index = block.getStatements().indexOf((Object)currentObject);
                if (index != -1 && (candidate = block.getStatements().stream().limit(index).filter(stmt -> stmt instanceof VariableDeclaration).map(stmt -> (VariableDeclaration)stmt).filter(varDecl -> varDecl.getName().equals(variableName)).findFirst()).isPresent()) {
                    EClassifier type2 = candidate.get().getType();
                    res.add((IType)new EClassifierType((IReadOnlyQueryEnvironment)this.base.getQryEnv(), type2));
                    return res;
                }
            } else if (currentScope instanceof ForEach) {
                ForEach loop = (ForEach)currentScope;
                if (loop.getVariable().equals(variableName)) {
                    Set<IType> inferredTypes = this.base.getPossibleTypes(loop.getCollectionExpression());
                    return inferredTypes;
                }
            } else if (currentScope instanceof BehavioredClass) {
                BehavioredClass cls = (BehavioredClass)currentScope;
                Optional<Attribute> candidate = cls.getAttributes().stream().filter(attr -> attr.getFeatureRef().getName().equals(variableName)).findFirst();
                if (candidate.isPresent()) {
                    type = candidate.get().getFeatureRef().getEType();
                    res.add((IType)new EClassifierType((IReadOnlyQueryEnvironment)this.base.getQryEnv(), type));
                    return res;
                }
            } else if (currentScope instanceof ExtendedClass && (feature = (extension = (ExtendedClass)currentScope).getBaseClass().getEAllStructuralFeatures().stream().filter(feat -> feat.getName().equals(variableName)).findFirst()).isPresent()) {
                type = feature.get().getEType();
                res.add((IType)new EClassifierType((IReadOnlyQueryEnvironment)this.base.getQryEnv(), type));
                return res;
            }
            currentObject = currentScope;
            currentScope = currentScope.eContainer();
        }
        return res;
    }

    private boolean isUnresolvedType(EClassifier type) {
        return type == ImplementationPackage.eINSTANCE.getUnresolvedEClassifier();
    }
}

