/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epp.internal.mpc.core.util.TextUtil;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalogSource;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceDiscoveryStrategy;
import org.eclipse.epp.internal.mpc.ui.catalog.ResourceProvider;
import org.eclipse.epp.internal.mpc.ui.css.StyleHelper;
import org.eclipse.epp.internal.mpc.ui.util.Util;
import org.eclipse.epp.internal.mpc.ui.wizards.AbstractMarketplaceDiscoveryItem;
import org.eclipse.epp.internal.mpc.ui.wizards.IMarketplaceWebBrowser;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.equinox.internal.p2.discovery.model.Overview;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class OverviewToolTip
extends ToolTip {
    private static final String CSS_PATH = "overview.css";
    private static final String DEFAULT_THEME_CSS = "body { background-color: white; }";
    private static final String INITIALIZED_FLAG = String.valueOf(OverviewToolTip.class.getName()) + ".initialized";
    final int SCREENSHOT_HEIGHT = 240;
    final int SCREENSHOT_WIDTH = 320;
    private final Overview overview;
    private final MarketplaceCatalogSource source;
    private final Control parent;
    private final IMarketplaceWebBrowser browser;
    private static URL latestThemeCssUrl;
    private static String latestThemeCss;

    public OverviewToolTip(Control control, IMarketplaceWebBrowser browser, MarketplaceCatalogSource source, Overview overview) {
        super(control, 1, true);
        Assert.isNotNull((Object)((Object)source));
        Assert.isNotNull((Object)overview);
        this.parent = control;
        this.source = source;
        this.overview = overview;
        this.browser = browser;
        this.setHideOnMouseDown(false);
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        Shell shell = parent.getShell();
        this.setData(Shell.class.getName(), shell);
        Color backgroundColor = shell.getBackground();
        if (shell.getData(INITIALIZED_FLAG) == null) {
            shell.setData(INITIALIZED_FLAG, (Object)Boolean.TRUE);
            backgroundColor = shell.getDisplay().getSystemColor(1);
            shell.setBackground(backgroundColor);
            new StyleHelper().on((Widget)shell).addClasses(new String[]{"ToolTip", "OverviewToolTip"});
        }
        AbstractMarketplaceDiscoveryItem.setWidgetId((Widget)shell, "overview");
        GridLayoutFactory.fillDefaults().applyTo(parent);
        Composite container = new Composite(parent, 0);
        container.setBackgroundMode(1);
        container.setBackground(backgroundColor);
        boolean hasImage = false;
        if (this.overview.getScreenshot() != null) {
            hasImage = true;
        }
        boolean addLearnMoreLink = this.browser != null && this.overview.getUrl() != null && this.overview.getUrl().length() > 0;
        boolean borderWidth = true;
        int heightHint = 242;
        int widthHint = 320;
        int containerWidthHintWithImage = 650;
        int containerWidthHintWithoutImage = 500;
        GridDataFactory.fillDefaults().grab(true, true).hint(hasImage ? 650 : 500, -1).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).spacing(3, 0).applyTo(container);
        String summary = this.overview.getSummary();
        Composite summaryContainer = new Composite(container, 0);
        summaryContainer.setBackgroundMode(1);
        GridLayoutFactory.fillDefaults().applyTo(summaryContainer);
        GridDataFactory gridDataFactory = GridDataFactory.fillDefaults().grab(true, true).span(hasImage ? 1 : 2, 1);
        if (hasImage) {
            gridDataFactory.hint(320, 242);
        }
        gridDataFactory.applyTo((Control)summaryContainer);
        Browser summaryLabel = new Browser(summaryContainer, 0);
        AbstractMarketplaceDiscoveryItem.setWidgetId((Widget)summaryLabel, "description");
        Font dialogFont = JFaceResources.getDialogFont();
        summaryLabel.setFont(dialogFont);
        String cssStyle = this.createCssStyle(summaryLabel);
        String html = "<html><style>" + cssStyle + "</style><body>" + TextUtil.cleanInformalHtmlMarkup((String)summary) + "</body></html>";
        summaryLabel.setText(html);
        summaryLabel.setBackground(backgroundColor);
        summaryLabel.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                if (event.location.equals("about:blank")) {
                    return;
                }
                event.doit = false;
                OverviewToolTip.this.hide();
                WorkbenchUtil.openUrl((String)event.location, (int)128);
            }

            public void changed(LocationEvent event) {
            }
        });
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(-1, hasImage ? -1 : 240).applyTo((Control)summaryLabel);
        if (hasImage) {
            Composite imageContainer = new Composite(container, 2048);
            imageContainer.setBackgroundMode(1);
            GridLayoutFactory.fillDefaults().applyTo(imageContainer);
            GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 1).hint(322, 242).applyTo((Control)imageContainer);
            Label imageLabel = new Label(imageContainer, 0);
            AbstractMarketplaceDiscoveryItem.setWidgetId((Widget)imageLabel, "screenshot");
            GridDataFactory.fillDefaults().hint(320, 240).indent(1, 1).applyTo((Control)imageLabel);
            imageLabel.setBackground(backgroundColor);
            imageLabel.setSize(320, 240);
            this.provideImage(imageLabel, this.source, this.overview.getScreenshot());
            Cursor handCursor = new Cursor((Device)imageLabel.getDisplay(), 21);
            imageLabel.setCursor(handCursor);
            imageLabel.addDisposeListener(e -> handCursor.dispose());
            imageLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    OverviewToolTip.this.hide();
                    WorkbenchUtil.openUrl((String)OverviewToolTip.this.overview.getScreenshot(), (int)128);
                }
            });
            imageContainer.setBackground(parent.getDisplay().getSystemColor(16));
        }
        if (addLearnMoreLink) {
            Link link = new Link(summaryContainer, 0);
            AbstractMarketplaceDiscoveryItem.setWidgetId((Widget)link, "learn-more");
            GridDataFactory.fillDefaults().grab(false, false).align(1, 0x1000000).applyTo((Control)link);
            link.setText(Messages.OverviewToolTip_learnMoreLink);
            link.setBackground(backgroundColor);
            link.setToolTipText(NLS.bind((String)Messages.OverviewToolTip_openUrlInBrowser, (Object)this.overview.getUrl()));
            link.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    OverviewToolTip.this.hide();
                    OverviewToolTip.this.browser.openUrl(OverviewToolTip.this.overview.getUrl());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        if (!hasImage) {
            Point optimalSize = summaryContainer.computeSize(-1, -1, true);
            if (optimalSize.y > 252) {
                ((GridData)summaryContainer.getLayoutData()).heightHint = 242;
                container.layout(true);
            }
        }
        Display.getCurrent().asyncExec(() -> {
            if (!parent.isDisposed()) {
                parent.setFocus();
            }
        });
        return container;
    }

    private String createCssStyle(Browser summaryLabel) {
        String defaultCss = this.computeDefaultCss(summaryLabel);
        StyleHelper styleHelper = new StyleHelper().on((Widget)summaryLabel);
        String themeCss = this.loadStylesheet(styleHelper, CSS_PATH);
        if (themeCss == null) {
            themeCss = DEFAULT_THEME_CSS;
        }
        return String.valueOf(defaultCss) + " " + themeCss;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadStylesheet(StyleHelper styleHelper, String cssPath) {
        URL cssUrl = styleHelper.getCurrentThemeStylesheet(cssPath);
        if (cssUrl == null) {
            return null;
        }
        if (cssUrl.equals(latestThemeCssUrl)) {
            return latestThemeCss;
        }
        latestThemeCssUrl = cssUrl;
        latestThemeCss = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                InputStream in = cssUrl.openStream();
                try {
                    String string;
                    block18: {
                        Scanner s = new Scanner(in).useDelimiter("\\Z");
                        try {
                            String themeCss = s.next();
                            latestThemeCss = themeCss = themeCss.replaceAll("[\\r\\n]+", " ");
                            string = themeCss;
                            return string;
                        }
                        finally {
                            if (s == null) break block18;
                            s.close();
                        }
                    }
                    if (in != null) {
                        in.close();
                    }
                    return string;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (Exception ex) {
            MarketplaceClientUi.error(ex);
            return null;
        }
    }

    private String computeDefaultCss(Browser summaryLabel) {
        Font dialogFont = summaryLabel.getFont();
        FontData[] fontData = dialogFont.getFontData();
        String attr = "";
        String fontSizeUnitOfMeasure = "pt";
        if ("macosx".equals(Platform.getOS())) {
            fontSizeUnitOfMeasure = "px";
        } else if ("win32".equals(Platform.getOS())) {
            attr = "overflow: auto; ";
        }
        String defaultTextStyle = String.valueOf(attr) + "font-family:\"" + fontData[0].getName() + "\",Arial,sans-serif !important;font-size:" + fontData[0].getHeight() + fontSizeUnitOfMeasure + " !important;";
        String defaultBodyStyle = "margin: 0px;";
        String defaultCss = "*  {" + defaultTextStyle + "} body { " + defaultBodyStyle + "}";
        return defaultCss;
    }

    protected void afterHideToolTip(Event event) {
        this.setData(Shell.class.getName(), null);
    }

    private void provideImage(final Label imageLabel, MarketplaceCatalogSource discoverySource, final String imagePath) {
        ResourceProvider resourceProvider = discoverySource.getResourceProvider();
        MarketplaceDiscoveryStrategy.cacheResource(resourceProvider, this.overview.getItem(), imagePath);
        resourceProvider.provideResource(new ResourceProvider.ResourceReceiver<ImageDescriptor>(){

            @Override
            public ImageDescriptor processResource(URL resource) {
                return ImageDescriptor.createFromURL((URL)resource);
            }

            @Override
            public void setResource(ImageDescriptor resource) {
                if (resource != null && imageLabel != null && !imageLabel.isDisposed()) {
                    imageLabel.getDisplay().asyncExec(() -> {
                        if (!imageLabel.isDisposed()) {
                            try {
                                Image image = resource.createImage();
                                if (image != null) {
                                    Rectangle imageBounds = image.getBounds();
                                    if (imageBounds.width > 320 || imageBounds.height > 240) {
                                        Image scaledImage = Util.scaleImage(image, 320, 240);
                                        Image originalImage = image;
                                        image = scaledImage;
                                        originalImage.dispose();
                                    }
                                    Image fimage = image;
                                    imageLabel.addDisposeListener(e -> fimage.dispose());
                                    imageLabel.setImage(image);
                                }
                            }
                            catch (SWTException e2) {
                                MarketplaceClientUi.error(NLS.bind((String)Messages.OverviewToolTip_cannotRenderImage_reason, (Object)imagePath, (Object)e2.getMessage()), e2);
                            }
                        }
                    });
                }
            }
        }, imagePath, null);
    }

    public void show(Control titleControl) {
        Point titleAbsLocation = titleControl.getParent().toDisplay(titleControl.getLocation());
        Point containerAbsLocation = this.parent.getParent().toDisplay(this.parent.getLocation());
        Rectangle bounds = titleControl.getBounds();
        int relativeX = titleAbsLocation.x - containerAbsLocation.x;
        int relativeY = titleAbsLocation.y - containerAbsLocation.y;
        if (org.eclipse.jface.util.Util.isGtk()) {
            GC gc = new GC((Drawable)titleControl);
            try {
                gc.setFont(titleControl.getFont());
                int height = gc.getFontMetrics().getHeight();
                relativeY += bounds.height - height;
            }
            finally {
                gc.dispose();
            }
        } else {
            relativeY += bounds.height + 3;
        }
        this.show(new Point(relativeX, relativeY));
    }
}

