/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.ale.language.metaprogramming;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecoretools.ale.Operation;
import org.eclipse.emf.ecoretools.ale.Tag;
import org.eclipse.emf.ecoretools.ale.Unit;
import org.eclipse.gemoc.dsl.Entry;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.ILanguageComponentValidator;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.Message;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.Severity;

public class AleRule
implements ILanguageComponentValidator {
    public Message validate(Entry entry) {
        if ("ale".matches(entry.getKey())) {
            URI uri = URI.createURI((String)entry.getValue());
            if (!uri.isPlatformResource()) {
                return new Message("File for \"ale\" entry not in the workspace", Severity.ERROR);
            }
            ResourceSetImpl rs = new ResourceSetImpl();
            try {
                Resource res = rs.getResource(uri, true);
                EList contents = ((EObject)res.getContents().get(0)).eContents();
                if (contents.isEmpty()) {
                    return new Message("No classes in ale file", Severity.ERROR);
                }
                TreeIterator tree = res.getAllContents();
                ArrayList tags = new ArrayList();
                while (tree.hasNext()) {
                    Operation nodeOperation;
                    EObject node = (EObject)tree.next();
                    boolean cfr_ignored_0 = node instanceof Unit;
                    if (!(node instanceof Operation) || (nodeOperation = (Operation)node).getTag().isEmpty()) continue;
                    tags.addAll(nodeOperation.getTag());
                }
                ArrayList<String> tagNames = new ArrayList<String>();
                for (Tag tag : tags) {
                    tagNames.add(tag.getName());
                }
                if (!tagNames.contains("init")) {
                    return new Message("The Ale file does not contain an \"@init\" operation", Severity.WARNING);
                }
                if (!tagNames.contains("main")) {
                    return new Message("The Ale file does not contain an \"@main\" operation", Severity.ERROR);
                }
            }
            catch (RuntimeException runtimeException) {
                return new Message("The file for the \"ale\" entry does not exist", Severity.ERROR);
            }
        }
        return new Message("", Severity.DEFAULT);
    }
}

