/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dsa.executors.explorer;

import grph.Grph;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons.MoccmlModelExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dsa.executors.explorer.ControlAndRTDState;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dsa.executors.explorer.StateSpace;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.engine.MoccmlExecutionEngine;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.dsa.helper.IK3ModelStateHelper;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.moc.ICCSLSolver;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericParallelStep;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericStep;
import org.eclipse.gemoc.trace.commons.model.trace.SmallStep;
import org.eclipse.gemoc.trace.commons.model.trace.Step;

public class ExhaustiveConcurrentExecutionEngine
extends MoccmlExecutionEngine {
    public StateSpace stateSpace = new StateSpace();
    protected ArrayList<ControlAndRTDState> statesToExplore = new ArrayList();

    public ExhaustiveConcurrentExecutionEngine(MoccmlModelExecutionContext concurrentexecutionContext, ICCSLSolver s) throws CoreException {
        super(concurrentexecutionContext, s);
    }

    protected void performExecutionStep() {
        ControlAndRTDState initialState;
        String fullLanguageName = ((MoccmlModelExecutionContext)this._executionContext).getLanguageDefinitionExtension().getName();
        int lastDot = fullLanguageName.lastIndexOf(".");
        if (lastDot == -1) {
            lastDot = 0;
        }
        String languageName = fullLanguageName.substring(lastDot + 1);
        String languageToUpperFirst = String.valueOf(languageName.substring(0, 1).toUpperCase()) + languageName.substring(1);
        IK3ModelStateHelper modelStateHelper = null;
        try {
            modelStateHelper = (IK3ModelStateHelper)((MoccmlModelExecutionContext)this._executionContext).getDslBundle().loadClass(String.valueOf(languageToUpperFirst.toLowerCase()) + ".xdsml.api.impl." + languageToUpperFirst + "ModelStateHelper").newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        EObject model = (EObject)((MoccmlModelExecutionContext)this._executionContext).getResourceModel().getContents().get(0);
        System.out.println(model);
        this.stateSpace.initialState = initialState = new ControlAndRTDState(modelStateHelper.getK3ModelState(model), ((ICCSLSolver)this._solver).getState());
        this.stateSpace.addVertex(initialState);
        this.statesToExplore.add(initialState);
        while (!this.statesToExplore.isEmpty()) {
            System.out.println("################################################### still " + this.statesToExplore.size() + " steps to explore");
            ControlAndRTDState currentState = this.statesToExplore.remove(0);
            modelStateHelper.restoreModelState(currentState.modelState);
            ((ICCSLSolver)this._solver).setState(currentState.moCCState);
            this._possibleLogicalSteps = this.computeWithoutUpdatePossibleLogicalSteps();
            int originalPossibleLogicalStepSize = this.getPossibleLogicalSteps().size();
            int i = 0;
            while (i < this.getPossibleLogicalSteps().size()) {
                StringBuffer buf;
                if (this.getPossibleLogicalSteps().size() != originalPossibleLogicalStepSize) {
                    System.err.println("something went wrong during mocc state save/restore");
                }
                Step aStep = (Step)this.getPossibleLogicalSteps().get(i);
                this.setSelectedLogicalStep(aStep);
                try {
                    this.executeSelectedLogicalStep();
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
                ((ICCSLSolver)this._solver).applyLogicalStep(aStep);
                this.engineStatus.incrementNbLogicalStepRun();
                ControlAndRTDState newState = new ControlAndRTDState(modelStateHelper.getK3ModelState(model), ((ICCSLSolver)this._solver).getState());
                ControlAndRTDState theExistingState = null;
                for (ControlAndRTDState s : this.stateSpace.getVertices()) {
                    if (!newState.equals(s)) continue;
                    theExistingState = s;
                    break;
                }
                if (theExistingState == null) {
                    this.stateSpace.addVertex(newState);
                    buf = new StringBuffer(this.prettyPrint((GenericParallelStep)aStep));
                    this.stateSpace.addDirectedSimpleEdge(currentState, buf, newState);
                    this.statesToExplore.add(newState);
                } else {
                    assert (theExistingState != null);
                    System.out.println("there is a loop");
                    buf = new StringBuffer(this.prettyPrint((GenericParallelStep)aStep));
                    this.stateSpace.addDirectedSimpleEdge(currentState, buf, theExistingState);
                }
                modelStateHelper.restoreModelState(currentState.modelState);
                ((ICCSLSolver)this._solver).setState(currentState.moCCState);
                this.computePossibleLogicalSteps();
                ++i;
            }
        }
        this.stop();
        PrintStream ps = null;
        String modelPath = ((MoccmlModelExecutionContext)this._executionContext).getResourceModel().getURI().toPlatformString(true);
        IProject modelProject = ResourcesPlugin.getWorkspace().getRoot().getProject(modelPath.substring(1, modelPath.substring(1).indexOf(47) + 1));
        IFile dotFile = modelProject.getFile(String.valueOf(modelPath.replace("/" + modelProject.getName() + "/", "")) + "_statespace.dot");
        try {
            ps = new PrintStream(dotFile.getLocationURI().toString().substring(5));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        Grph internalGrph = this.stateSpace.getGrph();
        System.out.println("################################################res: " + internalGrph.getVertices().size() + " states and " + internalGrph.getEdges().size() + " transitions");
        ps.print(internalGrph.toDot());
        ps.close();
    }

    private String prettyPrint(GenericParallelStep aStep) {
        StringBuilder sbStep = new StringBuilder();
        for (GenericStep s : aStep.getSubSteps()) {
            sbStep.append(String.valueOf(((SmallStep)s).getMseoccurrence().getMse().getName()) + " ");
        }
        return sbStep.toString();
    }

    @Override
    public String engineKindName() {
        return "GEMOC Moccml Exhaustive Concurrent Engine";
    }
}

