/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse.FreeClockFutureAction;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse.OperationExecution;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse.SynchroneExecution;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.engine.MoccmlExecutionEngine;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.AbstractConcurrentExecutionEngine;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dsa.executors.CodeExecutionException;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dse.IMoccmlMSEStateController;
import org.eclipse.gemoc.executionframework.engine.Activator;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.ActionFinishedCondition;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.ActionResultCondition;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.ComparisonOperator;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.Condition;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.Force;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.ForceKind;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.When;
import org.eclipse.gemoc.trace.commons.model.trace.SmallStep;
import org.eclipse.gemoc.trace.commons.model.trace.Step;

public class ASynchroneExecution
extends OperationExecution {
    private Collection<When> _whenStatements;
    private IMoccmlMSEStateController _clockController;
    private HashMap<Force, When> _forces;
    private Consumer<Step<?>> beforeStep;
    private Runnable afterStep;

    public ASynchroneExecution(SmallStep<?> smallStep, Collection<When> whenStatements, IMoccmlMSEStateController clockController, AbstractConcurrentExecutionEngine engine, Consumer<Step<?>> beforeStep, Runnable afterStep) {
        super(smallStep, engine, beforeStep, afterStep);
        this.beforeStep = beforeStep;
        this.afterStep = afterStep;
        this._whenStatements = whenStatements;
        this._clockController = clockController;
    }

    @Override
    public void run() {
        Condition condition;
        this.collectForces();
        for (Force force : this._forces.keySet()) {
            if (!force.getKind().equals((Object)ForceKind.PRESENCE)) continue;
            this._clockController.forceAbsenceTickInTheFuture(force.getEventToBeForced());
        }
        boolean shouldBeLaunchInAThread = false;
        for (Map.Entry<Force, When> entry : this._forces.entrySet()) {
            condition = entry.getValue().getCondition();
            if (!(condition instanceof ActionFinishedCondition)) continue;
            shouldBeLaunchInAThread = true;
        }
        if (shouldBeLaunchInAThread) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ASynchroneExecution.this.internalRun();
                }
            };
            Thread t = new Thread(runnable);
            t.start();
        } else {
            try {
                this.executeMSESynchronously();
                for (Map.Entry<Force, When> entry : this._forces.entrySet()) {
                    condition = entry.getValue().getCondition();
                    this.dealWithExecutionResult(entry, condition);
                }
            }
            catch (Exception e) {
                Activator.getDefault().error("Exception received " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void collectForces() {
        this._forces = new HashMap();
        for (When statement : this._whenStatements) {
            if (!(statement.getAction() instanceof Force)) continue;
            Force a = (Force)statement.getAction();
            this._forces.put(a, statement);
        }
    }

    protected void internalRun() {
        try {
            this.executeMSESynchronously();
            for (Map.Entry<Force, When> entry : this._forces.entrySet()) {
                Condition condition = entry.getValue().getCondition();
                if (condition instanceof ActionFinishedCondition) {
                    this._clockController.freeInTheFuture(entry.getKey().getEventToBeForced());
                    continue;
                }
                this.dealWithExecutionResult(entry, condition);
            }
        }
        catch (Exception e) {
            Activator.getDefault().error("Exception received " + e.getMessage(), (Throwable)e);
        }
    }

    private void dealWithExecutionResult(Map.Entry<Force, When> entry, Condition condition) throws Exception {
        if (condition instanceof ActionResultCondition) {
            ActionResultCondition resultCondition = (ActionResultCondition)condition;
            boolean goOn = false;
            switch (resultCondition.getOperator().getValue()) {
                case 3: {
                    goOn = this.getResult() != resultCondition.getComparisonValue();
                    break;
                }
                case 0: {
                    goOn = this.getResult().equals(resultCondition.getComparisonValue());
                    break;
                }
                default: {
                    goOn = this.tryNumber(resultCondition.getOperator(), this.getResult(), resultCondition.getComparisonValue());
                }
            }
            if (goOn) {
                if (entry.getKey().getOnTrigger() == null) {
                    this._clockController.freeInTheFuture(entry.getKey().getEventToBeForced());
                } else {
                    FreeClockFutureAction action = new FreeClockFutureAction(entry.getKey().getEventToBeForced(), entry.getKey().getOnTrigger(), this._clockController);
                    ((MoccmlExecutionEngine)this.getEngine()).addFutureAction(action);
                }
            }
        }
    }

    private boolean tryNumber(ComparisonOperator operator, Object result, Object comparisonValue) throws Exception {
        Double s1 = null;
        Double s2 = null;
        if (result instanceof Number && comparisonValue instanceof Number) {
            s1 = ((Number)result).doubleValue();
            s2 = ((Number)comparisonValue).doubleValue();
        }
        if (s1 == null || s2 == null) {
            throw new Exception("Cannot convert result or comparison value to double.");
        }
        boolean goOn = false;
        int comparisonResult = Double.compare(s1, s2);
        switch (operator.getValue()) {
            case 4: {
                goOn = comparisonResult <= 0;
                break;
            }
            case 1: {
                goOn = comparisonResult < 0;
                break;
            }
            case 5: {
                goOn = comparisonResult >= 0;
                break;
            }
            case 2: {
                goOn = comparisonResult > 0;
            }
        }
        return goOn;
    }

    private void executeMSESynchronously() throws CodeExecutionException {
        SynchroneExecution execution = new SynchroneExecution(this.getSmallStep(), this.getEngine(), this.beforeStep, this.afterStep);
        execution.run();
        this.setResult(execution.getResult());
    }
}

