/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.engine;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons.MoccmlExecutionPlatform;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons.MoccmlModelExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.concurrentmse.FeedbackMSE;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse.ASynchroneExecution;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse.DefaultMSEStateController;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse.OperationExecution;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse.SynchroneExecution;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.engine.AbstractSolverCodeExecutorConcurrentEngine;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IMoccmlRunConfiguration;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dsa.executors.CodeExecutionException;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dse.IMoccmlFutureAction;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dse.IMoccmlMSEStateController;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.moc.ICCSLSolver;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.ActionModel;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.When;
import org.eclipse.gemoc.trace.commons.model.trace.MSE;
import org.eclipse.gemoc.trace.commons.model.trace.SmallStep;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionContext;

public class MoccmlExecutionEngine
extends AbstractSolverCodeExecutorConcurrentEngine<MoccmlModelExecutionContext, IMoccmlRunConfiguration, ICCSLSolver> {
    private ArrayList<IMoccmlFutureAction> _futureActions = new ArrayList();
    private Object _futureActionsLock = new Object();
    private IMoccmlMSEStateController _mseStateController;

    public MoccmlExecutionEngine(MoccmlModelExecutionContext concurrentexecutionContext, ICCSLSolver s) throws CoreException {
        this.setSolver(s);
        this.initialize((IExecutionContext)concurrentexecutionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFutureAction(IMoccmlFutureAction action) {
        Object object = this._futureActionsLock;
        synchronized (object) {
            this._futureActions.add(action);
        }
    }

    public String engineKindName() {
        return "GEMOC Moccml Engine";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAssociatedActions(MSE mse) {
        Object object = this._futureActionsLock;
        synchronized (object) {
            ArrayList<IMoccmlFutureAction> actionsToRemove = new ArrayList<IMoccmlFutureAction>();
            for (IMoccmlFutureAction action : this._futureActions) {
                if (action.getTriggeringMSE() != mse) continue;
                actionsToRemove.add(action);
                action.perform();
            }
            this._futureActions.removeAll(actionsToRemove);
        }
    }

    protected void executeSmallStep(SmallStep<?> smallStep) throws CodeExecutionException {
        this.executeAssociatedActions(smallStep.getMseoccurrence().getMse());
        MSE mse = smallStep.getMseoccurrence().getMse();
        if (mse.getAction() != null) {
            ArrayList<When> whenStatements = new ArrayList<When>();
            if (mse instanceof FeedbackMSE) {
                ActionModel feedbackModel = ((MoccmlModelExecutionContext)this._executionContext).getFeedbackModel();
                for (When w : feedbackModel.getWhenStatements()) {
                    if (w.getSource() != ((FeedbackMSE)mse).getFeedbackModelSpecificEvent()) continue;
                    whenStatements.add(w);
                }
            }
            OperationExecution execution = null;
            Consumer<Step<?>> beforeStep = s -> this.beforeExecutionStep((Step)s);
            Runnable afterStep = () -> this.afterExecutionStep();
            execution = whenStatements.size() == 0 ? new SynchroneExecution(smallStep, this, beforeStep, afterStep) : new ASynchroneExecution(smallStep, whenStatements, this._mseStateController, this, beforeStep, afterStep);
            ((OperationExecution)execution).run();
        }
    }

    public void recomputePossibleLogicalSteps() {
        ((ICCSLSolver)this.getSolver()).revertForceClockEffect();
        this.updatePossibleLogicalSteps();
        this.notifyProposedLogicalStepsChanged();
    }

    @Override
    protected void beforeUpdatePossibleLogicalSteps() {
        for (IMoccmlMSEStateController c : ((MoccmlExecutionPlatform)((MoccmlModelExecutionContext)this.getExecutionContext()).getExecutionPlatform()).getMSEStateControllers()) {
            c.applyMSEFutureStates(this.getSolver());
        }
    }

    protected void performSpecificInitialize(MoccmlModelExecutionContext executionContext) {
        MoccmlModelExecutionContext concurrentExecutionContext = (MoccmlModelExecutionContext)this.getExecutionContext();
        ((ICCSLSolver)this.getSolver()).setExecutableModelResource(concurrentExecutionContext.getResourceModel());
        this._mseStateController = new DefaultMSEStateController();
        ((MoccmlExecutionPlatform)concurrentExecutionContext.getExecutionPlatform()).getMSEStateControllers().add(this._mseStateController);
        this.executeInitializeModelMethod(executionContext);
        executionContext.setUpMSEModel();
        executionContext.setUpFeedbackModel();
    }

    protected void doAfterLogicalStepExecution(Step<?> logicalStep) {
        ((ICCSLSolver)this.getSolver()).applyLogicalStep(logicalStep);
    }
}

