/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gemoc.commons.eclipse.core.resources.NewProjectWorkspaceListener;
import org.eclipse.gemoc.commons.eclipse.ui.WizardFinder;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.Activator;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.dialogs.SelectECLIFileDialog;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.wizards.CreateNewDSEProject;
import org.eclipse.gemoc.xdsmlframework.ui.utils.XDSMLProjectHelper;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class CreateDSEWizardContextAction {
    public CreateDSEAction actionToExecute = CreateDSEAction.CREATE_NEW_DSE_PROJECT;
    protected IProject gemocLanguageIProject = null;
    protected String gemocLanguage = null;
    private String eclPath = null;

    public CreateDSEWizardContextAction(IProject updatedGemocLanguageProject) {
        this.gemocLanguageIProject = updatedGemocLanguageProject;
    }

    public CreateDSEWizardContextAction(IProject updatedGemocLanguageProject, String aLanguage) {
        this.gemocLanguageIProject = updatedGemocLanguageProject;
        this.gemocLanguage = aLanguage;
    }

    public void execute() {
        switch (this.actionToExecute) {
            case CREATE_NEW_DSE_PROJECT: {
                this.createNewDSEProject();
                break;
            }
            case SELECT_EXISTING_DSE_PROJECT: {
                this.selectExistingDSEProject();
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createNewDSEProject() {
        IWizardDescriptor descriptor = WizardFinder.findNewWizardDescriptor((String)"org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.wizards.CreateNewDSEProject");
        if (descriptor != null) {
            NewProjectWorkspaceListener workspaceListener = new NewProjectWorkspaceListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)workspaceListener);
            try {
                try {
                    IWorkbenchWizard wizard = descriptor.createWizard();
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    CreateNewDSEProject createNewDSEProjectWizard = (CreateNewDSEProject)wizard;
                    String mLanguage = this.getLanguage();
                    if (mLanguage != null) {
                        this.initWizardFromMelangeLanguage(createNewDSEProjectWizard, mLanguage);
                    }
                    wizard.init(workbench, null);
                    WizardDialog wd = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                    wd.create();
                    wd.setTitle(wizard.getWindowTitle());
                    int res = wd.open();
                    if (res != 0) return;
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
                    IProject createdProject = workspaceListener.getLastCreatedProject();
                    if (createdProject != null) {
                        this.eclPath = "/" + createNewDSEProjectWizard.createdProjectName + "/ecl/" + createNewDSEProjectWizard.createdTemplateECLFile + ".ecl";
                        this.addECLFileToConf(createNewDSEProjectWizard.createdProjectName, this.eclPath, this.gemocLanguageIProject);
                        return;
                    }
                    Activator.error("not able to detect which project was created by wizard", null);
                    return;
                }
                catch (CoreException e) {
                    Activator.error(e.getMessage(), e);
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
                }
                return;
            }
            finally {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
            }
        } else {
            Activator.error("wizard with id=org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.ui.wizards.CreateNewDSEProject not found", null);
        }
    }

    protected void initWizardFromMelangeLanguage(CreateNewDSEProject createNewDSEProjectWizard, String language) {
        createNewDSEProjectWizard._askProjectNamePage.setInitialProjectName(String.valueOf(XDSMLProjectHelper.baseProjectName((IProject)this.gemocLanguageIProject)) + ".dse");
        createNewDSEProjectWizard._askDSEInfoPage.initialTemplateECLFileFieldValue = language;
    }

    protected void selectExistingDSEProject() {
        SelectECLIFileDialog dialog = new SelectECLIFileDialog();
        int res = dialog.open();
        if (res == 0) {
            this.addECLFileToConf(((IResource)dialog.getResult()[0]).getProject().getName(), ((IResource)dialog.getResult()[0]).getFullPath().toString(), this.gemocLanguageIProject);
        }
    }

    protected void addECLFileToConf(String projectName, String eclFileURI, IProject gemocLanguageIProject) {
    }

    protected String getLanguage() {
        if (this.gemocLanguage != null) {
            return this.gemocLanguage;
        }
        return null;
    }

    public String getEclPath() {
        return this.eclPath;
    }

    public static enum CreateDSEAction {
        CREATE_NEW_DSE_PROJECT,
        SELECT_EXISTING_DSE_PROJECT;

    }
}

