/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.moccml.mapping.qvto2ccsl.ui.popup.actions;

import com.google.inject.Injector;
import fr.inria.aoste.timesquare.ccslkernel.parser.xtext.ExtendedCCSLStandaloneSetup;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public class Qvto2CCSLTranslator
implements IObjectActionDelegate {
    private IFile modelFile = null;
    private IFile qvtoFile = null;
    private XtextResourceSet aModelResourceSet = null;
    private XtextResourceSet outputResourceSet = null;
    private ResourceSet feedbackResourceSet = null;
    private ResourceSet priorityResourceSet = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    private void initializeXtext() {
        ExtendedCCSLStandaloneSetup ess = new ExtendedCCSLStandaloneSetup();
        Injector injector = ess.createInjector();
        this.aModelResourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        this.outputResourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        this.aModelResourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        ExtendedCCSLStandaloneSetup.doSetup();
        this.feedbackResourceSet = new ResourceSetImpl();
        this.priorityResourceSet = new ResourceSetImpl();
    }

    public void run(IAction action) {
        this.initializeXtext();
        String qvtoUriString = this.qvtoFile.getLocation().toOSString();
        URI transformationURI = URI.createFileURI((String)qvtoUriString);
        String modelUriString = String.valueOf(this.modelFile.getProject().getName()) + "/" + this.modelFile.getProjectRelativePath().toOSString();
        URI modelUri = URI.createPlatformResourceURI((String)modelUriString, (boolean)false);
        Resource modelResource = this.aModelResourceSet.getResource(modelUri, true);
        HashMap saveOptions = new HashMap();
        SaveOptions.Builder aBuilder = SaveOptions.newBuilder();
        SaveOptions anOption = aBuilder.getOptions();
        anOption.addTo(saveOptions);
        try {
            modelResource.load(saveOptions);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        TransformationExecutor executor = new TransformationExecutor(transformationURI);
        BasicModelExtent input = new BasicModelExtent((List)modelResource.getContents());
        BasicModelExtent output = new BasicModelExtent();
        BasicModelExtent feedback = new BasicModelExtent();
        BasicModelExtent priority = new BasicModelExtent();
        ExecutionContextImpl context = new ExecutionContextImpl();
        ExecutionDiagnostic diagnostic = executor.execute((ExecutionContext)context, new ModelExtent[]{input, output, feedback, priority});
        System.out.println(diagnostic);
        int numberOfCharToRemove = modelUriString.length() - modelUri.fileExtension().length() - 1;
        String outputPathString = String.valueOf(modelUriString.substring(0, numberOfCharToRemove)) + "_MoCC.extendedCCSL";
        URI outputUri = URI.createPlatformResourceURI((String)outputPathString, (boolean)false);
        Resource outputResource = null;
        try {
            outputResource = this.outputResourceSet.createResource(outputUri);
        }
        catch (Exception e) {
            System.out.println(e);
            outputResource = this.outputResourceSet.createResource(outputUri);
        }
        outputResource.getContents().addAll((Collection)output.getContents());
        try {
            outputResource.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String feedbackPathString = String.valueOf(modelUriString.substring(0, numberOfCharToRemove)) + ".feedback";
        URI feedbackUri = URI.createPlatformResourceURI((String)feedbackPathString, (boolean)false);
        Resource feedbackResource = null;
        try {
            feedbackResource = this.feedbackResourceSet.createResource(feedbackUri);
        }
        catch (Exception e) {
            System.out.println(e);
            feedbackResource = this.feedbackResourceSet.createResource(feedbackUri);
        }
        feedbackResource.getContents().addAll((Collection)feedback.getContents());
        try {
            feedbackResource.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String priorityPathString = String.valueOf(modelUriString.substring(0, numberOfCharToRemove)) + ".prioritymodel";
        URI priorityUri = URI.createPlatformResourceURI((String)priorityPathString, (boolean)false);
        Resource priorityResource = null;
        try {
            priorityResource = this.priorityResourceSet.createResource(priorityUri);
        }
        catch (Exception e) {
            System.out.println(e);
            priorityResource = this.priorityResourceSet.createResource(priorityUri);
        }
        priorityResource.getContents().addAll((Collection)priority.getContents());
        try {
            priorityResource.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.qvtoFile = null;
        this.modelFile = null;
        if (selection instanceof TreeSelection) {
            TreeSelection ts = (TreeSelection)selection;
            for (Object o : ts) {
                if (!(o instanceof IFile)) continue;
                IFile f = (IFile)o;
                if (f.getFileExtension().compareTo("qvto") == 0) {
                    this.qvtoFile = (IFile)o;
                    continue;
                }
                this.modelFile = (IFile)o;
            }
        }
    }
}

