/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.build.fragments;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.utils.StandaloneSetup;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.build.fragments.MergeWriter;
import org.eclipse.ocl.examples.codegen.generator.AbstractGenModelHelper;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.resource.impl.BinaryGrammarResourceFactoryImpl;
import org.eclipse.xtext.util.Strings;

public abstract class GenerateGrammar
extends AbstractWorkflowComponent {
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    protected ResourceSet resourceSet = null;
    protected String languageName;
    protected String javaFolder;
    protected String javaPackageName;
    protected String grammarFileStem;
    protected String sourceFile;
    protected AbstractGenModelHelper genModelHelper;
    private Map<EClassifier, Map<Notifier, String>> nameMaps = new HashMap<EClassifier, Map<Notifier, String>>();
    private Map<String, Grammar> name2grammar = new HashMap<String, Grammar>();

    public void checkConfiguration(Issues issues) {
        if (this.javaFolder == null) {
            issues.addError((WorkflowComponent)this, "javaFolder not specified.");
        }
        if (this.javaPackageName == null) {
            issues.addError((WorkflowComponent)this, "javaPackageName not specified.");
        }
        if (this.grammarFileStem == null) {
            issues.addError((WorkflowComponent)this, "grammarFileStem not specified.");
        }
        if (this.languageName == null) {
            this.languageName = String.valueOf(this.javaPackageName) + "." + this.grammarFileStem;
        }
    }

    protected @NonNull String emitEClassifierLiteral(@NonNull EClassifier eClassifier) {
        EPackage ePackage = (EPackage)ClassUtil.nonNullEMF((Object)eClassifier.getEPackage());
        GenPackage genPackage = this.genModelHelper.getGenPackage(ePackage);
        if (genPackage == null) {
            return "<<" + ePackage.getNsURI() + ">>";
        }
        return String.valueOf(genPackage.getQualifiedPackageInterfaceName()) + ".Literals" + "." + this.genModelHelper.getLiteralName(eClassifier);
    }

    protected @NonNull String emitEPackageLiteral(@NonNull EPackage ePackage) {
        GenPackage genPackage = this.genModelHelper.getGenPackage(ePackage);
        if (genPackage == null) {
            return "<<" + ePackage.getNsURI() + ">>";
        }
        return String.valueOf(genPackage.getQualifiedPackageInterfaceName()) + ".eINSTANCE";
    }

    protected @NonNull String emitEEnumLiteral(@NonNull EEnumLiteral enumLiteral) {
        EEnum eClassifier = enumLiteral.getEEnum();
        EPackage ePackage = (EPackage)ClassUtil.nonNullEMF((Object)eClassifier.getEPackage());
        GenPackage genPackage = this.genModelHelper.getGenPackage(ePackage);
        if (genPackage == null) {
            return "<<" + ePackage.getNsURI() + ">>";
        }
        return String.valueOf(genPackage.getQualifiedPackageInterfaceName()) + ".Literals" + "." + this.genModelHelper.getLiteralName((EClassifier)eClassifier) + ".getEEnumLiteral(\"" + enumLiteral.getName() + "\")";
    }

    protected @NonNull String emitParserRuleLiteral(@NonNull Grammar grammar, @NonNull ParserRule parserRule) {
        Grammar referencedGrammar = (Grammar)parserRule.eContainer();
        if (referencedGrammar == null || referencedGrammar == grammar) {
            return "PR_" + parserRule.getName();
        }
        return String.valueOf(this.getGrammarPackageName(referencedGrammar)) + ".PR_" + parserRule.getName();
    }

    protected @NonNull String emitEnumRuleLiteral(@NonNull Grammar grammar, @NonNull EnumRule enumRule) {
        Grammar referencedGrammar = (Grammar)enumRule.eContainer();
        if (referencedGrammar == null || referencedGrammar == grammar) {
            return "ER_" + enumRule.getName();
        }
        return String.valueOf(this.getGrammarPackageName(referencedGrammar)) + ".ER_" + enumRule.getName();
    }

    protected @NonNull String emitReferencedMetamodelName(@NonNull Grammar grammar, @NonNull ReferencedMetamodel referencedMetamodel) {
        String alias = referencedMetamodel.getAlias();
        if (alias == null) {
            return "MM";
        }
        return "MM_" + alias;
    }

    protected @NonNull String emitSymbol(EClassifier eClass, @NonNull Notifier eObject) {
        String name;
        Map<Notifier, String> names = this.nameMaps.get(eClass);
        if (names == null) {
            names = new HashMap<Notifier, String>();
            this.nameMaps.put(eClass, names);
        }
        if ((name = names.get(eObject)) == null) {
            name = String.valueOf(eClass.getName()) + "_" + names.size();
            names.put(eObject, name);
        }
        return name;
    }

    protected @NonNull String emitTerminalRuleLiteral(@NonNull Grammar grammar, @NonNull TerminalRule terminalRule) {
        Grammar referencedGrammar = (Grammar)terminalRule.eContainer();
        if (referencedGrammar == null || referencedGrammar == grammar) {
            return "TR_" + terminalRule.getName();
        }
        return String.valueOf(this.getGrammarPackageName(referencedGrammar)) + ".TR_" + terminalRule.getName();
    }

    protected @NonNull String emitValue(Object value) {
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        return value != null ? "\"" + Strings.convertToJavaString((String)value.toString()) + "\"" : "null";
    }

    protected abstract String generate(Resource var1);

    protected String getGetAccessorName(@NonNull EStructuralFeature eStructuralFeature) {
        return this.genModelHelper.getGetAccessor(eStructuralFeature);
    }

    protected @NonNull String getGrammarPackageName(@NonNull Grammar grammar) {
        String name = grammar.getName();
        int index = name.lastIndexOf(".");
        name = index >= 0 ? "_" + name.substring(index + 1) : "_" + name;
        Grammar theGrammar = this.name2grammar.get(name);
        if (theGrammar == null) {
            theGrammar = grammar;
            this.name2grammar.put(name, theGrammar);
        }
        if (theGrammar == grammar) {
            return name;
        }
        return "_" + grammar.getName().replaceAll("\\.", "_");
    }

    protected ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
        }
        return this.resourceSet;
    }

    protected String getSetAccessorName(@NonNull EStructuralFeature eStructuralFeature) {
        return this.genModelHelper.getSetAccessor(eStructuralFeature);
    }

    protected <AR extends AbstractRule> List<AR> getSortedAbstractRules(@NonNull Grammar grammar, Class<AR> type) {
        ArrayList<AbstractRule> abstractRules = new ArrayList<AbstractRule>();
        TreeIterator tit = grammar.eAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!type.isInstance(eObject)) continue;
            abstractRules.add((AbstractRule)type.cast(eObject));
        }
        Collections.sort(abstractRules, new Comparator<AR>(){

            @Override
            public int compare(@NonNull AR o1, @NonNull AR o2) {
                return ClassUtil.safeCompareTo((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
            }
        });
        return abstractRules;
    }

    protected List<ReferencedMetamodel> getSortedReferencedMetamodels(@NonNull Grammar grammar) {
        ArrayList<ReferencedMetamodel> referencedMetamodels = new ArrayList<ReferencedMetamodel>();
        TreeIterator tit = grammar.eAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof ReferencedMetamodel)) continue;
            referencedMetamodels.add((ReferencedMetamodel)eObject);
        }
        Collections.sort(referencedMetamodels, new Comparator<ReferencedMetamodel>(){

            @Override
            public int compare(ReferencedMetamodel o1, ReferencedMetamodel o2) {
                String n1 = o1.getAlias();
                String n2 = o2.getAlias();
                if (n1 == null) {
                    n1 = "";
                }
                if (n2 == null) {
                    n2 = "";
                }
                return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
            }
        });
        return referencedMetamodels;
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        OCL ocl = OCL.newInstance();
        PivotMetamodelManager metamodelManager = (PivotMetamodelManager)ocl.getMetamodelManager();
        this.genModelHelper = new AbstractGenModelHelper(metamodelManager);
        String rootPath = StandaloneSetup.getPlatformRootPath();
        File folder = new File(String.valueOf(rootPath) + this.javaFolder + "/" + this.javaPackageName.replace(".", "/"));
        try {
            this.sourceFile = new File(folder, String.valueOf(this.grammarFileStem) + ".xtextbin").toString();
            URI fileURI = URI.createFileURI((String)this.sourceFile);
            this.log.info((Object)("Loading Grammar '" + fileURI));
            ResourceSet resourceSet = this.getResourceSet();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xtextbin", new BinaryGrammarResourceFactoryImpl());
            Resource grammarResource = resourceSet.getResource(fileURI, true);
            String message = PivotUtil.formatResourceDiagnostics((List)((List)ClassUtil.nonNullEMF((Object)grammarResource.getErrors())), (String)"Grammar load failure", (String)"\n");
            if (message != null) {
                issues.addError((WorkflowComponent)this, message, null, null, null);
                return;
            }
            try {
                String fileName = folder + "/" + this.grammarFileStem + "GrammarResource.java";
                @NonNull String metamodel = this.generate(grammarResource);
                MergeWriter fw = new MergeWriter(fileName);
                fw.append(metamodel);
                fw.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Problems running " + ((Object)((Object)this)).getClass().getSimpleName(), e);
            }
        }
        finally {
            ocl.dispose();
        }
    }

    public void setGrammarFileStem(String grammarFileStem) {
        this.grammarFileStem = grammarFileStem;
    }

    public void setJavaFolder(String javaFolder) {
        this.javaFolder = javaFolder;
    }

    public void setJavaPackageName(String javaPackageName) {
        this.javaPackageName = javaPackageName;
    }

    public void setLanguageName(String languageName) {
        this.languageName = languageName;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }
}

