/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.pages;

import java.util.ArrayList;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.NewGemocDebugRepresentationWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class DebugRepresentationSelectionPage
extends WizardPage {
    private final NewGemocDebugRepresentationWizard newGemocDebugRepresentationWizard;
    public static final int CREATE_VIEWPOINT_DEFINITION = 0;
    public static final int CREATE_VIEWPOINT_EXTENSION = 1;
    public static final int ADD_DEBUG_LAYER = 2;
    private final Button[] radio = new Button[3];
    private int selected = -1;

    public DebugRepresentationSelectionPage(NewGemocDebugRepresentationWizard newGemocDebugRepresentationWizard) {
        super("Select debug representation mode");
        this.newGemocDebugRepresentationWizard = newGemocDebugRepresentationWizard;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.radio[0] = new Button(composite, 16);
        this.radio[0].setText("Create a debug diagram description.");
        this.radio[0].setToolTipText("creates a dedicated Viewpoint Specification in a new project");
        this.radio[0].setLayoutData((Object)new GridData(768));
        this.radio[0].addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DebugRepresentationSelectionPage.this.selected = 0;
                DebugRepresentationSelectionPage.this.setPageComplete(true);
            }
        });
        this.radio[1] = new Button(composite, 16);
        this.radio[1].setText("Extends an existing diagram description.");
        this.radio[1].setToolTipText("creates a dedicated Viewpoint Specification in a new project as an extension of an existing Viewpoint Specification.");
        this.radio[1].setLayoutData((Object)new GridData(768));
        this.radio[1].addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DebugRepresentationSelectionPage.this.selected = 1;
                ArrayList<DiagramDescription> descriptions = new ArrayList<DiagramDescription>();
                for (Viewpoint viewpoint : ViewpointRegistry.getInstance().getViewpoints()) {
                    for (RepresentationDescription description : viewpoint.getOwnedRepresentations()) {
                        if (!(description instanceof DiagramDescription)) continue;
                        descriptions.add((DiagramDescription)description);
                    }
                }
                DebugRepresentationSelectionPage.this.newGemocDebugRepresentationWizard.getSelectDiagramDefinitionPage().setDescriptions(descriptions);
                DebugRepresentationSelectionPage.this.setPageComplete(true);
            }
        });
        this.radio[2] = new Button(composite, 16);
        this.radio[2].setText("Add a debug layer to an existing diagram description.");
        this.radio[2].setToolTipText("modifies an existing Viewpoint Specification to add a layer.");
        this.radio[2].setLayoutData((Object)new GridData(768));
        this.radio[2].addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DebugRepresentationSelectionPage.this.selected = 2;
                ArrayList<DiagramDescription> descriptions = new ArrayList<DiagramDescription>();
                for (Viewpoint viewpoint : ViewpointRegistry.getInstance().getViewpoints()) {
                    if (ViewpointRegistry.getInstance().isFromPlugin(viewpoint)) continue;
                    for (RepresentationDescription description : viewpoint.getOwnedRepresentations()) {
                        if (!(description instanceof DiagramDescription)) continue;
                        descriptions.add((DiagramDescription)description);
                    }
                }
                DebugRepresentationSelectionPage.this.newGemocDebugRepresentationWizard.getSelectDiagramDefinitionPage().setDescriptions(descriptions);
                DebugRepresentationSelectionPage.this.setPageComplete(true);
            }
        });
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    public int getSelected() {
        return this.selected;
    }

    public IWizardPage getNextPage() {
        WizardPage res = this.selected == 0 ? this.newGemocDebugRepresentationWizard.getNewViewPointProjectPage() : (this.selected == 1 || this.selected == 2 ? this.newGemocDebugRepresentationWizard.getSelectDiagramDefinitionPage() : null);
        return res;
    }

    public void dispose() {
        super.dispose();
        this.radio[0].dispose();
        this.radio[1].dispose();
        this.radio[2].dispose();
    }
}

