/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.property.section;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.editor.properties.sections.common.AbstractViewpointPropertySection;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.featureExtensions.FeatureExtensionsUIManager;
import org.eclipse.sirius.viewpoint.description.audit.provider.AuditItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.provider.DescriptionItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.style.provider.StyleItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.tool.provider.ToolItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.validation.provider.ValidationItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.provider.ViewpointItemProviderAdapterFactory;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AllPropertySection
extends AbstractViewpointPropertySection
implements IPropertySourceProvider {
    protected PropertySheetPage contentPage;
    protected ComposedAdapterFactory adapterFactory;

    public AllPropertySection() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(DialectUIManager.INSTANCE.createAdapterFactory());
        factories.add(FeatureExtensionsUIManager.INSTANCE.createAdapterFactory());
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ViewpointItemProviderAdapterFactory());
        factories.add(new DescriptionItemProviderAdapterFactory());
        factories.add(new StyleItemProviderAdapterFactory());
        factories.add(new ToolItemProviderAdapterFactory());
        factories.add(new ValidationItemProviderAdapterFactory());
        factories.add(new AuditItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.contentPage = new PropertySheetPage();
        PropertySheetEntry root = new PropertySheetEntry();
        root.setPropertySourceProvider((IPropertySourceProvider)this);
        this.contentPage.setRootEntry((IPropertySheetEntry)root);
        this.contentPage.createControl(composite);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.height = 100;
        data.width = 100;
        this.contentPage.getControl().setLayoutData((Object)data);
    }

    public IPropertySource getPropertySource(Object object) {
        IPropertySource propSrc = null;
        if (object instanceof IPropertySource) {
            propSrc = (IPropertySource)object;
        } else if (object instanceof EObject) {
            IItemPropertySource ips;
            if (this.adapterFactory != null && (ips = (IItemPropertySource)this.adapterFactory.adapt(object, IItemPropertySource.class)) != null) {
                propSrc = new PropertySource(object, ips);
            }
        } else {
            IItemPropertySource ips;
            if (this.adapterFactory != null && (ips = (IItemPropertySource)this.adapterFactory.adapt(object, IItemPropertySource.class)) != null) {
                propSrc = new PropertySource(object, ips);
            }
            if (propSrc == null && object instanceof IAdaptable) {
                propSrc = (IPropertySource)((IAdaptable)object).getAdapter(IPropertySource.class);
            }
        }
        return propSrc;
    }

    public void refresh() {
        super.refresh();
        if (this.contentPage != null) {
            this.contentPage.refresh();
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (this.contentPage != null) {
            this.contentPage.selectionChanged(part, selection);
        }
    }

    @Override
    protected void makeReadonly() {
        this.contentPage.getControl().setEnabled(false);
    }

    @Override
    protected void makeWrittable() {
        this.contentPage.getControl().setEnabled(true);
    }

    @Override
    protected EStructuralFeature getFeature() {
        return null;
    }
}

