/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.session;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.AbstractSavingPolicy;
import org.eclipse.sirius.business.internal.session.danalysis.ResourceSaveDiagnose;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class SavingPolicyImpl
extends AbstractSavingPolicy {
    private Map<?, ?> saveOptions;

    public SavingPolicyImpl(TransactionalEditingDomain domain) {
        super(domain);
    }

    @Override
    protected Collection<Resource> computeResourcesToSave(Set<Resource> scope, Map<?, ?> options, IProgressMonitor monitor) {
        this.saveOptions = options;
        Predicate<Resource> savingFilter = new Predicate<Resource>(){

            public boolean apply(Resource input) {
                return SavingPolicyImpl.this.shouldSave(input);
            }
        };
        return Lists.newArrayList((Iterable)Iterables.filter(scope, (Predicate)savingFilter));
    }

    protected boolean hasChangesToSave(Resource resource) {
        boolean hasChangesToSave = false;
        ResourceSaveDiagnose diagnose = new ResourceSaveDiagnose(resource);
        try {
            HashMap mergedOptions = new HashMap(this.getDefaultSaveOptions());
            if (this.saveOptions != null) {
                mergedOptions.putAll(this.saveOptions);
            }
            hasChangesToSave = diagnose.isSaveable() && diagnose.hasDifferentSerialization(mergedOptions);
        }
        catch (IOException e) {
            SiriusPlugin.getDefault().error(Messages.SavingPolicyImpl_savingErrorMsg, e);
        }
        return hasChangesToSave;
    }

    private boolean shouldSave(Resource resource) {
        boolean shouldSave = this.hasChangesToSave(resource);
        if (!shouldSave) {
            ResourceSetSync.ResourceStatus resourceStatus = ResourceSetSync.getStatus((Resource)resource);
            shouldSave = resourceStatus == ResourceSetSync.ResourceStatus.DELETED || resourceStatus == ResourceSetSync.ResourceStatus.CONFLICTING_DELETED;
        }
        return shouldSave;
    }
}

