/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.preferences;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.templates.TemplatePreferencePage;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;

public class XMLTemplatePreferencePage
extends TemplatePreferencePage {
    public XMLTemplatePreferencePage() {
        XMLUIPlugin xmlEditorPlugin = XMLUIPlugin.getDefault();
        this.setPreferenceStore(xmlEditorPlugin.getPreferenceStore());
        this.setTemplateStore(xmlEditorPlugin.getTemplateStore());
        this.setContextTypeRegistry(xmlEditorPlugin.getTemplateContextRegistry());
    }

    protected Control createContents(Composite ancestor) {
        Control c = super.createContents(ancestor);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(c, "org.eclipse.wst.xml.ui.webx0063");
        return c;
    }

    protected SourceViewer createViewer(Composite parent) {
        StructuredTextViewerConfiguration sourceViewerConfiguration = new StructuredTextViewerConfiguration(){
            StructuredTextViewerConfiguration baseConfiguration = new StructuredTextViewerConfigurationXML();

            public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
                return this.baseConfiguration.getConfiguredContentTypes(sourceViewer);
            }

            public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
                return this.baseConfiguration.getLineStyleProviders(sourceViewer, partitionType);
            }
        };
        return this.doCreateViewer(parent, (SourceViewerConfiguration)sourceViewerConfiguration);
    }

    SourceViewer doCreateViewer(Composite parent, SourceViewerConfiguration viewerConfiguration) {
        StructuredTextViewer viewer = null;
        String contentTypeID = ContentTypeIdForXML.ContentTypeID_XML;
        viewer = new StructuredTextViewer(parent, null, null, false, 2816);
        viewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont"));
        IStructuredModel scratchModel = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(contentTypeID);
        IStructuredDocument document = scratchModel.getStructuredDocument();
        viewer.configure(viewerConfiguration);
        viewer.setDocument((IDocument)document);
        return viewer;
    }

    protected Template editTemplate(Template template, boolean edit, boolean isNameModifiable) {
        XMLEditTemplateDialog dialog = new XMLEditTemplateDialog(this.getShell(), template, edit, isNameModifiable, this.getContextTypeRegistry());
        if (dialog.open() == 0) {
            return dialog.getTemplate();
        }
        return null;
    }

    protected boolean isShowFormatterSetting() {
        return false;
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        XMLUIPlugin.getDefault().savePluginPreferences();
        return ok;
    }

    class XMLEditTemplateDialog
    extends TemplatePreferencePage.EditTemplateDialog {
        public XMLEditTemplateDialog(Shell parent, Template template, boolean edit, boolean isNameModifiable, ContextTypeRegistry registry) {
            super(parent, template, edit, isNameModifiable, registry);
        }

        protected SourceViewer createViewer(Composite parent) {
            StructuredTextViewerConfiguration sourceViewerConfiguration = new StructuredTextViewerConfiguration(){
                StructuredTextViewerConfiguration baseConfiguration = new StructuredTextViewerConfigurationXML();

                public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
                    return this.baseConfiguration.getConfiguredContentTypes(sourceViewer);
                }

                public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
                    return this.baseConfiguration.getLineStyleProviders(sourceViewer, partitionType);
                }

                public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                    ContentAssistant assistant = new ContentAssistant();
                    assistant.enableAutoActivation(true);
                    assistant.enableAutoInsert(true);
                    assistant.setContentAssistProcessor(XMLEditTemplateDialog.this.getTemplateProcessor(), "__dftl_partition_content_type");
                    return assistant;
                }
            };
            return XMLTemplatePreferencePage.this.doCreateViewer(parent, (SourceViewerConfiguration)sourceViewerConfiguration);
        }
    }
}

