/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.wizard.template;

import com.google.common.annotations.Beta;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.ui.util.FileOpener;
import org.eclipse.xtext.ui.wizard.IExtendedProjectInfo;
import org.eclipse.xtext.ui.wizard.IProjectCreator;
import org.eclipse.xtext.ui.wizard.IProjectInfo;
import org.eclipse.xtext.ui.wizard.template.AbstractProjectTemplate;
import org.eclipse.xtext.ui.wizard.template.IProjectGenerator;
import org.eclipse.xtext.ui.wizard.template.Messages;
import org.eclipse.xtext.ui.wizard.template.NewProjectWizardTemplateSelectionPage;
import org.eclipse.xtext.ui.wizard.template.TemplateLabelProvider;
import org.eclipse.xtext.ui.wizard.template.TemplateParameterPage;
import org.eclipse.xtext.ui.wizard.template.TemplateProjectInfo;
import org.eclipse.xtext.ui.wizard.template.TemplateVariable;

@Beta
public class TemplateNewProjectWizard
extends Wizard
implements INewWizard {
    private static final Logger logger = Logger.getLogger(TemplateNewProjectWizard.class);
    protected IStructuredSelection selection;
    protected WizardNewProjectCreationPage mainPage;
    protected NewProjectWizardTemplateSelectionPage templatePage;
    protected TemplateParameterPage templateParameterPage;
    @Inject
    private TemplateLabelProvider labelProvider;
    @Inject
    private FileOpener fileOpener;
    @Inject
    private IProjectCreator projectCreator;
    @Inject
    private IGrammarAccess grammarAccess;
    private IWorkbench workbench;

    public TemplateNewProjectWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.TemplateNewProjectWizard_title);
    }

    public void addPages() {
        this.mainPage = this.createMainPage("basicNewProjectPage");
        this.mainPage.setTitle(String.valueOf(this.shortName(this.getGrammarName())) + Messages.TemplateNewProjectWizard_title_suffix);
        this.mainPage.setDescription(String.valueOf(Messages.TemplateNewProjectWizard_create_new_prefix) + this.shortName(this.getGrammarName()) + Messages.TemplateNewProjectWizard_create_new_suffix);
        this.addPage((IWizardPage)this.mainPage);
        this.templatePage = this.createTemplatePage("templateNewProjectPage");
        this.templatePage.setTitle(String.valueOf(this.shortName(this.getGrammarName())) + Messages.TemplateNewProjectWizard_title_suffix);
        this.templatePage.setDescription(String.valueOf(Messages.TemplateNewProjectWizard_create_new_prefix) + this.shortName(this.getGrammarName()) + Messages.TemplateNewProjectWizard_create_new_suffix);
        this.addPage((IWizardPage)this.templatePage);
    }

    protected WizardNewProjectCreationPage createMainPage(String pageName) {
        return new WizardNewProjectCreationPage(pageName);
    }

    protected NewProjectWizardTemplateSelectionPage createTemplatePage(String pageName) {
        return new NewProjectWizardTemplateSelectionPage(pageName, this.getGrammarName(), this.labelProvider);
    }

    protected String getGrammarName() {
        return this.grammarAccess.getGrammar().getName();
    }

    private String shortName(String fullName) {
        return fullName.contains(".") ? fullName.substring(fullName.lastIndexOf(46) + 1) : fullName;
    }

    protected IExtendedProjectInfo getProjectInfo() {
        IExtendedProjectInfo projectInfo = this.createProjectInfo();
        projectInfo.setProjectName(this.mainPage.getProjectName());
        if (!this.mainPage.useDefaults()) {
            projectInfo.setLocationPath(this.mainPage.getLocationPath());
        }
        return projectInfo;
    }

    protected IExtendedProjectInfo createProjectInfo() {
        return new TemplateProjectInfo(this.templatePage == null ? null : this.templatePage.getSelectedTemplate());
    }

    public boolean performFinish() {
        final IExtendedProjectInfo projectInfo = this.getProjectInfo();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        TemplateNewProjectWizard.this.doFinish(projectInfo, monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    protected void doFinish(IProjectInfo projectInfo, IProgressMonitor monitor) {
        try {
            TemplateProjectInfo templateProjectInfo = (TemplateProjectInfo)projectInfo;
            AbstractProjectTemplate projectTemplate = templateProjectInfo.getProjectTemplate();
            projectTemplate.setProjectInfo(templateProjectInfo);
            projectTemplate.generateProjects((IProjectGenerator)((Object)this.projectCreator));
            this.projectCreator.setProjectInfo(projectInfo);
            this.projectCreator.run(monitor);
            this.fileOpener.selectAndReveal(this.projectCreator.getResult());
            this.fileOpener.openFileToEdit(this.getShell(), this.projectCreator.getResult());
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof NewProjectWizardTemplateSelectionPage) {
            AbstractProjectTemplate selectedTemplate = this.templatePage.getSelectedTemplate();
            if (selectedTemplate == null) {
                return null;
            }
            List<TemplateVariable> variables = selectedTemplate.getVariables();
            if (variables.isEmpty()) {
                return null;
            }
            selectedTemplate.setProjectInfo(this.getProjectInfo());
            TemplateParameterPage parameterPage = new TemplateParameterPage(selectedTemplate);
            parameterPage.setWizard((IWizard)this);
            this.templateParameterPage = parameterPage;
            parameterPage.setTitle(String.valueOf(this.getGrammarName()) + Messages.TemplateNewProjectWizard_title_suffix);
            parameterPage.setDescription(String.valueOf(Messages.TemplateNewProjectWizard_create_new_prefix) + this.getGrammarName() + Messages.TemplateNewProjectWizard_create_new_suffix);
            return parameterPage;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page instanceof TemplateParameterPage) {
            this.templateParameterPage = null;
            return this.templatePage;
        }
        return super.getPreviousPage(page);
    }

    public boolean canFinish() {
        return super.canFinish() && (this.templateParameterPage == null || this.templateParameterPage.isPageComplete());
    }
}

