/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ecoreInference;

import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderImpl;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.resource.ClasspathUriUtil;
import org.eclipse.xtext.xtext.ecoreInference.XtendXtext2EcorePostProcessor;

public class ProjectAwareXtendXtext2EcorePostProcessor
extends XtendXtext2EcorePostProcessor
implements IResourceChangeListener {
    private static final Logger logger = Logger.getLogger(ProjectAwareXtendXtext2EcorePostProcessor.class);
    private ResourceLoader resourceLoader;

    protected void fireXtendFileLoaded() {
        super.fireXtendFileLoaded();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected synchronized ResourceLoader getResourceLoader(GeneratedMetamodel metamodel) {
        if (this.resourceLoader != null) {
            return this.resourceLoader;
        }
        URI uri = metamodel.eResource().getURI();
        if (ClasspathUriUtil.isClasspathUri((URI)uri)) {
            ResourceSet resourceSet = metamodel.eResource().getResourceSet();
            uri = resourceSet.getURIConverter().normalize(uri);
        }
        IFile grammarFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        IJavaProject javaProject = JavaCore.create((IProject)grammarFile.getProject());
        try {
            if (javaProject.exists()) {
                ClassLoader classLoader = this.createClassLoader(javaProject);
                this.resourceLoader = new ResourceLoaderImpl(classLoader);
                return this.resourceLoader;
            }
        }
        catch (CoreException e) {
            logger.error((Object)("Error creating execution context for java project '" + grammarFile.getProject().getName() + "'"), (Throwable)e);
        }
        return super.getResourceLoader(metamodel);
    }

    protected ClassLoader createClassLoader(IJavaProject javaProject) throws CoreException {
        ArrayList urls = Lists.newArrayListWithExpectedSize((int)javaProject.getResolvedClasspath(true).length);
        try {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            urls.addAll(this.getOutputFolders(javaProject));
            IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                IPath path = null;
                URL url = null;
                switch (entry.getEntryKind()) {
                    case 3: {
                        break;
                    }
                    case 2: {
                        IResource project = workspaceRoot.findMember(entry.getPath());
                        urls.addAll(this.getOutputFolders(JavaCore.create((IProject)project.getProject())));
                        break;
                    }
                    default: {
                        path = entry.getPath();
                        url = path.toFile().toURI().toURL();
                    }
                }
                if (url != null) {
                    urls.add(url);
                }
                ++n2;
            }
        }
        catch (MalformedURLException e) {
            logger.error((Object)("Error creating class loader for java project '" + javaProject.getProject().getName() + "'"), (Throwable)e);
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
    }

    private List<URL> getOutputFolders(IJavaProject javaProject) throws CoreException, MalformedURLException {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)1);
        IPath path = javaProject.getOutputLocation().addTrailingSeparator();
        URL url = new URL(URI.createPlatformResourceURI((String)path.toString(), (boolean)true).toString());
        result.add(url);
        IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            switch (entry.getEntryKind()) {
                case 3: {
                    path = entry.getOutputLocation();
                    if (path == null) break;
                    url = new URL(URI.createPlatformResourceURI((String)path.addTrailingSeparator().toString(), (boolean)true).toString());
                    result.add(url);
                    break;
                }
            }
            ++n2;
        }
        return result;
    }

    public synchronized void resourceChanged(IResourceChangeEvent event) {
        super.clearCachedXtendFile();
        this.resourceLoader = null;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }
}

