/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.codeexecution.validation;

import fr.inria.aoste.timesquare.backend.codeexecution.model.CodeExecution.CodeExecClockBehavior;
import fr.inria.aoste.timesquare.backend.codeexecution.model.CodeExecution.CodeExecutionPackage;
import fr.inria.aoste.timesquare.backend.codeexecution.validation.AbstractCodeExecutionSpecJavaValidator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.validation.Check;

public class CodeExecutionSpecJavaValidator
extends AbstractCodeExecutionSpecJavaValidator {
    private static String BOOLEAN_METHOD_REQUIRED = "Method should return a boolean or java.lang.Boolean if clock(s) are intended to be forced";

    @Check
    public void checkBooleanMethodWithForcedClock(CodeExecClockBehavior behavior) {
        if (behavior.getClockToForce().isEmpty()) {
            return;
        }
        if (behavior.getMethod() != null) {
            JvmTypeReference tRef = behavior.getMethod().getReturnType();
            JvmType returnType = tRef.getType();
            if (returnType instanceof JvmPrimitiveType) {
                if (returnType.getSimpleName().compareTo("boolean") != 0) {
                    this.warning(BOOLEAN_METHOD_REQUIRED, (EObject)behavior, (EStructuralFeature)CodeExecutionPackage.Literals.CODE_EXECUTION_MODEL_BEHAVIOR__METHOD, 0);
                }
            } else if (returnType.getIdentifier().compareTo("java.lang.Boolean") != 0) {
                this.warning(BOOLEAN_METHOD_REQUIRED, (EObject)behavior, (EStructuralFeature)CodeExecutionPackage.Literals.CODE_EXECUTION_MODEL_BEHAVIOR__METHOD, 0);
            }
        }
    }
}

