/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.controller;

import fr.inria.aoste.timesquare.backend.manager.controller.dealers.AssertBehaviorOptionsDealer;
import fr.inria.aoste.timesquare.backend.manager.controller.dealers.ClockBehaviorOptionsDealer;
import fr.inria.aoste.timesquare.backend.manager.controller.dealers.PluginOptionsDealer;
import fr.inria.aoste.timesquare.backend.manager.controller.dealers.RelationBehaviorOptionsDealer;
import fr.inria.aoste.timesquare.backend.manager.datastructure.DataStructureManager;
import fr.inria.aoste.timesquare.backend.manager.datastructure.Entity;
import fr.inria.aoste.timesquare.backend.manager.datastructure.assertion.AssertBehaviorEntity;
import fr.inria.aoste.timesquare.backend.manager.datastructure.clock.ClockBehaviorEntity;
import fr.inria.aoste.timesquare.backend.manager.datastructure.relation.RelationBehaviorEntity;
import fr.inria.aoste.timesquare.backend.manager.launcher.extensionpoint.OutputOption;
import fr.inria.aoste.timesquare.backend.manager.serialization.BehaviorOptionsSerializer;
import fr.inria.aoste.timesquare.backend.manager.serialization.BehaviorPersistentEntity;
import fr.inria.aoste.timesquare.backend.manager.serialization.XMLStringMaker;
import fr.inria.aoste.timesquare.backend.manager.serialization.XMLStringParser;
import fr.inria.aoste.timesquare.backend.manager.serialization.plugin.PluginOptionsSerializer;
import fr.inria.aoste.timesquare.backend.manager.serialization.relation.RelationBehaviorOptionsSerializer;
import fr.inria.aoste.timesquare.backend.manager.serialization.relation.RelationBehaviorPersistentEntity;
import fr.inria.aoste.timesquare.backend.manager.view.BehaviorManagerDialog;
import fr.inria.aoste.timesquare.backend.manager.view.View;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorConfigurator;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManager;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManagerGUI;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorOutputControler;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.ConfigurationHelper;
import fr.inria.aoste.timesquare.backend.manager.visible.DeleteHelper;
import fr.inria.aoste.timesquare.backend.manager.visible.IBehaviorManagerDialog;
import fr.inria.aoste.timesquare.backend.manager.visible.RelationEntity;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.OccurrenceRelation;
import fr.inria.aoste.timesquare.launcher.core.console.ConsoleSimulation;
import fr.inria.aoste.timesquare.launcher.core.inter.CCSLInfo;
import fr.inria.aoste.timesquare.launcher.core.inter.ISolverForBackend;
import fr.inria.aoste.timesquare.launcher.debug.model.output.OutputSetupOption;
import fr.inria.aoste.timesquare.launcher.debug.model.output.ReportMessage;
import fr.inria.aoste.timesquare.launcher.debug.model.proxy.InitOutputData;
import fr.inria.aoste.trace.AssertionState;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.LogicalStep;
import fr.inria.aoste.trace.PhysicalBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Display;

public final class Controller {
    private View _view = null;
    private DataStructureManager _dsm = new DataStructureManager();
    private List<ClockEntity> _clocks = null;
    private List<ClockEntity> _assert = null;
    private List<RelationEntity> _relationEntities = null;
    private IPath _modelPath = null;
    private OutputSetupOption _outputSetupOption = null;
    private BehaviorManager bm = null;
    private BehaviorManagerGUI bmgui = null;
    private OutputOption _outputOption;
    private boolean deleteInProgress = false;
    InitOutputData _data = null;
    BehaviorConfigurator<?> bc = null;

    public Controller(BehaviorOutputControler behaviorOutputControler, OutputOption outputOption) {
        this._outputOption = outputOption;
        this._clocks = Collections.emptyList();
        this._assert = Collections.emptyList();
        this._relationEntities = Collections.emptyList();
        this._modelPath = null;
        this._outputSetupOption = null;
        this.bm = behaviorOutputControler.createManager();
        this.bm.setController(this);
        this.bmgui = behaviorOutputControler.createManagerGUI();
    }

    public OutputOption getOutputOption() {
        return this._outputOption;
    }

    public void activate() {
        this._outputOption.setActive(true);
    }

    public boolean isActivable(ReportMessage rm, CCSLInfo ccslhelper) {
        return this.bm.isActivable(rm, ccslhelper);
    }

    public String validate() {
        return this.bm.validate();
    }

    public BehaviorManager getBehaviorManager() {
        return this.bm;
    }

    public BehaviorManagerGUI getBehaviorManagerGUI(String pluginName) {
        return this.bmgui;
    }

    public DataStructureManager getDsm() {
        return this._dsm;
    }

    public void setOutputOption(OutputSetupOption outputSetupOption) {
        this._outputSetupOption = outputSetupOption;
    }

    public void setModelPathAndClocks(IPath modelPath, List<ClockEntity> clocks, List<ClockEntity> assert_, List<RelationEntity> relationEntities) {
        if (modelPath == null || clocks == null) {
            this.clearAndInit();
            return;
        }
        if (!modelPath.equals((Object)this._modelPath)) {
            this.clearAndInit();
            this._modelPath = modelPath;
            this._clocks = clocks;
            this._assert = assert_;
            this._relationEntities = relationEntities;
        } else {
            this._clocks = clocks;
            this._assert = assert_;
            this._relationEntities = relationEntities;
            this.checkConsistency();
        }
        if (this._clocks == null) {
            this._clocks = Collections.emptyList();
        }
        if (this._assert == null) {
            this._assert = Collections.emptyList();
        }
        if (this._relationEntities == null) {
            this._relationEntities = Collections.emptyList();
        }
        if (this._view != null) {
            this._view.refresh();
        }
    }

    public void setView(View v) {
        if (v == null) {
            this._view = null;
            return;
        }
        this._view = v;
        this._view.setController(this);
        this._view.setBehaviorManagers(this.bm);
    }

    public void notifyBehaviorManager(BehaviorManager bm) {
        if (bm == null) {
            return;
        }
        BehaviorManagerGUI behaviorManagerGUI = this.getBehaviorManagerGUI(bm.getPluginName());
        if (behaviorManagerGUI != null) {
            behaviorManagerGUI.setBehaviorManager(bm);
            behaviorManagerGUI.setHelper(new ConfigurationHelper(this));
            this._view.displayBehaviorManagerDialog(behaviorManagerGUI);
        } else {
            bm.manageBehavior(new ConfigurationHelper(this));
        }
    }

    public IBehaviorManagerDialog createDialog(final BehaviorManager bm) {
        if (bm == null) {
            return null;
        }
        final BehaviorManagerGUI behaviorManagerGUI = this.getBehaviorManagerGUI(bm.getPluginName());
        if (behaviorManagerGUI != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    behaviorManagerGUI.setBehaviorManager(bm);
                    behaviorManagerGUI.setHelper(new ConfigurationHelper(Controller.this));
                    BehaviorManagerDialog.create(behaviorManagerGUI);
                }
            });
            return behaviorManagerGUI.getDialog();
        }
        return null;
    }

    public void addEntity(ClockBehaviorEntity entity) {
        this._dsm.addEntity(entity);
    }

    public void addEntity(AssertBehaviorEntity entity) {
        this._dsm.addEntity(entity);
    }

    public void addEntity(RelationBehaviorEntity entity) {
        this._dsm.addEntity(entity);
    }

    public List<ClockEntity> getClocks() {
        return this._clocks;
    }

    public List<ClockEntity> getAssert() {
        return this._assert;
    }

    public List<RelationEntity> getRelationEntities() {
        return this._relationEntities;
    }

    public List<EObject> getRelationConstraint() {
        ArrayList<EObject> l = new ArrayList<EObject>();
        for (RelationEntity e : this.getRelationEntities()) {
            EObject eo = e.getRelation().getRelationConstraint();
            if (l.indexOf(eo) != -1) continue;
            l.add(eo);
        }
        return l;
    }

    public List<EObject> getCcslConstraints() {
        ArrayList<EObject> l = new ArrayList<EObject>();
        for (RelationEntity e : this.getRelationEntities()) {
            EObject eo = e.getRelation().getCcslConstraint();
            if (l.indexOf(eo) != -1) continue;
            l.add(eo);
        }
        return l;
    }

    public String saveConfigurations(OutputOption configuration) {
        try {
            PluginOptionsSerializer pos = new PluginOptionsSerializer();
            if (this._dsm.pluginPresent(this.bm.getPluginName()) && this.bm.getPluginOptions() != null) {
                pos.addPluginOptions(this.bm.getPluginName(), this.bm.getPluginOptions());
            }
            BehaviorOptionsSerializer cbos = new BehaviorOptionsSerializer();
            for (ClockBehaviorEntity e : this._dsm.getClockBehaviorEntity()) {
                BehaviorPersistentEntity pe = e.transformEntityIntoPersistentEntity();
                if (pe == null) continue;
                cbos.addPersistentEntity(e.getPluginName(), pe);
            }
            RelationBehaviorOptionsSerializer rbos = new RelationBehaviorOptionsSerializer();
            for (RelationBehaviorEntity e : this._dsm.getRelationBehaviorEntity()) {
                RelationBehaviorPersistentEntity pe = e.transformEntityIntoPersistentEntity();
                if (pe == null) continue;
                rbos.addPersistentEntity(e.getPluginName(), pe);
            }
            BehaviorOptionsSerializer abos = new BehaviorOptionsSerializer();
            for (AssertBehaviorEntity e : this._dsm.getAssertBehaviorEntity()) {
                BehaviorPersistentEntity pe = e.transformEntityIntoPersistentEntity();
                if (pe == null) continue;
                abos.addPersistentEntity(e.getPluginName(), pe);
            }
            XMLStringMaker xmlStringMaker = new XMLStringMaker(this.bm, pos, cbos, rbos, abos);
            return xmlStringMaker.createXMLString(configuration);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    public void restoreConfigurations(OutputOption configuration) {
        String xmlOptions = configuration.getStringOptions();
        try {
            this.clearAndInit();
            PluginOptionsSerializer pos = new PluginOptionsSerializer();
            BehaviorOptionsSerializer cbos = new BehaviorOptionsSerializer();
            RelationBehaviorOptionsSerializer rbos = new RelationBehaviorOptionsSerializer();
            BehaviorOptionsSerializer abos = new BehaviorOptionsSerializer();
            XMLStringParser xmlStringParser = new XMLStringParser(pos, cbos, rbos, abos);
            xmlStringParser.parse(xmlOptions, configuration, this);
            PluginOptionsDealer pluginOptionsDealer = new PluginOptionsDealer(this, pos);
            pluginOptionsDealer.restoreOptions();
            ClockBehaviorOptionsDealer clockBehaviorOptionsDealer = new ClockBehaviorOptionsDealer(this, cbos);
            clockBehaviorOptionsDealer.restoreOptions();
            RelationBehaviorOptionsDealer relationOptionsDealer = new RelationBehaviorOptionsDealer(this, rbos);
            relationOptionsDealer.restoreOptions();
            AssertBehaviorOptionsDealer assertOptionsDealer = new AssertBehaviorOptionsDealer(this, abos);
            assertOptionsDealer.restoreOptions();
            if (this._view != null) {
                this._view.refresh();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private synchronized void deleteEntityManager(Entity e) {
        if (this.deleteInProgress) {
            return;
        }
        try {
            try {
                this.deleteInProgress = true;
                this.bm.deleteEntity(e, new DeleteHelper(this));
            }
            catch (Exception exception) {
                System.err.println(exception);
                this.deleteInProgress = false;
            }
        }
        finally {
            this.deleteInProgress = false;
        }
    }

    public void deleteEntity(AssertBehaviorEntity e) {
        this.deleteEntityManager(e);
        if (e != null) {
            this._dsm.deleteAssertBehaviorEntity(e);
        }
    }

    public void deleteEntity(ClockBehaviorEntity e) {
        this.deleteEntityManager(e);
        if (e != null) {
            this._dsm.deleteClockBehaviorEntity(e);
        }
    }

    public void deleteEntity(RelationBehaviorEntity e) {
        this.deleteEntityManager(e);
        if (e != null) {
            this._dsm.deleteRelationBehaviorEntity(e);
        }
    }

    public void deleteEntitiesByPluginName(String pluginName) {
        this._dsm.deleteEntitiesByPluginName(pluginName);
    }

    public void executeNewBehaviors(ClockEntity clockEntity, EventOccurrence clockState) {
        if (clockEntity == null || clockState == null) {
            return;
        }
        this._dsm.executeNewBehaviors(clockEntity, clockState);
    }

    public void executeNewBehaviors(ClockEntity assertEntity, AssertionState assertState) {
        if (assertEntity == null || assertState == null) {
            return;
        }
        this._dsm.executeNewBehaviors(assertEntity, assertState);
    }

    public void executeBehaviors(ClockEntity clockEntity, EventOccurrence clockState) {
        if (clockEntity == null || clockState == null) {
            return;
        }
        this._dsm.executeBehaviors(clockEntity, clockState);
    }

    public void executeBehaviorsRelation(OccurrenceRelation relation) {
        if (relation == null) {
            return;
        }
        this._dsm.executeBehaviors(relation);
    }

    private void checkConsistency() {
        if (this._clocks == null || this._assert == null) {
            return;
        }
        this._dsm.checkConsistency(this._clocks, this._assert);
    }

    public void initBehaviorManager() {
        this.bm.init(new ConfigurationHelper(this));
    }

    public void end() {
        if (this.pluginPresent(this.bm.getPluginName())) {
            this.bm.end(new ConfigurationHelper(this));
        }
    }

    public void aNewStep(int stepNumber, boolean timed, LogicalStep step) {
        if (this.pluginPresent(this.bm.getPluginName())) {
            this.bm.setCurrentStep(step);
            this.bm.aNewStep(stepNumber);
            this.bm.setCurrentStep(null);
        }
    }

    public void aPostNewStep(int stepNumber, boolean timed, LogicalStep step) {
        if (this.pluginPresent(this.bm.getPluginName())) {
            this.bm.setCurrentStep(step);
            this.bm.aPostNewStep(stepNumber);
            this.bm.setCurrentStep(null);
        }
    }

    public void aStep(int stepNumber, boolean timed, LogicalStep step) {
        if (this.pluginPresent(this.bm.getPluginName())) {
            this.bm.setCurrentStep(step);
            this.bm.repeatStep(stepNumber);
            this.bm.setCurrentStep(null);
        }
    }

    public List<PhysicalBase> getPhysicalBases() {
        ArrayList lst = null;
        if (this._data != null) {
            lst = this._data.getLst();
        }
        if (lst == null) {
            lst = new ArrayList();
        }
        return Collections.unmodifiableList(lst);
    }

    public void beforeExecution(InitOutputData data, ConsoleSimulation cs, ISolverForBackend solver) {
        this._data = data;
        IPath folderin = data.getFolder();
        String namefilein = data.getNamefile();
        if (this.pluginPresent(this.bm.getPluginName())) {
            ConfigurationHelper ch = new ConfigurationHelper(this);
            ch.setCs(cs);
            this.bm.beforeExecution(ch, folderin, namefilein, solver);
        }
    }

    public IPath getModelPath() {
        return this._modelPath;
    }

    public void refresh() {
        if (this._view != null) {
            this._view.refresh();
        }
        if (this._outputSetupOption != null) {
            this._outputSetupOption.notifyChange();
        }
    }

    private boolean pluginPresent(String pluginName) {
        return this._dsm.pluginPresent(pluginName);
    }

    private void clearAndInit() {
        this._dsm.clear();
        this.initBehaviorManager();
    }

    public BehaviorConfigurator<?> getConfigurator() {
        if (this.bc == null) {
            this.bc = this.getBehaviorManager().getConfigurator(new ConfigurationHelper(this));
            this.bc.setController(this);
        }
        return this.bc;
    }
}

