/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.serialization;

import fr.inria.aoste.timesquare.backend.manager.controller.Controller;
import fr.inria.aoste.timesquare.backend.manager.launcher.extensionpoint.OutputOption;
import fr.inria.aoste.timesquare.backend.manager.serialization.BehaviorOptionsSerializer;
import fr.inria.aoste.timesquare.backend.manager.serialization.plugin.PluginOptionsSerializer;
import fr.inria.aoste.timesquare.backend.manager.serialization.relation.RelationBehaviorOptionsSerializer;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManager;

public class XMLStringParser {
    PluginOptionsSerializer _pluginOS = null;
    BehaviorOptionsSerializer _clockBehaviorOS = null;
    BehaviorOptionsSerializer _assertBehaviorOS = null;
    RelationBehaviorOptionsSerializer _relationBehaviorOS = null;

    public XMLStringParser(PluginOptionsSerializer pos, BehaviorOptionsSerializer cbos, RelationBehaviorOptionsSerializer rbos, BehaviorOptionsSerializer abos) {
        this._pluginOS = pos;
        this._clockBehaviorOS = cbos;
        this._relationBehaviorOS = rbos;
        this._assertBehaviorOS = abos;
    }

    public void parse(String xmlOptions, OutputOption option, Controller epm) {
        if (this._pluginOS == null || this._clockBehaviorOS == null || this._relationBehaviorOS == null) {
            return;
        }
        try {
            BehaviorManager behaviorManager = epm.getBehaviorManager();
            String id = behaviorManager.getId();
            String text = null;
            text = option.getFlag(String.valueOf(id) + ".pluginOptions");
            this.deserializePluginOptions(text, behaviorManager);
            text = option.getFlag(String.valueOf(id) + ".clockBehaviorOptions");
            this.deserializeClockBehaviorOptions(text, behaviorManager);
            text = option.getFlag(String.valueOf(id) + ".relationBehaviorOptions");
            this.deserializeRelationBehaviorOptions(text, behaviorManager);
            text = option.getFlag(String.valueOf(id) + ".assertBehaviorOptions");
            this.deserializeAssertBehaviorOptions(text, behaviorManager);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void deserializePluginOptions(String options, BehaviorManager behaviorManager) {
        if (options != null && options.length() != 0 && this._pluginOS != null) {
            this._pluginOS.deserializeOptions(options, behaviorManager);
        }
    }

    private void deserializeClockBehaviorOptions(String options, BehaviorManager behaviorManager) {
        if (options != null && options.length() != 0 && this._clockBehaviorOS != null) {
            this._clockBehaviorOS.deserializeOptions(options, behaviorManager);
        }
    }

    private void deserializeRelationBehaviorOptions(String options, BehaviorManager behaviorManager) {
        if (options != null && options.length() != 0 && this._relationBehaviorOS != null) {
            this._relationBehaviorOS.deserializeOptions(options, behaviorManager);
        }
    }

    private void deserializeAssertBehaviorOptions(String options, BehaviorManager behaviorManager) {
        if (options != null && options.length() != 0 && this._assertBehaviorOS != null) {
            this._assertBehaviorOS.deserializeOptions(options, behaviorManager);
        }
    }
}

