/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.listener;

import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.ListConnections;
import fr.inria.aoste.timesquare.vcd.action.ActionSync;
import fr.inria.aoste.timesquare.vcd.dialogs.SelectClocksDialog;
import fr.inria.aoste.timesquare.vcd.menu.Mode;
import fr.inria.aoste.timesquare.vcd.model.IVar;
import fr.inria.aoste.timesquare.vcd.model.comment.ConstraintCommentCommand;
import fr.inria.aoste.timesquare.vcd.view.EventPanel;
import fr.inria.aoste.timesquare.vcd.view.figure.ExtendFigure;
import java.util.ArrayList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MouseDraggedListener
implements MouseListener,
MouseMoveListener {
    private IVcdDiagram _vcdDiagram;
    private IFigure _fig;
    private boolean _state = false;
    private int _selectedIndex = -1;
    private int _indexWave = -1;
    private int _startY = 0;
    private int _namesInitialPositionY = 0;

    public MouseDraggedListener(ListConnections list, IVcdDiagram vdt) {
        this._vcdDiagram = vdt;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        int dy = this._vcdDiagram.getNames().getVerticalBar().getSelection();
        this._fig = this._vcdDiagram.getNames().getContents().findFigureAt(e.x, e.y + dy);
        if (e.button == 1) {
            if (this._fig instanceof Label) {
                IFigure rect = this._fig.getParent();
                this._state = true;
                this._selectedIndex = this._vcdDiagram.getNames().getContents().getChildren().indexOf(rect);
                this._startY = e.y;
                this._namesInitialPositionY = ((Label)this._fig).getLocation().y;
            }
        } else if (e.button == 3 && this._fig instanceof Label) {
            Menu contextMenu = new Menu((Decorations)this._vcdDiagram.getMyShell(), 8);
            MenuItem ghostItem = new MenuItem(contextMenu, 64);
            ghostItem.setText("Ghost");
            MenuItem hideItem = new MenuItem(contextMenu, 64);
            hideItem.setText("Hide Clock");
            Menu subMenuGhost = new Menu(contextMenu);
            ghostItem.setMenu(subMenuGhost);
            MenuItem showGhostItem = new MenuItem(subMenuGhost, 64);
            showGhostItem.setText("Show Ghost");
            MenuItem hideGhostItem = new MenuItem(subMenuGhost, 64);
            hideGhostItem.setText("Hide Ghost");
            IFigure rect = this._fig.getParent();
            this._selectedIndex = this._vcdDiagram.getNames().getContents().getChildren().indexOf(rect);
            IVar var = this._vcdDiagram.getTraceCollector().getSelectedClocks().get(this._selectedIndex);
            hideItem.addSelectionListener((SelectionListener)new SelectedHide(var, this._vcdDiagram));
            if (var.getValueFactory().haveGhostinclock()) {
                ghostItem.setEnabled(true);
                IFigure fig2 = this._vcdDiagram.getCanvas().getContents().findFigureAt(e.x + 130, e.y + dy);
                this._indexWave = this._vcdDiagram.getCanvas().getContents().getChildren().indexOf(fig2);
                if (this._indexWave == -1) {
                    this._indexWave = this._vcdDiagram.getCanvas().getContents().getChildren().indexOf(fig2.getParent());
                }
                showGhostItem.addSelectionListener((SelectionListener)new SelectedShowGhost(this._indexWave, this._vcdDiagram));
                hideGhostItem.addSelectionListener((SelectionListener)new SelectedHideGhost(this._indexWave, this._vcdDiagram));
            } else {
                ghostItem.setEnabled(false);
            }
            this._vcdDiagram.getMyShell().setMenu(contextMenu);
            contextMenu.setVisible(true);
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this._state) {
            int distance = e.y - this._startY;
            this._fig.getParent().setLocation(new Point(this._fig.getParent().getBounds().x, distance + this._namesInitialPositionY));
        }
    }

    public void mouseUp(MouseEvent es) {
        try {
            if (es.button == 1) {
                if (this._fig == null) {
                    return;
                }
                if (this._selectedIndex == -1) {
                    return;
                }
                int newIndex = -1;
                int verticalmargin = 5;
                this._state = false;
                newIndex = (this._fig.getParent().getBounds().y - verticalmargin) / (this._fig.getParent().getBounds().height + verticalmargin);
                if (newIndex > this._vcdDiagram.getNames().getContents().getChildren().size() - 1) {
                    newIndex = this._vcdDiagram.getNames().getContents().getChildren().size() - 1;
                }
                if (newIndex < 0) {
                    newIndex = 0;
                }
                RectangleFigure rf1 = (RectangleFigure)this._vcdDiagram.getNames().getContents().getChildren().get(this._selectedIndex);
                IVar var = this._vcdDiagram.getTraceCollector().getSelectedClocks().get(this._selectedIndex);
                this._vcdDiagram.getNames().getContents().remove((IFigure)rf1);
                this._vcdDiagram.getTraceCollector().getSelectedClocks().remove(var);
                this._vcdDiagram.getNames().getContents().add((IFigure)rf1, newIndex);
                this._vcdDiagram.getTraceCollector().getSelectedClocks().add(newIndex, var);
                this._vcdDiagram.getNames().getContents().getLayoutManager().layout(this._vcdDiagram.getNames().getContents());
                this.alternateWaves(this._selectedIndex, newIndex);
                this._vcdDiagram.getNames().getContents().getLayoutManager().layout(this._vcdDiagram.getNames().getContents());
                this._fig = null;
                this._selectedIndex = -1;
                if (this._vcdDiagram.getVcdmenu().getSyncAction() != null) {
                    for (ActionSync menuitem : this._vcdDiagram.getVcdmenu().getSyncAction()) {
                        if (!menuitem.isChecked()) continue;
                        ConstraintCommentCommand cc = menuitem.getCc();
                        Color color = menuitem.getColor();
                        this._vcdDiagram.getConstraintsFactory().redrawSyncInterval(cc, color);
                    }
                }
                this._vcdDiagram.getCanvas().redraw();
            }
        }
        catch (Throwable e) {
            System.err.println(e);
        }
    }

    public void alternateWaves(int selectedIndex, int newIndex) {
        EventPanel p1 = (EventPanel)((Object)this._vcdDiagram.getCanvas().getContents().getChildren().get(selectedIndex));
        this._vcdDiagram.getCanvas().getContents().remove((IFigure)p1);
        this._vcdDiagram.getCanvas().getContents().add((IFigure)p1, newIndex);
        this._vcdDiagram.getCanvas().getContents().getLayoutManager().layout(this._vcdDiagram.getCanvas().getContents());
        int n = this._vcdDiagram.getNames().getContents().getChildren().size();
        int i = 0;
        while (i < n) {
            EventPanel p2 = (EventPanel)((Object)this._vcdDiagram.getCanvas().getContents().getChildren().get(i));
            p2.getEventline().setEventlineLocation(p2.getLocation());
            if (p2.isDurationModel().booleanValue()) {
                for (Object o : p2.getChildren()) {
                    IFigure f = (IFigure)o;
                    if (!(f instanceof ExtendFigure)) continue;
                    Point pt = ((ExtendFigure)f).getTr();
                    pt.y = i * 40 + 25;
                    ((ExtendFigure)f).setTr(pt);
                    ((ExtendFigure)f).mycompute();
                }
            }
            ++i;
        }
    }

    public static class SelectedHide
    implements SelectionListener {
        private IVar variable;
        private IVcdDiagram vdt;

        public SelectedHide(IVar var, IVcdDiagram vdt) {
            this.variable = var;
            this.vdt = vdt;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            ArrayList<IVar> hideClock = this.vdt.getTraceCollector().getAllnames();
            ArrayList<IVar> showClock = this.vdt.getTraceCollector().getSelectedClocks();
            hideClock.add(this.variable);
            showClock.remove(this.variable);
            SelectClocksDialog scd = new SelectClocksDialog(this.vdt.getMyShell(), hideClock, showClock, "", "", "");
            scd.apply(this.vdt);
        }
    }

    public static class SelectedHideGhost
    implements SelectionListener {
        private int index;
        private IVcdDiagram vdt;

        public SelectedHideGhost(int index, IVcdDiagram vdt) {
            this.index = index;
            this.vdt = vdt;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            this.vdt.getConstraintsFactory().hideGhost(this.index);
            if (this.isAllHide()) {
                this.vdt.getVcdmenu().setGhostSelected(Mode.hide);
            } else {
                this.vdt.getVcdmenu().setGhostSelected(Mode.partial);
            }
        }

        private boolean isAllHide() {
            for (IVar var : this.vdt.getTraceCollector().getSelectedClocks()) {
                if (!var.getValueFactory().haveGhostinclock() || !var.getValueFactory().getIsGhostVisible()) continue;
                return false;
            }
            return true;
        }
    }

    public static class SelectedShowGhost
    implements SelectionListener {
        private int index;
        private IVcdDiagram vdt;

        public SelectedShowGhost(int index, IVcdDiagram vdt) {
            this.index = index;
            this.vdt = vdt;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            this.vdt.getConstraintsFactory().showGhost(this.index);
            if (this.isAllShow()) {
                this.vdt.getVcdmenu().setGhostSelected(Mode.show);
            } else {
                this.vdt.getVcdmenu().setGhostSelected(Mode.partial);
            }
        }

        private boolean isAllShow() {
            for (IVar var : this.vdt.getTraceCollector().getSelectedClocks()) {
                if (!var.getValueFactory().haveGhostinclock() || var.getValueFactory().getIsGhostVisible()) continue;
                return false;
            }
            return true;
        }
    }
}

