/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.model;

import fr.inria.aoste.timesquare.vcd.model.BinaryVectorValueChange;
import fr.inria.aoste.timesquare.vcd.model.RealVectorValueChange;
import fr.inria.aoste.timesquare.vcd.model.ScalarValueChange;
import fr.inria.aoste.timesquare.vcd.model.Value;

public abstract class ValueChange {
    private String identifierCode;

    protected ValueChange(String ident) {
        this.identifierCode = ident;
    }

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public String toString() {
        return this.identifierCode;
    }

    public int hashCode() {
        return this.identifierCode.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ValueChange)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        return this.identifierCode != null ? this.identifierCode.compareTo(((ValueChange)o).identifierCode) == 0 : ((ValueChange)o).identifierCode == null;
    }

    public static ValueChange fromString(String v) {
        int iSpace = (v = v.trim()).indexOf(32);
        if (iSpace == -1) {
            return new ScalarValueChange(Value.fromChar(v.charAt(0)), v.substring(1));
        }
        String value = v.substring(0, iSpace);
        String ident = v.substring(iSpace + 1);
        return ValueChange.create(value, ident);
    }

    private static ValueChange create(String value, String code) {
        char c = value.charAt(0);
        value = value.substring(1);
        switch (c) {
            case 'B': 
            case 'b': {
                return new BinaryVectorValueChange(value.substring(1), code);
            }
            case 'R': 
            case 'r': {
                return new RealVectorValueChange(value.substring(1), code);
            }
        }
        throw new IllegalArgumentException("<" + value + ";" + code + ">");
    }

    public final String getIdentifierCode() {
        return this.identifierCode;
    }
}

