/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.view;

import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import fr.inria.aoste.timesquare.vcd.view.ConstraintsFactory;
import fr.inria.aoste.timesquare.vcd.view.Eventline;
import fr.inria.aoste.timesquare.vcd.view.VcdFactory;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class EventPanel
extends Panel {
    private VcdColorPreferences _mca;
    private VcdFactory _vcdFactory;
    private Eventline _eventline;
    private String _eventlineName = null;
    private String _aliasName;
    private Boolean _isDurationModel = false;
    private int _eventStartPointX;
    private int _eventStartPointY;
    private int _eventHeight;
    private int _eventUnitLength;
    private Rectangle _clocklineArea;
    private HashMap<Integer, Boolean> _ticks;
    public ArrayList<Integer> _tickInstants;
    private HashMap<Integer, RoundedRectangle> _markers;
    private HashMap<Integer, Point> _tickMarkersPositions = new HashMap();

    public HashMap<Integer, Boolean> getTicks() {
        return this._ticks;
    }

    public HashMap<Integer, RoundedRectangle> getMarkers() {
        return this._markers;
    }

    public String getAliasName() {
        return this._aliasName;
    }

    public String getClockName() {
        return this._eventlineName;
    }

    public Boolean isDurationModel() {
        return this._isDurationModel;
    }

    public void setDurationModel() {
        this._isDurationModel = true;
    }

    public EventPanel(ConstraintsFactory cf, VcdFactory vf, String eventlineName, String aliasName, VcdColorPreferences mca) {
        this._mca = mca;
        this._vcdFactory = vf;
        this._eventlineName = eventlineName;
        this._aliasName = aliasName;
        this._markers = new HashMap();
        this.setOpaque(true);
    }

    public EventPanel(ConstraintsFactory cf, VcdFactory vf, String eventlineXmiName, String eventlineName, String aliasName, VcdColorPreferences mca) {
        this._mca = mca;
        this._vcdFactory = vf;
        this._eventlineName = eventlineName;
        this._aliasName = aliasName;
        this._markers = new HashMap();
        this.setOpaque(true);
    }

    public void initEventPanel(Eventline cl) {
        this._eventline = cl;
        this.add((IFigure)cl);
        this.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent me) {
                if (me.button == 1) {
                    EventPanel.this._eventStartPointX = EventPanel.this._eventline.getStartPointX();
                    EventPanel.this._eventline.getEndPointX();
                    EventPanel.this._eventStartPointY = EventPanel.this._eventline.getStartPointY();
                    EventPanel.this._eventHeight = EventPanel.this._eventline.getHeight();
                    EventPanel.this._eventUnitLength = EventPanel.this._eventline.getUnitStepLength();
                    if (EventPanel.this._eventUnitLength <= 0) {
                        return;
                    }
                    EventPanel.this._ticks = EventPanel.this._eventline.getTicksTime();
                    EventPanel.this._clocklineArea = EventPanel.this._eventline.getBounds();
                    if (EventPanel.this._clocklineArea.contains(new Point(me.x, me.y)) && (me.x - EventPanel.this._eventStartPointX) % EventPanel.this._eventUnitLength <= EventPanel.this._eventUnitLength * 2 / 5) {
                        int tickInstant = (me.x - EventPanel.this._eventStartPointX) / EventPanel.this._eventUnitLength;
                        if (EventPanel.this._ticks.containsKey(tickInstant)) {
                            if (!((Boolean)EventPanel.this._ticks.get(tickInstant)).booleanValue()) {
                                RoundedRectangle rr = new RoundedRectangle();
                                Rectangle rec = null;
                                if (((EventPanel)EventPanel.this)._clocklineArea.height == EventPanel.this._eventHeight + 1) {
                                    rec = new Rectangle(0, 0, (EventPanel.this._eventUnitLength + 1) * 2 / 5, 20);
                                    rr.setBounds(rec);
                                    rr.setBackgroundColor(EventPanel.this._mca.colorTickMarker());
                                    rr.setLocation(new Point(EventPanel.this._eventStartPointX + EventPanel.this._eventUnitLength * tickInstant + 1, EventPanel.this._eventStartPointY - EventPanel.this._eventHeight + 1));
                                } else {
                                    rec = new Rectangle(0, 0, (EventPanel.this._eventUnitLength + 1) * 2 / 5, 10);
                                    rr.setBounds(rec);
                                    rr.setBackgroundColor(EventPanel.this._mca.colorTickMarker());
                                    rr.setLocation(new Point(EventPanel.this._eventStartPointX + EventPanel.this._eventUnitLength * tickInstant + 1, EventPanel.this._eventStartPointY - EventPanel.this._eventHeight + 1));
                                }
                                EventPanel.this.add((IFigure)rr);
                                EventPanel.this._markers.put(tickInstant, rr);
                                EventPanel.this._tickMarkersPositions.put(tickInstant, new Point(5 + 20 * tickInstant + 1, EventPanel.this.getLocation().y + 5 + 1));
                                EventPanel.this._ticks.remove(tickInstant);
                                EventPanel.this._ticks.put(tickInstant, true);
                                EventPanel.this._vcdFactory.getConstraintsFactory().drawOneTickConstraints(tickInstant, EventPanel.this._eventlineName);
                            } else {
                                EventPanel.this.remove((IFigure)EventPanel.this._markers.get(tickInstant));
                                EventPanel.this._tickMarkersPositions.remove(tickInstant);
                                ((RoundedRectangle)EventPanel.this._markers.get(tickInstant)).erase();
                                EventPanel.this._markers.remove(tickInstant);
                                EventPanel.this._ticks.remove(tickInstant);
                                EventPanel.this._ticks.put(tickInstant, false);
                                EventPanel.this._vcdFactory.getConstraintsFactory().drawOneTickConstraints(tickInstant, EventPanel.this._eventlineName);
                            }
                        }
                    }
                }
            }

            public void mouseReleased(MouseEvent me) {
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){
            private Label label = new Label();
            private RoundedRectangle rr = new RoundedRectangle();

            public void mouseMoved(MouseEvent me) {
                this.rr.setVisible(false);
                this.label.setVisible(false);
            }

            public void mouseHover(MouseEvent me) {
                EventPanel.this._clocklineArea = EventPanel.this._eventline.getBounds();
                if (EventPanel.this._clocklineArea.contains(new Point(me.x, me.y))) {
                    int ticknum;
                    EventPanel.this._eventStartPointX = EventPanel.this._eventline.getStartPointX();
                    EventPanel.this._eventline.getEndPointX();
                    EventPanel.this._eventStartPointY = EventPanel.this._eventline.getStartPointY();
                    EventPanel.this._eventHeight = EventPanel.this._eventline.getHeight();
                    EventPanel.this._eventUnitLength = EventPanel.this._eventline.getUnitStepLength();
                    if (EventPanel.this._eventUnitLength <= 0) {
                        return;
                    }
                    EventPanel.this._ticks = EventPanel.this._eventline.getTicksTime();
                    EventPanel.this._tickInstants = EventPanel.this._eventline.getTickInstants();
                    if ((me.x - EventPanel.this._eventStartPointX) % EventPanel.this._eventUnitLength <= EventPanel.this._eventUnitLength * 2 / 5 && EventPanel.this._tickInstants.contains(ticknum = (me.x - EventPanel.this._eventStartPointX) / EventPanel.this._eventUnitLength)) {
                        this.rr.setVisible(true);
                        this.label.setVisible(true);
                        int tickNumShow = EventPanel.this._tickInstants.indexOf(ticknum) + 1;
                        int n = EventPanel.this._aliasName.length() + 5;
                        this.rr.setBounds(new Rectangle(0, 0, 8 * n, 28));
                        this.label.setBounds(new Rectangle(0, 0, 8 * n, 23));
                        this.label.setText(String.valueOf(EventPanel.this._aliasName) + "[" + tickNumShow + "]");
                        Point loc = new Point(me.x, me.y + 18);
                        this.rr.setLocation(loc);
                        this.label.setLocation(loc);
                        EventPanel.this.getParent().getParent().add((IFigure)this.rr);
                    }
                }
            }

            public void mouseExited(MouseEvent me) {
                this.rr.setVisible(false);
                this.label.setVisible(false);
            }

            public void mouseEntered(MouseEvent me) {
                this.label.setOpaque(false);
                this.label.setBounds(new Rectangle(0, 0, 70, 20));
                this.label.setLabelAlignment(2);
                this.label.setForegroundColor(ColorConstants.black);
                this.rr.setBounds(new Rectangle(0, 0, 70, 20));
                this.rr.setOpaque(false);
                this.rr.setBackgroundColor(ColorConstants.lightGray);
                this.rr.setForegroundColor(ColorConstants.gray);
                this.rr.add((IFigure)this.label);
            }

            public void mouseDragged(MouseEvent me) {
            }
        });
    }

    public void markersZoom(double value) {
        this._eventStartPointX = this._eventline.getStartPointX();
        for (int ticknum : this._markers.keySet()) {
            Point p = new Point(this._tickMarkersPositions.get(ticknum));
            p.x = (int)((double)(p.x - this._eventStartPointX - 1) * value + (double)this._eventStartPointX + 1.0);
            Dimension dim = this._markers.get(ticknum).getSize();
            dim.width = (int)(40.0 * value / 5.0);
            this._markers.get(ticknum).setSize(dim);
            this._markers.get(ticknum).setLocation(p);
        }
    }

    public void markersZoomIn() {
        this._eventStartPointX = this._eventline.getStartPointX();
        this._eventline.getEndPointX();
        this._eventStartPointY = this._eventline.getStartPointY();
        this._eventHeight = this._eventline.getHeight();
        this._eventUnitLength = this._eventline.getUnitStepLength();
        for (RoundedRectangle recf : this._markers.values()) {
            Point p = recf.getLocation();
            p.x = (p.x - this._eventStartPointX - 1) * 2 + this._eventStartPointX + 1;
            Dimension dim = recf.getSize();
            dim.width *= 2;
            recf.setSize(dim);
            recf.setLocation(p);
        }
    }

    public void markersZoomOut() {
        this._eventStartPointX = this._eventline.getStartPointX();
        this._eventline.getEndPointX();
        this._eventStartPointY = this._eventline.getStartPointY();
        this._eventHeight = this._eventline.getHeight();
        this._eventUnitLength = this._eventline.getUnitStepLength();
        for (RoundedRectangle recf : this._markers.values()) {
            Point p = recf.getLocation();
            p.x = (p.x - this._eventStartPointX - 1) / 2 + this._eventStartPointX + 1;
            recf.setLocation(p);
            Dimension dim = recf.getSize();
            dim.width /= 2;
            recf.setSize(dim);
        }
    }

    public void setEventline(Eventline cl) {
        this._eventline = cl;
    }

    public Eventline getEventline() {
        return this._eventline;
    }
}

