/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajdt.internal.compiler.CompilationResultDestinationManager;
import org.aspectj.ajdt.internal.compiler.InterimCompilationResult;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjBuildManager;
import org.aspectj.ajdt.internal.core.builder.CompactTypeStructureRepresentation;
import org.aspectj.ajdt.internal.core.builder.CompilerConfigurationChangeFlags;
import org.aspectj.ajdt.internal.core.builder.IStateListener;
import org.aspectj.ajdt.internal.core.builder.IncrementalStateManager;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.asm.AsmManager;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.aspectj.org.eclipse.jdt.internal.core.builder.StringSet;
import org.aspectj.util.FileUtil;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.CompressingDataOutputStream;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.TypeDelegateResolver;
import org.aspectj.weaver.bcel.UnwovenClassFile;

public class AjState
implements CompilerConfigurationChangeFlags,
TypeDelegateResolver {
    public static boolean CHECK_STATE_FIRST = true;
    public static IStateListener stateListener = null;
    public static boolean FORCE_INCREMENTAL_DURING_TESTING = false;
    static int PATHID_CLASSPATH = 0;
    static int PATHID_ASPECTPATH = 1;
    static int PATHID_INPATH = 2;
    private static int CLASS_FILE_NO_CHANGES = 0;
    private static int CLASS_FILE_CHANGED_THAT_NEEDS_INCREMENTAL_BUILD = 1;
    private static int CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD = 2;
    private static final char[][] EMPTY_CHAR_ARRAY = new char[0][];
    private final Set<File> affectedFiles = new HashSet<File>();
    private StringSet qualifiedStrings = new StringSet(3);
    private StringSet simpleStrings = new StringSet(3);
    private Set<File> addedFiles;
    private Set<File> deletedFiles;
    private Set<AjBuildConfig.BinarySourceFile> addedBinaryFiles;
    private Set<AjBuildConfig.BinarySourceFile> deletedBinaryFiles;
    public final Set<String> deltaAddedClasses = new HashSet<String>();
    private final AjBuildManager buildManager;
    private INameEnvironment nameEnvironment;
    private FileSystem fileSystem;
    private boolean couldBeSubsequentIncrementalBuild = false;
    private boolean batchBuildRequiredThisTime = false;
    private AjBuildConfig buildConfig;
    private long lastSuccessfulFullBuildTime = -1L;
    private final Hashtable<String, Long> structuralChangesSinceLastFullBuild = new Hashtable();
    private long lastSuccessfulBuildTime = -1L;
    private long currentBuildTime = -1L;
    private AsmManager structureModel;
    private final Map<File, List<ClassFile>> fullyQualifiedTypeNamesResultingFromCompilationUnit = new HashMap<File, List<ClassFile>>();
    private final Set<File> sourceFilesDefiningAspects = new HashSet<File>();
    private final Map<File, ReferenceCollection> references = new HashMap<File, ReferenceCollection>();
    private Map<String, List<UnwovenClassFile>> binarySourceFiles = new HashMap<String, List<UnwovenClassFile>>();
    private final Map<String, List<ClassFile>> inputClassFilesBySource = new HashMap<String, List<ClassFile>>();
    private final List<String> aspectClassFiles = new ArrayList<String>();
    private final Map<String, CompactTypeStructureRepresentation> resolvedTypeStructuresFromLastBuild = new HashMap<String, CompactTypeStructureRepresentation>();
    private final Map<String, File> classesFromName = new HashMap<String, File>();
    private Map<String, char[]> aspectsFromFileNames;
    private Set<File> compiledSourceFiles = new HashSet<File>();
    private final Map<String, File> resources = new HashMap<String, File>();
    SoftHashMap fileToClassNameMap = new SoftHashMap();
    private BcelWeaver weaver;
    private BcelWorld world;

    public AjState(AjBuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public void setCouldBeSubsequentIncrementalBuild(boolean yesThereCould) {
        this.couldBeSubsequentIncrementalBuild = yesThereCould;
    }

    void successfulCompile(AjBuildConfig config, boolean wasFullBuild) {
        this.buildConfig = config;
        this.lastSuccessfulBuildTime = this.currentBuildTime;
        if (stateListener != null) {
            stateListener.buildSuccessful(wasFullBuild);
        }
        if (wasFullBuild) {
            this.lastSuccessfulFullBuildTime = this.currentBuildTime;
        }
    }

    public boolean prepareForNextBuild(AjBuildConfig newBuildConfig) {
        this.currentBuildTime = System.currentTimeMillis();
        if (!this.maybeIncremental()) {
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Preparing for build: not going to be incremental because either not in AJDT or incremental deactivated");
            }
            return false;
        }
        if (this.batchBuildRequiredThisTime) {
            this.batchBuildRequiredThisTime = false;
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Preparing for build: not going to be incremental this time because batch build explicitly forced");
            }
            return false;
        }
        if (this.lastSuccessfulBuildTime == -1L || this.buildConfig == null) {
            this.structuralChangesSinceLastFullBuild.clear();
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Preparing for build: not going to be incremental because no successful previous full build");
            }
            return false;
        }
        if (newBuildConfig.getOutputJar() != null) {
            this.structuralChangesSinceLastFullBuild.clear();
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Preparing for build: not going to be incremental because outjar being used");
            }
            return false;
        }
        this.affectedFiles.clear();
        if (this.pathChange(this.buildConfig, newBuildConfig)) {
            this.removeAllResultsOfLastBuild();
            if (stateListener != null) {
                stateListener.pathChangeDetected();
            }
            this.structuralChangesSinceLastFullBuild.clear();
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Preparing for build: not going to be incremental because path change detected (one of classpath/aspectpath/inpath/injars)");
            }
            return false;
        }
        if (this.simpleStrings.elementSize > 20) {
            this.simpleStrings = new StringSet(3);
        } else {
            this.simpleStrings.clear();
        }
        if (this.qualifiedStrings.elementSize > 20) {
            this.qualifiedStrings = new StringSet(3);
        } else {
            this.qualifiedStrings.clear();
        }
        if ((newBuildConfig.getChanged() & 1) == 0) {
            this.addedFiles = Collections.emptySet();
            this.deletedFiles = Collections.emptySet();
        } else {
            HashSet<File> oldFiles = new HashSet<File>(this.buildConfig.getFiles());
            HashSet<File> newFiles = new HashSet<File>(newBuildConfig.getFiles());
            this.addedFiles = new HashSet<File>(newFiles);
            this.addedFiles.removeAll(oldFiles);
            this.deletedFiles = new HashSet<File>(oldFiles);
            this.deletedFiles.removeAll(newFiles);
        }
        HashSet<AjBuildConfig.BinarySourceFile> oldBinaryFiles = new HashSet<AjBuildConfig.BinarySourceFile>(this.buildConfig.getBinaryFiles());
        HashSet<AjBuildConfig.BinarySourceFile> newBinaryFiles = new HashSet<AjBuildConfig.BinarySourceFile>(newBuildConfig.getBinaryFiles());
        this.addedBinaryFiles = new HashSet<AjBuildConfig.BinarySourceFile>(newBinaryFiles);
        this.addedBinaryFiles.removeAll(oldBinaryFiles);
        this.deletedBinaryFiles = new HashSet<AjBuildConfig.BinarySourceFile>(oldBinaryFiles);
        this.deletedBinaryFiles.removeAll(newBinaryFiles);
        boolean couldStillBeIncremental = this.processDeletedFiles(this.deletedFiles);
        if (!couldStillBeIncremental) {
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Preparing for build: not going to be incremental because an aspect was deleted");
            }
            return false;
        }
        if (this.listenerDefined()) {
            this.getListener().recordDecision("Preparing for build: planning to be an incremental build");
        }
        return true;
    }

    private boolean processDeletedFiles(Set<File> deletedFiles) {
        for (File deletedFile : deletedFiles) {
            if (this.sourceFilesDefiningAspects.contains(deletedFile)) {
                this.removeAllResultsOfLastBuild();
                if (stateListener != null) {
                    stateListener.detectedAspectDeleted(deletedFile);
                }
                return false;
            }
            List<ClassFile> classes = this.fullyQualifiedTypeNamesResultingFromCompilationUnit.get(deletedFile);
            if (classes == null) continue;
            for (ClassFile cf : classes) {
                this.resolvedTypeStructuresFromLastBuild.remove(cf.fullyQualifiedTypeName);
            }
        }
        return true;
    }

    private Collection<File> getModifiedFiles() {
        return this.getModifiedFiles(this.lastSuccessfulBuildTime);
    }

    Collection<File> getModifiedFiles(long lastBuildTime) {
        HashSet<File> ret = new HashSet<File>();
        List<File> modifiedFiles = this.buildConfig.getModifiedFiles();
        if (modifiedFiles == null) {
            for (File file : this.buildConfig.getFiles()) {
                long modTime;
                if (!file.exists() || (modTime = file.lastModified()) + 1000L <= lastBuildTime) continue;
                ret.add(file);
            }
        } else {
            ret.addAll(modifiedFiles);
        }
        ret.addAll(this.affectedFiles);
        return ret;
    }

    private Collection<AjBuildConfig.BinarySourceFile> getModifiedBinaryFiles() {
        return this.getModifiedBinaryFiles(this.lastSuccessfulBuildTime);
    }

    Collection<AjBuildConfig.BinarySourceFile> getModifiedBinaryFiles(long lastBuildTime) {
        ArrayList<AjBuildConfig.BinarySourceFile> ret = new ArrayList<AjBuildConfig.BinarySourceFile>();
        for (AjBuildConfig.BinarySourceFile bsfile : this.buildConfig.getBinaryFiles()) {
            long modTime;
            File file = bsfile.binSrc;
            if (!file.exists() || (modTime = file.lastModified()) + 1000L < lastBuildTime) continue;
            ret.add(bsfile);
        }
        return ret;
    }

    private void recordDecision(String decision) {
        this.getListener().recordDecision(decision);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int classFileChangedInDirSinceLastBuildRequiringFullBuild(File dir, int pathid) {
        File classFile;
        int i;
        CompilationResultDestinationManager crdm;
        if (!dir.isDirectory()) {
            if (this.listenerDefined()) {
                this.recordDecision("ClassFileChangeChecking: not a directory so forcing full build: '" + dir.getPath() + "'");
            }
            return CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD;
        }
        AjState state = IncrementalStateManager.findStateManagingOutputLocation(dir);
        if (this.listenerDefined()) {
            if (state != null) {
                this.recordDecision("ClassFileChangeChecking: found state instance managing output location : " + dir);
            } else {
                this.recordDecision("ClassFileChangeChecking: failed to find a state instance managing output location : " + dir + " (could be getting managed by JDT)");
            }
        }
        if (state != null && !state.hasAnyStructuralChangesSince(this.lastSuccessfulBuildTime)) {
            if (this.listenerDefined()) {
                this.getListener().recordDecision("ClassFileChangeChecking: no reported changes in that state");
            }
            return CLASS_FILE_NO_CHANGES;
        }
        if (state == null && (crdm = this.buildConfig.getCompilationResultDestinationManager()) != null && (i = crdm.discoverChangesSince(dir, this.lastSuccessfulBuildTime)) == 1) {
            if (this.listenerDefined()) {
                this.getListener().recordDecision("ClassFileChangeChecking: queried JDT and '" + dir + "' is apparently unchanged so not performing timestamp check");
            }
            return CLASS_FILE_NO_CHANGES;
        }
        List classFiles = FileUtil.listClassFiles((File)dir);
        Iterator iterator = classFiles.iterator();
        while (true) {
            block32: {
                block33: {
                    block34: {
                        if (!iterator.hasNext()) {
                            return CLASS_FILE_NO_CHANGES;
                        }
                        classFile = (File)iterator.next();
                        if (!CHECK_STATE_FIRST || state == null) break block32;
                        if (!state.isAspect(classFile)) break block33;
                        boolean hasStructuralChanges = state.hasStructuralChangedSince(classFile, this.lastSuccessfulBuildTime);
                        if (!hasStructuralChanges && !this.isTypeWeReferTo(classFile)) break block34;
                        if (hasStructuralChanges) {
                            if (this.listenerDefined()) {
                                this.getListener().recordDecision("ClassFileChangeChecking: aspect found that has structurally changed : " + classFile);
                            }
                            return CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD;
                        }
                        if (pathid == PATHID_CLASSPATH) {
                            if (this.listenerDefined()) {
                                this.getListener().recordDecision("ClassFileChangeChecking: aspect found that this project refers to : " + classFile + " but only referred to via classpath");
                            }
                            break block33;
                        } else {
                            if (this.listenerDefined()) {
                                this.getListener().recordDecision("ClassFileChangeChecking: aspect found that this project refers to : " + classFile + " from either inpath/aspectpath, switching to full build");
                            }
                            return CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD;
                        }
                    }
                    if (pathid == PATHID_CLASSPATH) {
                        if (this.listenerDefined()) {
                            this.getListener().recordDecision("ClassFileChangeChecking: found aspect on classpath but this project doesn't reference it, continuing to try for incremental build : " + classFile);
                        }
                    } else {
                        if (this.listenerDefined()) {
                            this.getListener().recordDecision("ClassFileChangeChecking: found aspect on aspectpath/inpath - can't determine if this project is affected, must full build: " + classFile);
                        }
                        return CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD;
                    }
                }
                if (!state.hasStructuralChangedSince(classFile, this.lastSuccessfulBuildTime)) continue;
                if (this.listenerDefined()) {
                    this.getListener().recordDecision("ClassFileChangeChecking: structural change detected in : " + classFile);
                }
                this.isTypeWeReferTo(classFile);
                continue;
            }
            long modTime = classFile.lastModified();
            if (modTime + 1000L < this.lastSuccessfulBuildTime) continue;
            if (state == null) break;
            if (state.isAspect(classFile)) {
                if (state.hasStructuralChangedSince(classFile, this.lastSuccessfulBuildTime) || this.isTypeWeReferTo(classFile)) {
                    if (this.listenerDefined()) {
                        this.getListener().recordDecision("ClassFileChangeChecking: aspect found that has structurally changed or that this project depends upon : " + classFile);
                    }
                    return CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD;
                }
                if (pathid == PATHID_CLASSPATH) {
                    if (this.listenerDefined()) {
                        this.getListener().recordDecision("ClassFileChangeChecking: found aspect on classpath but this project doesn't reference it, continuing to try for incremental build : " + classFile);
                    }
                } else {
                    if (this.listenerDefined()) {
                        this.getListener().recordDecision("ClassFileChangeChecking: found aspect on aspectpath/inpath - can't determine if this project is affected, must full build: " + classFile);
                    }
                    return CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD;
                }
            }
            if (state.hasStructuralChangedSince(classFile, this.lastSuccessfulBuildTime)) {
                if (this.listenerDefined()) {
                    this.getListener().recordDecision("ClassFileChangeChecking: structural change detected in : " + classFile);
                }
                this.isTypeWeReferTo(classFile);
                continue;
            }
            if (!this.listenerDefined()) continue;
            this.getListener().recordDecision("ClassFileChangeChecking: change detected in " + classFile + " but it is not structural");
        }
        if (this.isTypeWeReferTo(classFile)) {
            return CLASS_FILE_CHANGED_THAT_NEEDS_INCREMENTAL_BUILD;
        }
        return CLASS_FILE_NO_CHANGES;
    }

    private boolean isAspect(File file) {
        return this.aspectClassFiles.contains(file.getAbsolutePath());
    }

    private boolean isTypeWeReferTo(File file) {
        char[] className;
        String fpath = file.getAbsolutePath();
        int finalSeparator = fpath.lastIndexOf(File.separator);
        String baseDir = fpath.substring(0, finalSeparator);
        String theFile = fpath.substring(finalSeparator + 1);
        SoftHashMap classNames = (SoftHashMap)this.fileToClassNameMap.get(baseDir);
        if (classNames == null) {
            classNames = new SoftHashMap();
            this.fileToClassNameMap.put(baseDir, classNames);
        }
        if ((className = (char[])classNames.get(theFile)) == null) {
            ClassFileReader cfr;
            try {
                cfr = ClassFileReader.read(file);
            }
            catch (ClassFormatException e) {
                return true;
            }
            catch (IOException e) {
                return true;
            }
            className = cfr.getName();
            classNames.put(theFile, className);
        }
        Object qualifiedNames = null;
        Object simpleNames = null;
        if (CharOperation.indexOf('/', className) != -1) {
            qualifiedNames = new char[1][][];
            qualifiedNames[0] = CharOperation.splitOn('/', className);
            qualifiedNames = ReferenceCollection.internQualifiedNames(qualifiedNames);
        } else {
            simpleNames = new char[1][];
            simpleNames[0] = className;
            simpleNames = ReferenceCollection.internSimpleNames(simpleNames, true);
        }
        int newlyAffectedFiles = 0;
        for (Map.Entry<File, ReferenceCollection> entry : this.references.entrySet()) {
            ReferenceCollection refs = entry.getValue();
            if (refs == null || !refs.includes((char[][][])qualifiedNames, (char[][])simpleNames)) continue;
            if (this.listenerDefined()) {
                this.getListener().recordDecision(this.toString() + ": type " + new String(className) + " is depended upon by '" + entry.getKey() + "'");
            }
            ++newlyAffectedFiles;
            this.affectedFiles.add(entry.getKey());
        }
        if (newlyAffectedFiles > 0) {
            return true;
        }
        if (this.listenerDefined()) {
            this.getListener().recordDecision(this.toString() + ": type " + new String(className) + " is not depended upon by this state");
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AjState(").append(this.buildConfig == null ? "NULLCONFIG" : this.buildConfig.getConfigFile().toString()).append(")");
        return sb.toString();
    }

    private boolean hasStructuralChangedSince(File file, long lastSuccessfulBuildTime) {
        Long l = this.structuralChangesSinceLastFullBuild.get(file.getAbsolutePath());
        long strucModTime = -1L;
        strucModTime = l != null ? l : this.lastSuccessfulFullBuildTime;
        return strucModTime > lastSuccessfulBuildTime;
    }

    private boolean hasAnyStructuralChangesSince(long lastSuccessfulBuildTime) {
        Set<Map.Entry<String, Long>> entries = this.structuralChangesSinceLastFullBuild.entrySet();
        for (Map.Entry<String, Long> entry : entries) {
            long lvalue;
            Long l = entry.getValue();
            if (l == null || (lvalue = l.longValue()) <= lastSuccessfulBuildTime) continue;
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Seems this has changed " + entry.getKey() + "modtime=" + lvalue + " lsbt=" + this.lastSuccessfulFullBuildTime + "   incoming check value=" + lastSuccessfulBuildTime);
            }
            return true;
        }
        return this.lastSuccessfulFullBuildTime > lastSuccessfulBuildTime;
    }

    private boolean pathChange(AjBuildConfig previousConfig, AjBuildConfig newConfig) {
        int changes = newConfig.getChanged();
        if ((changes & 0x31C) != 0) {
            List<File> newInJars;
            List<File> newInPath;
            List<File> newAspectpath;
            List<File> oldOutputLocs = this.getOutputLocations(previousConfig);
            HashSet<String> alreadyAnalysedPaths = new HashSet<String>();
            List<String> oldClasspath = previousConfig.getClasspath();
            List<String> newClasspath = newConfig.getClasspath();
            if (stateListener != null) {
                stateListener.aboutToCompareClasspaths(oldClasspath, newClasspath);
            }
            if (this.classpathChangedAndNeedsFullBuild(oldClasspath, newClasspath, true, oldOutputLocs, alreadyAnalysedPaths)) {
                return true;
            }
            List<File> oldAspectpath = previousConfig.getAspectpath();
            if (this.changedAndNeedsFullBuild(oldAspectpath, newAspectpath = newConfig.getAspectpath(), true, oldOutputLocs, alreadyAnalysedPaths, PATHID_ASPECTPATH)) {
                return true;
            }
            List<File> oldInPath = previousConfig.getInpath();
            if (this.changedAndNeedsFullBuild(oldInPath, newInPath = newConfig.getInpath(), false, oldOutputLocs, alreadyAnalysedPaths, PATHID_INPATH)) {
                return true;
            }
            List<File> oldInJars = previousConfig.getInJars();
            if (this.changedAndNeedsFullBuild(oldInJars, newInJars = newConfig.getInJars(), false, oldOutputLocs, alreadyAnalysedPaths, PATHID_INPATH)) {
                return true;
            }
        } else if (newConfig.getClasspathElementsWithModifiedContents() != null) {
            List<String> modifiedCpElements = newConfig.getClasspathElementsWithModifiedContents();
            Iterator<String> iterator = modifiedCpElements.iterator();
            while (iterator.hasNext()) {
                int classFileChanges;
                File cpElement = new File(iterator.next());
                if (!(cpElement.exists() && !cpElement.isDirectory() ? cpElement.lastModified() > this.lastSuccessfulBuildTime : (classFileChanges = this.classFileChangedInDirSinceLastBuildRequiringFullBuild(cpElement, PATHID_CLASSPATH)) == CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD)) continue;
                return true;
            }
        }
        return false;
    }

    private List<File> getOutputLocations(AjBuildConfig config) {
        ArrayList<File> outputLocs = new ArrayList<File>();
        if (config.getOutputDir() != null) {
            try {
                outputLocs.add(config.getOutputDir().getCanonicalFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (config.getCompilationResultDestinationManager() != null) {
            List dirs = config.getCompilationResultDestinationManager().getAllOutputLocations();
            for (File f : dirs) {
                try {
                    File cf = f.getCanonicalFile();
                    if (outputLocs.contains(cf)) continue;
                    outputLocs.add(cf);
                }
                catch (IOException iOException) {}
            }
        }
        return outputLocs;
    }

    private File getOutputLocationFor(AjBuildConfig config, File aResourceFile) {
        File outputLoc;
        if (config.getCompilationResultDestinationManager() != null && (outputLoc = config.getCompilationResultDestinationManager().getOutputLocationForResource(aResourceFile)) != null) {
            return outputLoc;
        }
        if (config.getOutputDir() != null) {
            return config.getOutputDir();
        }
        return null;
    }

    private boolean changedAndNeedsFullBuild(List oldPath, List newPath, boolean checkClassFiles, List<File> outputLocs, Set<String> alreadyAnalysedPaths, int pathid) {
        if (oldPath.size() != newPath.size()) {
            return true;
        }
        for (int i = 0; i < oldPath.size(); ++i) {
            if (!oldPath.get(i).equals(newPath.get(i))) {
                return true;
            }
            Object o = oldPath.get(i);
            File f = null;
            f = o instanceof String ? new File((String)o) : (File)o;
            if (f.exists() && !f.isDirectory() && f.lastModified() >= this.lastSuccessfulBuildTime) {
                return true;
            }
            if (!checkClassFiles || !f.exists() || !f.isDirectory()) continue;
            boolean foundMatch = false;
            Iterator<File> iterator = outputLocs.iterator();
            while (!foundMatch && iterator.hasNext()) {
                File dir = iterator.next();
                if (!f.equals(dir)) continue;
                foundMatch = true;
            }
            if (foundMatch || alreadyAnalysedPaths.contains(f.getAbsolutePath())) continue;
            alreadyAnalysedPaths.add(f.getAbsolutePath());
            int classFileChanges = this.classFileChangedInDirSinceLastBuildRequiringFullBuild(f, pathid);
            if (classFileChanges != CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD) continue;
            return true;
        }
        return false;
    }

    private boolean classpathChangedAndNeedsFullBuild(List<String> oldPath, List<String> newPath, boolean checkClassFiles, List<File> outputLocs, Set<String> alreadyAnalysedPaths) {
        if (oldPath.size() != newPath.size()) {
            return true;
        }
        for (int i = 0; i < oldPath.size(); ++i) {
            if (!oldPath.get(i).equals(newPath.get(i))) {
                return true;
            }
            File f = new File(oldPath.get(i));
            if (f.exists() && !f.isDirectory() && f.lastModified() >= this.lastSuccessfulBuildTime) {
                return true;
            }
            if (!checkClassFiles || !f.exists() || !f.isDirectory()) continue;
            boolean foundMatch = false;
            Iterator<File> iterator = outputLocs.iterator();
            while (!foundMatch && iterator.hasNext()) {
                File dir = iterator.next();
                if (!f.equals(dir)) continue;
                foundMatch = true;
            }
            if (foundMatch || alreadyAnalysedPaths.contains(f.getAbsolutePath())) continue;
            alreadyAnalysedPaths.add(f.getAbsolutePath());
            int classFileChanges = this.classFileChangedInDirSinceLastBuildRequiringFullBuild(f, PATHID_CLASSPATH);
            if (classFileChanges != CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD) continue;
            return true;
        }
        return false;
    }

    public Set<File> getFilesToCompile(boolean firstPass) {
        HashSet<File> thisTime = new HashSet<File>();
        if (firstPass) {
            this.compiledSourceFiles = new HashSet<File>();
            Collection<File> modifiedFiles = this.getModifiedFiles();
            thisTime.addAll(modifiedFiles);
            if (this.addedFiles != null) {
                for (File o : this.addedFiles) {
                    if (thisTime.contains(o)) continue;
                    thisTime.add(o);
                }
            }
            this.deleteClassFiles();
            this.addAffectedSourceFiles(thisTime, thisTime);
        } else {
            this.addAffectedSourceFiles(thisTime, this.compiledSourceFiles);
        }
        this.compiledSourceFiles = thisTime;
        return thisTime;
    }

    private boolean maybeIncremental() {
        return FORCE_INCREMENTAL_DURING_TESTING || this.couldBeSubsequentIncrementalBuild;
    }

    public Map<String, List<UnwovenClassFile>> getBinaryFilesToCompile(boolean firstTime) {
        if (this.lastSuccessfulBuildTime == -1L || this.buildConfig == null || !this.maybeIncremental()) {
            return this.binarySourceFiles;
        }
        HashMap<String, List<UnwovenClassFile>> toWeave = new HashMap<String, List<UnwovenClassFile>>();
        if (firstTime) {
            ArrayList<AjBuildConfig.BinarySourceFile> addedOrModified = new ArrayList<AjBuildConfig.BinarySourceFile>();
            addedOrModified.addAll(this.addedBinaryFiles);
            addedOrModified.addAll(this.getModifiedBinaryFiles());
            for (AjBuildConfig.BinarySourceFile bsf : addedOrModified) {
                UnwovenClassFile ucf = this.createUnwovenClassFile(bsf);
                if (ucf == null) continue;
                ArrayList<UnwovenClassFile> ucfs = new ArrayList<UnwovenClassFile>();
                ucfs.add(ucf);
                this.recordTypeChanged(ucf.getClassName());
                this.binarySourceFiles.put(bsf.binSrc.getPath(), ucfs);
                ArrayList<ClassFile> cfs = new ArrayList<ClassFile>(1);
                cfs.add(this.getClassFileFor(ucf));
                this.inputClassFilesBySource.put(bsf.binSrc.getPath(), cfs);
                toWeave.put(bsf.binSrc.getPath(), ucfs);
            }
            this.deleteBinaryClassFiles();
        }
        return toWeave;
    }

    private void removeAllResultsOfLastBuild() {
        for (List<ClassFile> cfs : this.inputClassFilesBySource.values()) {
            for (ClassFile cf : cfs) {
                cf.deleteFromFileSystem(this.buildConfig);
            }
        }
        for (File f : this.classesFromName.values()) {
            new ClassFile("", f).deleteFromFileSystem(this.buildConfig);
        }
        Set<Map.Entry<String, File>> resourceEntries = this.resources.entrySet();
        for (Map.Entry<String, File> resourcePair : resourceEntries) {
            File sourcePath = resourcePair.getValue();
            File outputLoc = this.getOutputLocationFor(this.buildConfig, sourcePath);
            if (outputLoc == null || (outputLoc = new File(outputLoc, resourcePair.getKey())).getPath().equals(sourcePath.getPath()) || !outputLoc.exists()) continue;
            outputLoc.delete();
            if (this.buildConfig.getCompilationResultDestinationManager() == null) continue;
            this.buildConfig.getCompilationResultDestinationManager().reportFileRemove(outputLoc.getPath(), 3);
        }
    }

    private void deleteClassFiles() {
        if (this.deletedFiles == null) {
            return;
        }
        for (File deletedFile : this.deletedFiles) {
            this.addDependentsOf(deletedFile);
            List<ClassFile> cfs = this.fullyQualifiedTypeNamesResultingFromCompilationUnit.get(deletedFile);
            this.fullyQualifiedTypeNamesResultingFromCompilationUnit.remove(deletedFile);
            if (cfs == null) continue;
            for (ClassFile cf : cfs) {
                this.deleteClassFile(cf);
            }
        }
    }

    private void deleteBinaryClassFiles() {
        for (AjBuildConfig.BinarySourceFile deletedFile : this.deletedBinaryFiles) {
            List<ClassFile> cfs = this.inputClassFilesBySource.get(deletedFile.binSrc.getPath());
            Iterator<ClassFile> iterator = cfs.iterator();
            while (iterator.hasNext()) {
                this.deleteClassFile(iterator.next());
            }
            this.inputClassFilesBySource.remove(deletedFile.binSrc.getPath());
        }
    }

    private void deleteClassFile(ClassFile cf) {
        this.classesFromName.remove(cf.fullyQualifiedTypeName);
        this.weaver.deleteClassFile(cf.fullyQualifiedTypeName);
        cf.deleteFromFileSystem(this.buildConfig);
    }

    private UnwovenClassFile createUnwovenClassFile(AjBuildConfig.BinarySourceFile bsf) {
        UnwovenClassFile ucf = null;
        try {
            File outputDir = this.buildConfig.getOutputDir();
            if (this.buildConfig.getCompilationResultDestinationManager() != null) {
                outputDir = this.buildConfig.getCompilationResultDestinationManager().getDefaultOutputLocation();
            }
            ucf = this.weaver.addClassFile(bsf.binSrc, bsf.fromInPathDirectory, outputDir);
        }
        catch (IOException ex) {
            Message msg = new Message("can't read class file " + bsf.binSrc.getPath(), (ISourceLocation)new SourceLocation(bsf.binSrc, 0), false);
            this.buildManager.handler.handleMessage((IMessage)msg);
        }
        return ucf;
    }

    public void noteResult(InterimCompilationResult result) {
        if (!this.maybeIncremental()) {
            return;
        }
        File sourceFile = new File(result.fileName());
        CompilationResult cr = result.result();
        this.references.put(sourceFile, new ReferenceCollection(cr.qualifiedReferences, cr.simpleNameReferences, cr.rootReferences));
        UnwovenClassFile[] unwovenClassFiles = result.unwovenClassFiles();
        for (int i = 0; i < unwovenClassFiles.length; ++i) {
            File lastTimeRound = this.classesFromName.get(unwovenClassFiles[i].getClassName());
            this.recordClassFile(unwovenClassFiles[i], lastTimeRound);
            String name = unwovenClassFiles[i].getClassName();
            if (lastTimeRound == null) {
                this.deltaAddedClasses.add(name);
            }
            this.classesFromName.put(name, new File(unwovenClassFiles[i].getFilename()));
        }
        this.recordWhetherCompilationUnitDefinedAspect(sourceFile, cr);
        this.deleteTypesThatWereInThisCompilationUnitLastTimeRoundButHaveBeenDeletedInThisIncrement(sourceFile, unwovenClassFiles);
        this.recordFQNsResultingFromCompilationUnit(sourceFile, result);
    }

    public void noteNewResult(CompilationResult cr) {
    }

    private void deleteTypesThatWereInThisCompilationUnitLastTimeRoundButHaveBeenDeletedInThisIncrement(File sourceFile, UnwovenClassFile[] unwovenClassFiles) {
        List<ClassFile> classFiles = this.fullyQualifiedTypeNamesResultingFromCompilationUnit.get(sourceFile);
        if (classFiles != null) {
            for (int i = 0; i < unwovenClassFiles.length; ++i) {
                this.removeFromClassFilesIfPresent(unwovenClassFiles[i].getClassName(), classFiles);
            }
            for (ClassFile cf : classFiles) {
                this.recordTypeChanged(cf.fullyQualifiedTypeName);
                this.resolvedTypeStructuresFromLastBuild.remove(cf.fullyQualifiedTypeName);
                this.deleteClassFile(cf);
            }
        }
    }

    private void removeFromClassFilesIfPresent(String className, List<ClassFile> classFiles) {
        ClassFile victim = null;
        for (ClassFile cf : classFiles) {
            if (!cf.fullyQualifiedTypeName.equals(className)) continue;
            victim = cf;
            break;
        }
        if (victim != null) {
            classFiles.remove(victim);
        }
    }

    private void recordFQNsResultingFromCompilationUnit(File sourceFile, InterimCompilationResult icr) {
        ArrayList<ClassFile> classFiles = new ArrayList<ClassFile>();
        UnwovenClassFile[] types = icr.unwovenClassFiles();
        for (int i = 0; i < types.length; ++i) {
            classFiles.add(new ClassFile(types[i].getClassName(), new File(types[i].getFilename())));
        }
        this.fullyQualifiedTypeNamesResultingFromCompilationUnit.put(sourceFile, classFiles);
    }

    private void recordWhetherCompilationUnitDefinedAspect(File sourceFile, CompilationResult cr) {
        Map compiledTypes;
        this.sourceFilesDefiningAspects.remove(sourceFile);
        if (cr != null && (compiledTypes = cr.compiledTypes) != null) {
            for (char[] className : compiledTypes.keySet()) {
                ResolvedType rt;
                String typeName = new String(className).replace('/', '.');
                if (typeName.indexOf("$ajc") != -1 || (rt = this.world.resolve(typeName)).isMissing() || !rt.isAspect()) continue;
                this.sourceFilesDefiningAspects.add(sourceFile);
                break;
            }
        }
    }

    private void recordClassFile(UnwovenClassFile thisTime, File lastTime) {
        if (this.simpleStrings == null) {
            ResolvedType rType = this.world.resolve(thisTime.getClassName());
            if (!rType.isMissing()) {
                try {
                    ClassFileReader reader = new ClassFileReader(thisTime.getBytes(), null);
                    boolean isAspect = false;
                    if (rType instanceof ReferenceType && ((ReferenceType)rType).getDelegate() != null) {
                        isAspect = ((ReferenceType)rType).isAspect();
                    }
                    this.resolvedTypeStructuresFromLastBuild.put(thisTime.getClassName(), new CompactTypeStructureRepresentation(reader, isAspect));
                }
                catch (ClassFormatException cfe) {
                    throw new BCException("Unexpected problem processing class", (Throwable)cfe);
                }
            }
            return;
        }
        CompactTypeStructureRepresentation existingStructure = this.resolvedTypeStructuresFromLastBuild.get(thisTime.getClassName());
        ResolvedType newResolvedType = this.world.resolve(thisTime.getClassName());
        if (!newResolvedType.isMissing()) {
            try {
                ClassFileReader reader = new ClassFileReader(thisTime.getBytes(), null);
                boolean isAspect = false;
                if (newResolvedType instanceof ReferenceType && ((ReferenceType)newResolvedType).getDelegate() != null) {
                    isAspect = ((ReferenceType)newResolvedType).isAspect();
                }
                this.resolvedTypeStructuresFromLastBuild.put(thisTime.getClassName(), new CompactTypeStructureRepresentation(reader, isAspect));
            }
            catch (ClassFormatException cfe) {
                try {
                    String s = System.getProperty("aspectj.debug377096", "false");
                    if (s.equalsIgnoreCase("true")) {
                        String location = System.getProperty("java.io.tmpdir", "/tmp");
                        String name = thisTime.getClassName();
                        File f = File.createTempFile(location + File.separator + name, ".class");
                        StringBuilder debug = new StringBuilder();
                        debug.append("Debug377096: Dumping class called " + name + " to " + f.getName() + " size:" + thisTime.getBytes().length);
                        DataOutputStream dos = new DataOutputStream(new FileOutputStream(f));
                        dos.write(thisTime.getBytes());
                        dos.close();
                        throw new BCException(debug.toString(), (Throwable)cfe);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw new BCException("Unexpected problem processing class", (Throwable)cfe);
            }
        }
        if (lastTime == null) {
            this.recordTypeChanged(thisTime.getClassName());
            return;
        }
        if (newResolvedType.isMissing()) {
            return;
        }
        this.world.ensureAdvancedConfigurationProcessed();
        byte[] newBytes = thisTime.getBytes();
        try {
            ClassFileReader reader = new ClassFileReader(newBytes, lastTime.getAbsolutePath().toCharArray());
            if (!reader.isLocal() && !reader.isAnonymous() && this.hasStructuralChanges(reader, existingStructure)) {
                if (this.listenerDefined()) {
                    this.printStructuralChanges(thisTime.getFilename(), reader, existingStructure);
                }
                this.structuralChangesSinceLastFullBuild.put(thisTime.getFilename(), new Long(this.currentBuildTime));
                this.recordTypeChanged(new String(reader.getName()).replace('/', '.'));
            }
        }
        catch (ClassFormatException e) {
            this.recordTypeChanged(thisTime.getClassName());
        }
    }

    private boolean hasStructuralChanges(ClassFileReader reader, CompactTypeStructureRepresentation existingType) {
        IBinaryMethod[] existingMs;
        IBinaryField[] existingFs;
        if (existingType == null) {
            return true;
        }
        if (!this.modifiersEqual(reader.getModifiers(), existingType.modifiers)) {
            return true;
        }
        if (!CharOperation.equals(reader.getGenericSignature(), existingType.genericSignature)) {
            return true;
        }
        if (!CharOperation.equals(reader.getSuperclassName(), existingType.superclassName)) {
            return true;
        }
        IBinaryAnnotation[] newAnnos = reader.getAnnotations();
        if (newAnnos == null || newAnnos.length == 0) {
            if (existingType.annotations != null && existingType.annotations.length != 0) {
                return true;
            }
        } else {
            IBinaryAnnotation[] existingAnnos = existingType.annotations;
            if (existingAnnos == null || existingAnnos.length != newAnnos.length) {
                return true;
            }
            for (int i = 0; i < newAnnos.length; ++i) {
                if (CharOperation.equals(newAnnos[i].getTypeName(), existingAnnos[i].getTypeName())) continue;
                return true;
            }
        }
        char[][] existingIfs = existingType.interfaces;
        char[][] newIfsAsChars = reader.getInterfaceNames();
        if (newIfsAsChars == null) {
            newIfsAsChars = EMPTY_CHAR_ARRAY;
        }
        if (existingIfs == null) {
            existingIfs = EMPTY_CHAR_ARRAY;
        }
        if (existingIfs.length != newIfsAsChars.length) {
            return true;
        }
        block1: for (int i = 0; i < newIfsAsChars.length; ++i) {
            for (int j = 0; j < existingIfs.length; ++j) {
                if (CharOperation.equals(existingIfs[j], newIfsAsChars[i])) continue block1;
            }
            return true;
        }
        IBinaryField[] newFields = reader.getFields();
        if (newFields == null) {
            newFields = CompactTypeStructureRepresentation.NoField;
        }
        if (newFields.length != (existingFs = existingType.binFields).length) {
            return true;
        }
        block3: for (int i = 0; i < newFields.length; ++i) {
            IBinaryField field = newFields[i];
            char[] fieldName = field.getName();
            for (int j = 0; j < existingFs.length; ++j) {
                if (!CharOperation.equals(existingFs[j].getName(), fieldName)) continue;
                IBinaryField existing = existingFs[j];
                if (!this.modifiersEqual(field.getModifiers(), existing.getModifiers())) {
                    return true;
                }
                if (!CharOperation.equals(existing.getTypeName(), field.getTypeName())) {
                    return true;
                }
                char[] existingGSig = existing.getGenericSignature();
                char[] fieldGSig = field.getGenericSignature();
                if (existingGSig == null && fieldGSig != null || existingGSig != null && fieldGSig == null) {
                    return true;
                }
                if (existingGSig == null || CharOperation.equals(existingGSig, fieldGSig)) continue block3;
                return true;
            }
            return true;
        }
        IBinaryMethod[] newMethods = reader.getMethods();
        if (newMethods == null) {
            newMethods = CompactTypeStructureRepresentation.NoMethod;
        }
        if (newMethods.length != (existingMs = existingType.binMethods).length) {
            return true;
        }
        block5: for (int i = 0; i < newMethods.length; ++i) {
            IBinaryMethod method = newMethods[i];
            char[] methodName = method.getSelector();
            for (int j = 0; j < existingMs.length; ++j) {
                if (!CharOperation.equals(existingMs[j].getSelector(), methodName) || !CharOperation.equals(method.getMethodDescriptor(), existingMs[j].getMethodDescriptor())) continue;
                IBinaryMethod existing = existingMs[j];
                if (!this.modifiersEqual(method.getModifiers(), existing.getModifiers())) {
                    return true;
                }
                if (this.exceptionClausesDiffer(existing, method)) {
                    return true;
                }
                char[] existingGSig = existing.getGenericSignature();
                char[] methodGSig = method.getGenericSignature();
                if (existingGSig == null && methodGSig != null || existingGSig != null && methodGSig == null) {
                    return true;
                }
                if (existingGSig == null || CharOperation.equals(existingGSig, methodGSig)) continue block5;
                return true;
            }
            return true;
        }
        IBinaryNestedType[] binaryNestedTypes = reader.getMemberTypes();
        IBinaryNestedType[] existingBinaryNestedTypes = existingType.getMemberTypes();
        if (binaryNestedTypes == null && existingBinaryNestedTypes != null || binaryNestedTypes != null && existingBinaryNestedTypes == null) {
            return true;
        }
        if (binaryNestedTypes != null) {
            int bnLength = binaryNestedTypes.length;
            if (existingBinaryNestedTypes.length != bnLength) {
                return true;
            }
            for (int m = 0; m < bnLength; ++m) {
                IBinaryNestedType bnt = binaryNestedTypes[m];
                IBinaryNestedType existingBnt = existingBinaryNestedTypes[m];
                if (CharOperation.equals(bnt.getName(), existingBnt.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private void logAnalysis(String filename, String info) {
        if (this.listenerDefined()) {
            this.getListener().recordDecision("StructuralAnalysis[" + filename + "]: " + info);
        }
    }

    private boolean printStructuralChanges(String filename, ClassFileReader reader, CompactTypeStructureRepresentation existingType) {
        IBinaryMethod[] existingMs;
        IBinaryField[] existingFs;
        this.logAnalysis(filename, "appears to have structurally changed, printing changes:");
        if (existingType == null) {
            this.logAnalysis(filename, "have not seen this type before");
            return true;
        }
        if (!this.modifiersEqual(reader.getModifiers(), existingType.modifiers)) {
            this.logAnalysis(filename, "modifiers changed.  old=0x" + Integer.toHexString(existingType.getModifiers()) + " new=0x" + Integer.toHexString(reader.getModifiers()));
            return true;
        }
        if (!CharOperation.equals(reader.getGenericSignature(), existingType.genericSignature)) {
            this.logAnalysis(filename, "generic signature changed. old=" + this.stringify(existingType.genericSignature) + " new=" + this.stringify(reader.getGenericSignature()));
            return true;
        }
        if (!CharOperation.equals(reader.getSuperclassName(), existingType.superclassName)) {
            this.logAnalysis(filename, "superclass name changed. old=" + this.stringify(existingType.superclassName) + " new=" + this.stringify(reader.getSuperclassName()));
            return true;
        }
        IBinaryAnnotation[] newAnnos = reader.getAnnotations();
        if (newAnnos == null || newAnnos.length == 0) {
            if (existingType.annotations != null && existingType.annotations.length != 0) {
                this.logAnalysis(filename, "type used to have annotations and now does not: " + this.stringify(existingType.annotations));
                return true;
            }
        } else {
            IBinaryAnnotation[] existingAnnos = existingType.annotations;
            if (existingAnnos == null || existingAnnos.length != newAnnos.length) {
                this.logAnalysis(filename, "type now has annotations which it did not used to have: " + this.stringify(newAnnos));
                return true;
            }
            for (int i = 0; i < newAnnos.length; ++i) {
                if (CharOperation.equals(newAnnos[i].getTypeName(), existingAnnos[i].getTypeName())) continue;
                this.logAnalysis(filename, "type annotation change at position " + i + " old=" + new String(existingAnnos[i].getTypeName()) + " new=" + new String(newAnnos[i].getTypeName()));
                return true;
            }
        }
        char[][] existingIfs = existingType.interfaces;
        char[][] newIfsAsChars = reader.getInterfaceNames();
        if (newIfsAsChars == null) {
            newIfsAsChars = EMPTY_CHAR_ARRAY;
        }
        if (existingIfs == null) {
            existingIfs = EMPTY_CHAR_ARRAY;
        }
        if (existingIfs.length != newIfsAsChars.length) {
            return true;
        }
        block1: for (int i = 0; i < newIfsAsChars.length; ++i) {
            for (int j = 0; j < existingIfs.length; ++j) {
                if (CharOperation.equals(existingIfs[j], newIfsAsChars[i])) continue block1;
            }
            this.logAnalysis(filename, "set of interfaces changed. old=" + this.stringify(existingIfs) + " new=" + this.stringify(newIfsAsChars));
            return true;
        }
        IBinaryField[] newFields = reader.getFields();
        if (newFields == null) {
            newFields = CompactTypeStructureRepresentation.NoField;
        }
        if (newFields.length != (existingFs = existingType.binFields).length) {
            this.logAnalysis(filename, "number of fields changed. old=" + this.stringify(existingFs) + " new=" + this.stringify(newFields));
            return true;
        }
        block3: for (int i = 0; i < newFields.length; ++i) {
            IBinaryField field = newFields[i];
            char[] fieldName = field.getName();
            for (int j = 0; j < existingFs.length; ++j) {
                if (!CharOperation.equals(existingFs[j].getName(), fieldName)) continue;
                IBinaryField existing = existingFs[j];
                if (!this.modifiersEqual(field.getModifiers(), existing.getModifiers())) {
                    this.logAnalysis(filename, "field modifiers changed '" + existing + "' old=0x" + Integer.toHexString(existing.getModifiers()) + " new=0x" + Integer.toHexString(field.getModifiers()));
                    return true;
                }
                if (!CharOperation.equals(existing.getTypeName(), field.getTypeName())) {
                    this.logAnalysis(filename, "field type changed '" + existing + "' old=" + new String(existing.getTypeName()) + " new=" + new String(field.getTypeName()));
                    return true;
                }
                char[] existingGSig = existing.getGenericSignature();
                char[] fieldGSig = field.getGenericSignature();
                if (existingGSig == null && fieldGSig != null || existingGSig != null && fieldGSig == null) {
                    this.logAnalysis(filename, "field generic sig changed '" + existing + "' old=" + (existingGSig == null ? "null" : new String(existingGSig)) + " new=" + (fieldGSig == null ? "null" : new String(fieldGSig)));
                    return true;
                }
                if (existingGSig == null || CharOperation.equals(existingGSig, fieldGSig)) continue block3;
                this.logAnalysis(filename, "field generic sig changed '" + existing + "' old=" + (existingGSig == null ? "null" : new String(existingGSig)) + " new=" + (fieldGSig == null ? "null" : new String(fieldGSig)));
                return true;
            }
            this.logAnalysis(filename, "field changed. New field detected '" + field + "'");
            return true;
        }
        IBinaryMethod[] newMethods = reader.getMethods();
        if (newMethods == null) {
            newMethods = CompactTypeStructureRepresentation.NoMethod;
        }
        if (newMethods.length != (existingMs = existingType.binMethods).length) {
            this.logAnalysis(filename, "number of methods changed. old=" + this.stringify(existingMs) + " new=" + this.stringify(newMethods));
            return true;
        }
        block5: for (int i = 0; i < newMethods.length; ++i) {
            IBinaryMethod method = newMethods[i];
            char[] methodName = method.getSelector();
            for (int j = 0; j < existingMs.length; ++j) {
                if (!CharOperation.equals(existingMs[j].getSelector(), methodName) || !CharOperation.equals(method.getMethodDescriptor(), existingMs[j].getMethodDescriptor())) continue;
                IBinaryMethod existing = existingMs[j];
                if (!this.modifiersEqual(method.getModifiers(), existing.getModifiers())) {
                    this.logAnalysis(filename, "method modifiers changed '" + existing + "' old=0x" + Integer.toHexString(existing.getModifiers()) + " new=0x" + Integer.toHexString(method.getModifiers()));
                    return true;
                }
                if (this.exceptionClausesDiffer(existing, method)) {
                    this.logAnalysis(filename, "method exception clauses changed '" + existing + "' old=" + existing + " new=" + method);
                    return true;
                }
                char[] existingGSig = existing.getGenericSignature();
                char[] methodGSig = method.getGenericSignature();
                if (existingGSig == null && methodGSig != null || existingGSig != null && methodGSig == null) {
                    this.logAnalysis(filename, "method generic sig changed '" + existing + "' old=" + (existingGSig == null ? "null" : new String(existingGSig)) + " new=" + (methodGSig == null ? "null" : new String(methodGSig)));
                    return true;
                }
                if (existingGSig == null || CharOperation.equals(existingGSig, methodGSig)) continue block5;
                this.logAnalysis(filename, "method generic sig changed '" + existing + "' old=" + (existingGSig == null ? "null" : new String(existingGSig)) + " new=" + (methodGSig == null ? "null" : new String(methodGSig)));
                return true;
            }
            this.logAnalysis(filename, "method changed. New method detected '" + this.stringify(method) + "' (might be a rename)");
            return true;
        }
        IBinaryNestedType[] binaryNestedTypes = reader.getMemberTypes();
        IBinaryNestedType[] existingBinaryNestedTypes = existingType.getMemberTypes();
        if (binaryNestedTypes == null && existingBinaryNestedTypes != null || binaryNestedTypes != null && existingBinaryNestedTypes == null) {
            this.logAnalysis(filename, "nested types changed");
            return true;
        }
        if (binaryNestedTypes != null) {
            int bnLength = binaryNestedTypes.length;
            if (existingBinaryNestedTypes.length != bnLength) {
                this.logAnalysis(filename, "nested types changed. old=" + this.stringify(existingBinaryNestedTypes) + " new=" + this.stringify(binaryNestedTypes));
                return true;
            }
            for (int m = 0; m < bnLength; ++m) {
                IBinaryNestedType bnt = binaryNestedTypes[m];
                IBinaryNestedType existingBnt = existingBinaryNestedTypes[m];
                if (CharOperation.equals(bnt.getName(), existingBnt.getName())) continue;
                this.logAnalysis(filename, "nested type changed name at position " + m + " old=" + this.stringify(existingBinaryNestedTypes) + " new=" + this.stringify(binaryNestedTypes));
                return true;
            }
        }
        return false;
    }

    private String stringify(char[] chars) {
        if (chars == null) {
            return "null";
        }
        return new String(chars);
    }

    private String stringify(IBinaryNestedType[] binaryNestedTypes) {
        StringBuilder buf = new StringBuilder();
        for (IBinaryNestedType binaryNestedType : binaryNestedTypes) {
            buf.append(binaryNestedType).append(" ");
        }
        return buf.toString().trim();
    }

    private String stringify(IBinaryMethod[] methods) {
        StringBuilder buf = new StringBuilder();
        for (IBinaryMethod method : methods) {
            buf.append(this.stringify(method)).append(" ");
        }
        return "[" + buf.toString().trim() + "]";
    }

    private String stringify(IBinaryMethod m) {
        StringBuilder buf = new StringBuilder();
        buf.append("0x").append(Integer.toHexString(m.getModifiers())).append(" ");
        buf.append(m.getSelector()).append(m.getMethodDescriptor());
        return buf.toString().trim();
    }

    private String stringify(IBinaryField[] fields) {
        StringBuilder buf = new StringBuilder();
        for (IBinaryField field : fields) {
            buf.append(this.stringify(field)).append(" ");
        }
        return "[" + buf.toString().trim() + "]";
    }

    private Object stringify(IBinaryField f) {
        StringBuilder buf = new StringBuilder();
        buf.append("0x").append(Integer.toHexString(f.getModifiers())).append(" ");
        buf.append(f.getTypeName()).append(f.getName());
        return buf.toString().trim();
    }

    private String stringify(char[][] arrayOfCharArrays) {
        StringBuilder buf = new StringBuilder();
        for (char[] charArray : arrayOfCharArrays) {
            buf.append(charArray).append(" ");
        }
        return buf.toString().trim();
    }

    private String stringify(IBinaryAnnotation[] annotations) {
        StringBuilder buf = new StringBuilder();
        for (IBinaryAnnotation anno : annotations) {
            buf.append(anno).append(" ");
        }
        return buf.toString().trim();
    }

    private boolean exceptionClausesDiffer(IBinaryMethod lastMethod, IBinaryMethod newMethod) {
        char[][] newExceptionTypeNames;
        int nLength;
        char[][] previousExceptionTypeNames = lastMethod.getExceptionTypeNames();
        int pLength = previousExceptionTypeNames.length;
        if (pLength != (nLength = (newExceptionTypeNames = newMethod.getExceptionTypeNames()).length)) {
            return true;
        }
        if (pLength == 0) {
            return false;
        }
        for (int i = 0; i < pLength; ++i) {
            if (CharOperation.equals(previousExceptionTypeNames[i], newExceptionTypeNames[i])) continue;
            return true;
        }
        return false;
    }

    private boolean modifiersEqual(int eclipseModifiers, int resolvedTypeModifiers) {
        return (eclipseModifiers &= 0xFFFF) == (resolvedTypeModifiers &= 0xFFFF);
    }

    private String stringifySet(Set<?> l) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        Iterator<?> iter = l.iterator();
        while (iter.hasNext()) {
            Object el = iter.next();
            sb.append(el);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    protected void addAffectedSourceFiles(Set<File> addTo, Set<File> lastTimeSources) {
        char[][] simpleNames;
        char[][][] qualifiedNames;
        if (this.qualifiedStrings.elementSize == 0 && this.simpleStrings.elementSize == 0) {
            return;
        }
        if (this.listenerDefined()) {
            this.getListener().recordDecision("Examining whether any other files now need compilation based on just compiling: '" + this.stringifySet(lastTimeSources) + "'");
        }
        if ((qualifiedNames = ReferenceCollection.internQualifiedNames(this.qualifiedStrings)).length < this.qualifiedStrings.elementSize) {
            qualifiedNames = null;
        }
        if ((simpleNames = ReferenceCollection.internSimpleNames(this.simpleStrings, true)).length < this.simpleStrings.elementSize) {
            simpleNames = null;
        }
        for (Map.Entry<File, ReferenceCollection> entry : this.references.entrySet()) {
            File file;
            ReferenceCollection refs = entry.getValue();
            if (refs == null || !refs.includes(qualifiedNames, simpleNames) || !(file = entry.getKey()).exists() || lastTimeSources.contains(file)) continue;
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Need to recompile '" + file.getName().toString() + "'");
            }
            addTo.add(file);
        }
        if (addTo.size() > 0) {
            addTo.addAll(lastTimeSources);
        }
        this.qualifiedStrings.clear();
        this.simpleStrings.clear();
    }

    protected void recordTypeChanged(String typename) {
        String typeName;
        int lastDot = typename.lastIndexOf(46);
        if (lastDot != -1) {
            String packageName = typename.substring(0, lastDot).replace('.', '/');
            this.qualifiedStrings.add(packageName);
            typeName = typename.substring(lastDot + 1);
        } else {
            this.qualifiedStrings.add("");
            typeName = typename;
        }
        int memberIndex = typeName.indexOf(36);
        if (memberIndex > 0) {
            typeName = typeName.substring(0, memberIndex);
        }
        this.simpleStrings.add(typeName);
    }

    public boolean recordDependencies(File file, String[] typeNameDependencies) {
        try {
            File sourceFile = new File(new String(file.getCanonicalPath()));
            ReferenceCollection existingCollection = this.references.get(sourceFile);
            if (existingCollection != null) {
                existingCollection.addDependencies(typeNameDependencies);
                return true;
            }
            ReferenceCollection rc = new ReferenceCollection(null, null, null);
            rc.addDependencies(typeNameDependencies);
            this.references.put(sourceFile, rc);
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
    }

    protected void addDependentsOf(File sourceFile) {
        List<ClassFile> cfs = this.fullyQualifiedTypeNamesResultingFromCompilationUnit.get(sourceFile);
        if (cfs != null) {
            for (ClassFile cf : cfs) {
                this.recordTypeChanged(cf.fullyQualifiedTypeName);
            }
        }
    }

    public void setStructureModel(AsmManager structureModel) {
        this.structureModel = structureModel;
    }

    public AsmManager getStructureModel() {
        return this.structureModel;
    }

    public void setWeaver(BcelWeaver bw) {
        this.weaver = bw;
    }

    public BcelWeaver getWeaver() {
        return this.weaver;
    }

    public void setWorld(BcelWorld bw) {
        this.world = bw;
        this.world.addTypeDelegateResolver((TypeDelegateResolver)this);
    }

    public BcelWorld getBcelWorld() {
        return this.world;
    }

    public int getNumberOfStructuralChangesSinceLastFullBuild() {
        return this.structuralChangesSinceLastFullBuild.size();
    }

    public long getLastBuildTime() {
        return this.lastSuccessfulBuildTime;
    }

    public long getLastFullBuildTime() {
        return this.lastSuccessfulFullBuildTime;
    }

    public AjBuildConfig getBuildConfig() {
        return this.buildConfig;
    }

    public void clearBinarySourceFiles() {
        this.binarySourceFiles = new HashMap<String, List<UnwovenClassFile>>();
    }

    public void recordBinarySource(String fromPathName, List<UnwovenClassFile> unwovenClassFiles) {
        this.binarySourceFiles.put(fromPathName, unwovenClassFiles);
        if (this.maybeIncremental()) {
            LinkedList<ClassFile> simpleClassFiles = new LinkedList<ClassFile>();
            for (UnwovenClassFile ucf : unwovenClassFiles) {
                ClassFile cf = this.getClassFileFor(ucf);
                simpleClassFiles.add(cf);
            }
            this.inputClassFilesBySource.put(fromPathName, simpleClassFiles);
        }
    }

    private ClassFile getClassFileFor(UnwovenClassFile ucf) {
        return new ClassFile(ucf.getClassName(), new File(ucf.getFilename()));
    }

    public Map<String, List<UnwovenClassFile>> getBinarySourceMap() {
        return this.binarySourceFiles;
    }

    public Map<String, File> getClassNameToFileMap() {
        return this.classesFromName;
    }

    public boolean hasResource(String resourceName) {
        return this.resources.keySet().contains(resourceName);
    }

    public void recordResource(String resourceName, File resourceSourceLocation) {
        this.resources.put(resourceName, resourceSourceLocation);
    }

    public Set<File> getAddedFiles() {
        return this.addedFiles;
    }

    public Set<File> getDeletedFiles() {
        return this.deletedFiles;
    }

    public void forceBatchBuildNextTimeAround() {
        this.batchBuildRequiredThisTime = true;
    }

    public boolean requiresFullBatchBuild() {
        return this.batchBuildRequiredThisTime;
    }

    public void wipeAllKnowledge() {
        this.buildManager.state = null;
    }

    public Map<String, char[]> getAspectNamesToFileNameMap() {
        return this.aspectsFromFileNames;
    }

    public void initializeAspectNamesToFileNameMap() {
        this.aspectsFromFileNames = new HashMap<String, char[]>();
    }

    public boolean listenerDefined() {
        return stateListener != null;
    }

    public IStateListener getListener() {
        return stateListener;
    }

    public IBinaryType checkPreviousBuild(String name) {
        return this.resolvedTypeStructuresFromLastBuild.get(name);
    }

    public AjBuildManager getAjBuildManager() {
        return this.buildManager;
    }

    public INameEnvironment getNameEnvironment() {
        return this.nameEnvironment;
    }

    public void setNameEnvironment(INameEnvironment nameEnvironment) {
        this.nameEnvironment = nameEnvironment;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public void recordAspectClassFile(String aspectFile) {
        this.aspectClassFiles.add(aspectFile);
    }

    public void write(CompressingDataOutputStream dos) throws IOException {
        this.weaver.write(dos);
    }

    public ReferenceTypeDelegate getDelegate(ReferenceType referenceType) {
        File f = this.classesFromName.get(referenceType.getName());
        if (f == null) {
            return null;
        }
        try {
            ClassParser parser = new ClassParser(f.toString());
            return this.world.buildBcelDelegate(referenceType, parser.parse(), true, false);
        }
        catch (IOException e) {
            Message msg = new Message("Failed to recover " + referenceType, referenceType.getDelegate() != null ? referenceType.getSourceLocation() : null, false);
            this.buildManager.handler.handleMessage((IMessage)msg);
            return null;
        }
    }

    private static class ClassFile {
        public String fullyQualifiedTypeName;
        public File locationOnDisk;

        public ClassFile(String fqn, File location) {
            this.fullyQualifiedTypeName = fqn;
            this.locationOnDisk = location;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("ClassFile(type=").append(this.fullyQualifiedTypeName).append(",location=").append(this.locationOnDisk).append(")");
            return s.toString();
        }

        public void deleteFromFileSystem(AjBuildConfig buildConfig) {
            File[] weaverGenerated;
            String namePrefix = this.locationOnDisk.getName();
            namePrefix = namePrefix.substring(0, namePrefix.lastIndexOf(46));
            final String targetPrefix = namePrefix + "$Ajc";
            File dir = this.locationOnDisk.getParentFile();
            if (dir != null && (weaverGenerated = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(targetPrefix);
                }
            })) != null) {
                for (int i = 0; i < weaverGenerated.length; ++i) {
                    weaverGenerated[i].delete();
                    if (buildConfig == null || buildConfig.getCompilationResultDestinationManager() == null) continue;
                    buildConfig.getCompilationResultDestinationManager().reportFileRemove(weaverGenerated[i].getPath(), 1);
                }
            }
            this.locationOnDisk.delete();
            if (buildConfig != null && buildConfig.getCompilationResultDestinationManager() != null) {
                buildConfig.getCompilationResultDestinationManager().reportFileRemove(this.locationOnDisk.getPath(), 1);
            }
        }
    }

    public static class SoftHashMap
    extends AbstractMap {
        private final Map map;
        private final ReferenceQueue rq = new ReferenceQueue();

        public SoftHashMap(Map map) {
            this.map = map;
        }

        public SoftHashMap() {
            this(new HashMap());
        }

        public SoftHashMap(Map map, boolean b) {
            this(map);
        }

        private void processQueue() {
            SoftReferenceKnownKey sv = null;
            while ((sv = (SoftReferenceKnownKey)this.rq.poll()) != null) {
                this.map.remove(sv.key);
            }
        }

        @Override
        public Object get(Object key) {
            SoftReferenceKnownKey value = (SoftReferenceKnownKey)this.map.get(key);
            if (value == null) {
                return null;
            }
            if (value.get() == null) {
                this.map.remove(value.key);
                return null;
            }
            return value.get();
        }

        @Override
        public Object put(Object k, Object v) {
            this.processQueue();
            return this.map.put(k, new SoftReferenceKnownKey(k, v));
        }

        @Override
        public Set entrySet() {
            return this.map.entrySet();
        }

        @Override
        public void clear() {
            this.processQueue();
            this.map.clear();
        }

        @Override
        public int size() {
            this.processQueue();
            return this.map.size();
        }

        @Override
        public Object remove(Object k) {
            this.processQueue();
            SoftReferenceKnownKey value = (SoftReferenceKnownKey)this.map.remove(k);
            if (value == null) {
                return null;
            }
            if (value.get() != null) {
                return value.get();
            }
            return null;
        }

        class SoftReferenceKnownKey
        extends SoftReference {
            private final Object key;

            SoftReferenceKnownKey(Object k, Object v) {
                super(v, SoftHashMap.this.rq);
                this.key = k;
            }
        }
    }
}

