/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.generic.impl.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.generic.Messages;
import org.eclipse.emf.diffmerge.generic.api.IComparison;
import org.eclipse.emf.diffmerge.generic.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMapping;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.IMergePolicy;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IAttributeValuePresence;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.diffmerge.generic.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.generic.api.diff.IMergeableDifference;
import org.eclipse.emf.diffmerge.generic.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.generic.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;
import org.eclipse.emf.diffmerge.generic.impl.helpers.AbstractExpensiveOperation;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;

public class DiffOperation<E>
extends AbstractExpensiveOperation {
    private final IDiffPolicy<E> _diffPolicy;
    private final IMergePolicy<E> _mergePolicy;
    private final IComparison.Editable<E> _comparison;
    protected final boolean _isReferenceScopeReadOnly;
    protected final boolean _isTargetScopeReadOnly;

    public DiffOperation(IComparison.Editable<E> comparison_p, IDiffPolicy<E> diffPolicy_p, IMergePolicy<E> mergePolicy_p) {
        this._comparison = comparison_p;
        this._diffPolicy = diffPolicy_p;
        this._mergePolicy = mergePolicy_p;
        this._isReferenceScopeReadOnly = this.getComparison().getScope(Role.REFERENCE).isReadOnly();
        this._isTargetScopeReadOnly = this.getComparison().getScope(Role.TARGET).isReadOnly();
    }

    protected boolean coverAttribute(Object attribute_p, ITreeDataScope<E> scopeOfAttribute_p) {
        return this.getDiffPolicy().coverAttribute(attribute_p, scopeOfAttribute_p);
    }

    protected boolean coverReference(Object reference_p, ITreeDataScope<E> scopeOfReference_p) {
        return !scopeOfReference_p.mIsContainerReference(reference_p) && this.getDiffPolicy().coverReference(reference_p, scopeOfReference_p);
    }

    protected void createAttributeOrderDifference(IMatch<E> elementMatch_p, Object attribute_p, Object value1_p, Object value2_p, Role role1_p, Role role2_p) {
        this.createAttributeValueDifference(elementMatch_p, attribute_p, value1_p, role1_p, true);
        this.createAttributeValueDifference(elementMatch_p, attribute_p, value2_p, role2_p, true);
    }

    protected IAttributeValuePresence<E> createAttributeValueDifference(IMatch<E> elementMatch_p, Object attribute_p, Object value_p, Role role_p, boolean isOrder_p) {
        IAttributeValuePresence<E> result = this.getComparison().newAttributeValuePresence(elementMatch_p, attribute_p, value_p, role_p, isOrder_p);
        IValuePresence symmetrical = result.getSymmetrical();
        if (symmetrical != null) {
            this.setSymmetricalValuePresenceDependencies(result, symmetrical);
        }
        if (this.getComparison().isThreeWay()) {
            this.setThreeWayProperties(result);
        }
        return result;
    }

    protected void createDifferences() {
        for (IMatch<E> match : this.getMapping().getContents()) {
            this.checkProgress();
            if (this.getDiffPolicy().coverMatch(match)) {
                this.createTechnicalDifferences(match);
            }
            this.getMonitor().worked(1);
        }
    }

    protected void createReferenceOrderDifference(IMatch<E> elementMatch_p, Object reference_p, E value_p, IMatch<E> valueMatch_p) {
        this.createReferenceValueDifference(elementMatch_p, reference_p, value_p, valueMatch_p, Role.TARGET, true);
        this.createReferenceValueDifference(elementMatch_p, reference_p, value_p, valueMatch_p, Role.REFERENCE, true);
    }

    protected IReferenceValuePresence<E> createReferenceValueDifference(IMatch<E> elementMatch_p, Object reference_p, E value_p, IMatch<E> valueMatch_p, Role role_p, boolean isOrder_p) {
        IReferenceValuePresence<E> result = this.getComparison().newReferenceValuePresence(elementMatch_p, reference_p, value_p, valueMatch_p, role_p, isOrder_p);
        this.setReferencedValueDependencies(result);
        if (this.getComparison().isThreeWay()) {
            this.setThreeWayProperties(result);
        }
        return result;
    }

    protected void createTechnicalDifferences(IMatch<E> match_p) {
        assert (match_p != null);
        if (match_p.isPartial()) {
            this.getOrCreateElementPresence(match_p);
        } else {
            this.detectContentDifferences(match_p, Role.TARGET, Role.REFERENCE, true);
        }
    }

    protected boolean detectAllAttributeDifferences(IMatch<E> match_p, Role role1_p, Role role2_p, boolean create_p) {
        assert (match_p != null && !match_p.isPartial(role1_p, role2_p));
        boolean result = false;
        ITreeDataScope scope1 = this.getComparison().getScope(role1_p);
        ITreeDataScope scope2 = this.getComparison().getScope(role2_p);
        LinkedHashSet attributes1 = new LinkedHashSet(scope1.mGetAttributes(match_p.get(role1_p)));
        for (Object attribute : attributes1) {
            if (!this.coverAttribute(attribute, scope1)) continue;
            boolean bl = result = this.detectAttributeDifferences(match_p, attribute, role1_p, role2_p, role1_p, create_p) || result;
        }
        for (Object attribute : scope2.mGetAttributes(match_p.get(role2_p))) {
            if (attributes1.contains(attribute) || !this.coverAttribute(attribute, scope2)) continue;
            boolean bl = result = this.detectAttributeDifferences(match_p, attribute, role1_p, role2_p, role2_p, create_p) || result;
        }
        return result;
    }

    protected boolean detectAllReferenceDifferences(IMatch<E> match_p, Role role1_p, Role role2_p, boolean create_p) {
        assert (match_p != null && !match_p.isPartial(role1_p, role2_p));
        boolean result = false;
        ITreeDataScope scope1 = this.getComparison().getScope(role1_p);
        ITreeDataScope scope2 = this.getComparison().getScope(role2_p);
        LinkedHashSet references1 = new LinkedHashSet(scope1.mGetReferences(match_p.get(role1_p)));
        for (Object reference : references1) {
            if (!this.coverReference(reference, scope1)) continue;
            boolean bl = result = this.detectReferenceDifferences(match_p, reference, role1_p, role2_p, role1_p, create_p) || result;
        }
        for (Object reference : scope2.mGetReferences(match_p.get(role2_p))) {
            if (references1.contains(reference) || !this.coverReference(reference, scope2)) continue;
            boolean bl = result = this.detectReferenceDifferences(match_p, reference, role1_p, role2_p, role2_p, create_p) || result;
        }
        return result;
    }

    protected boolean detectAttributeDifferences(IMatch<E> match_p, Object attribute_p, Role role1_p, Role role2_p, Role roleOfAttribute_p, boolean create_p) {
        assert (match_p != null && !match_p.isPartial(role1_p, role2_p) && attribute_p != null);
        boolean result = false;
        ITreeDataScope scope1 = this.getComparison().getScope(role1_p);
        ITreeDataScope scope2 = this.getComparison().getScope(role2_p);
        ITreeDataScope scopeOfAttribute = roleOfAttribute_p == role1_p ? scope1 : scope2;
        Object element1 = match_p.get(role1_p);
        Object element2 = match_p.get(role2_p);
        List<?> values1 = scope1.getAttributeValues(element1, attribute_p);
        List<?> values2 = scope2.getAttributeValues(element2, attribute_p);
        ArrayList remainingValues1 = new ArrayList(values1);
        ArrayList remainingValues2 = new ArrayList(values2);
        boolean checkOrder = scopeOfAttribute.mIsManyAttribute(attribute_p) && this.getDiffPolicy().considerOrderedAttribute(attribute_p, scopeOfAttribute);
        int maxIndex = -1;
        for (Object value1 : values1) {
            ObjectAndIndex matchingValue2 = this.findEqualAttributeValue(attribute_p, value1, remainingValues2, scopeOfAttribute);
            if (matchingValue2.getObject() == null) continue;
            if (checkOrder) {
                if (matchingValue2.getIndex() < maxIndex) {
                    if (!create_p) {
                        return true;
                    }
                    this.createAttributeOrderDifference(match_p, attribute_p, value1, matchingValue2.getObject(), role1_p, role2_p);
                    result = true;
                    checkOrder = false;
                } else {
                    maxIndex = matchingValue2.getIndex();
                }
            }
            remainingValues1.remove(value1);
            remainingValues2.remove(matchingValue2.getObject());
        }
        for (Object remainingValue1 : remainingValues1) {
            if (!this.getDiffPolicy().coverValue(remainingValue1, attribute_p, scope1)) continue;
            if (!create_p) {
                return true;
            }
            this.createAttributeValueDifference(match_p, attribute_p, remainingValue1, role1_p, false);
            result = true;
        }
        for (Object remainingValue2 : remainingValues2) {
            if (!this.getDiffPolicy().coverValue(remainingValue2, attribute_p, scope2)) continue;
            if (!create_p) {
                return true;
            }
            this.createAttributeValueDifference(match_p, attribute_p, remainingValue2, role2_p, false);
            result = true;
        }
        return result;
    }

    protected boolean detectContentDifferences(IMatch<E> match_p, Role role1_p, Role role2_p, boolean create_p) {
        assert (match_p != null && !match_p.isPartial(role1_p, role2_p));
        boolean result = this.detectAllAttributeDifferences(match_p, role1_p, role2_p, create_p);
        result = this.detectAllReferenceDifferences(match_p, role1_p, role2_p, create_p) || result;
        result = this.detectOwnershipDifferences(match_p, role1_p, role2_p, create_p) || result;
        return result;
    }

    protected boolean detectOwnershipDifferences(IMatch<E> match_p, Role role1_p, Role role2_p, boolean create_p) {
        assert (match_p != null && !match_p.isPartial(role1_p, role2_p));
        boolean result = false;
        for (Role role : Arrays.asList(role1_p, role2_p)) {
            IMatch<E> parentMatch = this.getComparison().getContainerOf(match_p, role);
            if (parentMatch == null || !parentMatch.isPartial(role1_p, role2_p)) continue;
            if (!create_p) {
                return true;
            }
            Object element = match_p.get(role);
            Object containment = this.getComparison().getScope(role).getContainment(element);
            this.createReferenceValueDifference(parentMatch, containment, element, match_p, role, false);
            result = true;
        }
        return result;
    }

    protected boolean detectReferenceDifferences(IMatch<E> match_p, Object reference_p, Role role1_p, Role role2_p, Role roleOfReference_p, boolean create_p) {
        assert (roleOfReference_p == role1_p || roleOfReference_p == role2_p);
        assert (match_p != null && !match_p.isPartial(role1_p, role2_p) && reference_p != null);
        assert (!this.getComparison().getScope(roleOfReference_p).mIsContainerReference(reference_p));
        boolean result = false;
        IDiffPolicy diffPolicy = this.getDiffPolicy();
        ITreeDataScope scope1 = this.getComparison().getScope(role1_p);
        ITreeDataScope scope2 = this.getComparison().getScope(role2_p);
        ITreeDataScope scopeOfReference = roleOfReference_p == role1_p ? scope1 : scope2;
        Object element1 = match_p.get(role1_p);
        Object element2 = match_p.get(role2_p);
        List values1 = scope1.getReferenceValues(element1, reference_p);
        List values2 = scope2.getReferenceValues(element2, reference_p);
        FArrayList remainingValues2 = new FArrayList(values2, IEqualityTester.BY_REFERENCE);
        boolean checkOrder = scopeOfReference.mIsManyReference(reference_p) && diffPolicy.considerOrderedReference(reference_p, scopeOfReference);
        int maxIndex = -1;
        for (Object value1 : values1) {
            boolean coverValue1;
            IMatch<E> valueMatch1 = this.getMapping().getMatchFor(value1, role1_p);
            boolean outsideScope1 = valueMatch1 == null;
            boolean bl = coverValue1 = !outsideScope1 && diffPolicy.coverMatch(valueMatch1) || outsideScope1 && diffPolicy.coverOutOfScopeValue(value1, reference_p, scope1);
            if (!coverValue1) continue;
            Object matchValue2 = outsideScope1 ? value1 : valueMatch1.get(role2_p);
            boolean isIsolated = matchValue2 == null;
            int index = -1;
            if (!isIsolated) {
                index = this.detectReferenceValueAmong(reference_p, matchValue2, (List<E>)remainingValues2, outsideScope1, scopeOfReference);
                boolean bl2 = isIsolated = index < 0;
                if (checkOrder && !isIsolated) {
                    if (index < maxIndex) {
                        if (!create_p) {
                            return true;
                        }
                        this.createReferenceOrderDifference(match_p, reference_p, value1, valueMatch1);
                        result = true;
                        checkOrder = false;
                    } else {
                        maxIndex = index;
                    }
                }
            }
            if (isIsolated) {
                if (!create_p) {
                    return true;
                }
                this.createReferenceValueDifference(match_p, reference_p, value1, valueMatch1, role1_p, false);
                result = true;
                continue;
            }
            if (index > -1) {
                remainingValues2.remove(index);
                continue;
            }
            remainingValues2.remove(matchValue2);
        }
        for (Object remainingValue2 : remainingValues2) {
            boolean coverReferenceValue;
            IMatch<E> valueMatch2 = this.getMapping().getMatchFor(remainingValue2, role2_p);
            boolean outsideReferenceScope = valueMatch2 == null;
            boolean bl = coverReferenceValue = !outsideReferenceScope && diffPolicy.coverMatch(valueMatch2) || outsideReferenceScope && diffPolicy.coverOutOfScopeValue(remainingValue2, reference_p, scopeOfReference);
            if (!coverReferenceValue) continue;
            if (!create_p) {
                return true;
            }
            this.createReferenceValueDifference(match_p, reference_p, remainingValue2, valueMatch2, role2_p, false);
            result = true;
        }
        return result;
    }

    protected int detectReferenceValueAmong(Object reference_p, E value_p, List<E> values_p, boolean outsideScope_p, ITreeDataScope<E> scope_p) {
        int result = values_p.indexOf(value_p);
        if (result == -1 && outsideScope_p) {
            IDiffPolicy<E> diffPolicy = this.getDiffPolicy();
            int i = -1;
            for (E candidateValue : values_p) {
                ++i;
                if (!diffPolicy.considerEqualOutOfScope(value_p, candidateValue, reference_p, scope_p)) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    protected ObjectAndIndex findEqualAttributeValue(Object attribute_p, Object value_p, Collection<? extends Object> candidates_p, ITreeDataScope<E> scope_p) {
        int i = 0;
        for (Object object : candidates_p) {
            if (this.getDiffPolicy().considerEqual(value_p, object, attribute_p, scope_p)) {
                return new ObjectAndIndex(object, i);
            }
            ++i;
        }
        return new ObjectAndIndex();
    }

    public IComparison.Editable<E> getComparison() {
        return this._comparison;
    }

    protected IDiffPolicy<E> getDiffPolicy() {
        return this._diffPolicy;
    }

    protected IMergePolicy<E> getMergePolicy() {
        return this._mergePolicy;
    }

    protected IMapping<E> getMapping() {
        return this.getComparison().getMapping();
    }

    @Override
    public String getOperationName() {
        return Messages.DiffBuilder_Task_Main;
    }

    protected IElementPresence<E> getOrCreateElementPresence(IMatch<E> match_p) {
        assert (match_p != null && match_p.isPartial());
        IElementPresence<E> result = match_p.getElementPresenceDifference();
        if (result == null && this.getDiffPolicy().coverMatch(match_p)) {
            Role presenceRole = match_p.getUncoveredRole().opposite();
            IMatch<E> ownerMatch = this.getComparison().getContainerOf(match_p, presenceRole);
            result = this.getComparison().newElementPresence(match_p, ownerMatch, presenceRole);
            this.setElementPresenceDependencies(result);
            if (this.getComparison().isThreeWay()) {
                this.setThreeWayProperties(result);
            }
        }
        return result;
    }

    @Override
    protected int getWorkAmount() {
        return 1 + this.getMapping().size();
    }

    protected boolean isReadOnly(Role role_p) {
        boolean result;
        switch (role_p) {
            case REFERENCE: {
                result = this._isReferenceScopeReadOnly;
                break;
            }
            case TARGET: {
                result = this._isTargetScopeReadOnly;
                break;
            }
            default: {
                result = true;
            }
        }
        return result;
    }

    protected void markImplies(IMergeableDifference<E> source_p, IMergeableDifference<E> target_p, Role role_p) {
        if (!this.isReadOnly(role_p)) {
            ((IMergeableDifference.Editable)source_p).markImplies(target_p, role_p);
        }
    }

    protected void markRequires(IMergeableDifference<E> source_p, IMergeableDifference<E> target_p, Role role_p) {
        if (!this.isReadOnly(role_p)) {
            ((IMergeableDifference.Editable)source_p).markRequires(target_p, role_p);
        }
    }

    @Override
    public IStatus run() {
        this.getMonitor().worked(1);
        this.createDifferences();
        return Status.OK_STATUS;
    }

    protected void setCyclicOwnershipDependencies(IReferenceValuePresence<E> presence_p) {
        assert (presence_p.getValueMatch() != null);
        assert (!presence_p.isOrder());
        assert (presence_p.getValueMatch().isAMove());
        assert (presence_p.isOwnership());
        assert (!presence_p.getValueMatch().isPartial());
        Role orderingRole = this.getComparison().getMapping().getOrderingRole();
        Role oppositeRole = orderingRole.opposite();
        if (presence_p.getPresenceRole() == oppositeRole) {
            IMatch<E> valueMatch;
            IComparison.Editable<E> comparison = this.getComparison();
            IMatch<E> oppositeAncestorMatch = valueMatch = presence_p.getValueMatch();
            do {
                if ((oppositeAncestorMatch = comparison.getContainerOf(oppositeAncestorMatch, oppositeRole)) == null || !oppositeAncestorMatch.isAMove()) continue;
                IReferenceValuePresence<E> cycleEnd = null;
                IMatch<E> orderingAncestorMatch = oppositeAncestorMatch;
                do {
                    if ((orderingAncestorMatch = comparison.getContainerOf(orderingAncestorMatch, orderingRole)) != valueMatch) continue;
                    cycleEnd = oppositeAncestorMatch.getOwnershipDifference(orderingRole);
                } while (orderingAncestorMatch != null && cycleEnd == null);
                if (cycleEnd == null) continue;
                this.markRequires(cycleEnd, presence_p, oppositeRole);
                this.markRequires(presence_p, cycleEnd, orderingRole);
            } while (oppositeAncestorMatch != null);
        }
    }

    protected void setElementPresenceDependencies(IElementPresence<E> presence_p) {
        Role presenceRole = presence_p.getPresenceRole();
        if (!presence_p.isRoot()) {
            IElementPresence<E> ownerPresence;
            IMatch<E> ownerMatch = presence_p.getOwnerMatch();
            if (this.getMergePolicy().bindPresenceToOwnership(this._comparison.getScope(presenceRole.opposite())) && ownerMatch != null && ownerMatch.isPartial() && (ownerPresence = this.getOrCreateElementPresence(ownerMatch)) != null) {
                this.markRequires(presence_p, ownerPresence, presenceRole.opposite());
                this.markRequires(ownerPresence, presence_p, presenceRole);
            }
        }
        Collection<E> additionPeers = this.getMergePolicy().getAdditionGroup(presence_p.getElement(), presence_p.getPresenceScope());
        for (E peer : additionPeers) {
            IElementPresence<E> peerPresence;
            IMatch<E> peerMatch = this.getMapping().getMatchFor(peer, presenceRole);
            if (peerMatch == null || !peerMatch.isPartial() || (peerPresence = this.getOrCreateElementPresence(peerMatch)) == null) continue;
            this.markRequires(presence_p, peerPresence, presenceRole.opposite());
            this.markRequires(peerPresence, presence_p, presenceRole);
        }
        Collection<E> deletionPeers = this.getMergePolicy().getDeletionGroup(presence_p.getElement(), presence_p.getPresenceScope());
        for (E peer : deletionPeers) {
            IElementPresence<E> peerPresence;
            IMatch<E> peerMatch = this.getMapping().getMatchFor(peer, presenceRole);
            if (peerMatch == null || !peerMatch.isPartial() || (peerPresence = this.getOrCreateElementPresence(peerMatch)) == null) continue;
            this.markRequires(presence_p, peerPresence, presenceRole);
        }
    }

    protected void setOppositeReferenceDependencies(IReferenceValuePresence<E> first_p, IReferenceValuePresence<E> second_p) {
        assert (first_p.isOppositeOf(second_p));
        Role presenceRole = first_p.getPresenceRole();
        if (second_p.getPresenceScope().mIsManyReference(second_p.getFeature())) {
            this.markImplies(first_p, second_p, presenceRole);
            this.markImplies(first_p, second_p, presenceRole.opposite());
        } else {
            this.markRequires(first_p, second_p, presenceRole);
            this.markRequires(first_p, second_p, presenceRole.opposite());
        }
        if (first_p.getPresenceScope().mIsManyReference(first_p.getFeature())) {
            this.markImplies(second_p, first_p, presenceRole);
            this.markImplies(second_p, first_p, presenceRole.opposite());
        } else {
            this.markRequires(second_p, first_p, presenceRole);
            this.markRequires(second_p, first_p, presenceRole.opposite());
        }
    }

    protected void setOwnershipDependencies(IReferenceValuePresence<E> presence_p) {
        assert (presence_p.isOwnership());
        IMatch<E> valueMatch = presence_p.getValueMatch();
        if (valueMatch == null || !valueMatch.isPartial()) {
            IReferenceValuePresence<E> symmetricalOwnership = presence_p.getSymmetricalOwnership();
            if (symmetricalOwnership != null) {
                this.setSymmetricalOwnershipDependencies(presence_p, symmetricalOwnership);
            }
            if (valueMatch != null && !presence_p.isOrder()) {
                this.setCyclicOwnershipDependencies(presence_p);
            }
        }
    }

    protected void setPartialReferencedValueDependencies(IReferenceValuePresence<E> referenceDiff_p) {
        assert (referenceDiff_p.getValueMatch() != null);
        assert (referenceDiff_p.getValueMatch().isPartial());
        IElementPresence<E> presence = this.getOrCreateElementPresence(referenceDiff_p.getValueMatch());
        if (presence != null) {
            Role presenceRole = referenceDiff_p.getPresenceRole();
            this.markRequires(referenceDiff_p, presence, presenceRole.opposite());
            this.markRequires(presence, referenceDiff_p, presenceRole);
            if (referenceDiff_p.getFeature() != null) {
                ITreeDataScope absenceScope = this._comparison.getScope(presenceRole.opposite());
                if (referenceDiff_p.isOwnership() && this.getMergePolicy().bindPresenceToOwnership(absenceScope)) {
                    this.markImplies(presence, referenceDiff_p, presenceRole.opposite());
                    this.markImplies(referenceDiff_p, presence, presenceRole);
                } else {
                    ITreeDataScope presenceScope = referenceDiff_p.getPresenceScope();
                    Object opposite = presenceScope.mGetOppositeReference(referenceDiff_p.getFeature());
                    if (opposite != null && this.getMergePolicy().isMandatoryForAddition(referenceDiff_p.getElementMatch().get(presenceRole), opposite, presenceScope)) {
                        this.markRequires(presence, referenceDiff_p, presenceRole.opposite());
                        this.markRequires(referenceDiff_p, presence, presenceRole);
                    }
                }
            }
        }
    }

    protected void setPartialReferencingElementDependencies(IReferenceValuePresence<E> referenceDiff_p) {
        assert (referenceDiff_p.getElementMatch().isPartial());
        IElementPresence presence = this.getOrCreateElementPresence(referenceDiff_p.getElementMatch());
        if (presence != null) {
            Role presenceRole = referenceDiff_p.getPresenceRole();
            this.markRequires(referenceDiff_p, presence, presenceRole.opposite());
            this.markRequires(presence, referenceDiff_p, presenceRole);
        }
    }

    protected void setReferencedValueDependencies(IReferenceValuePresence<E> presence_p) {
        IValuePresence symmetrical;
        IReferenceValuePresence<E> oppositeDiff;
        IMatch<E> valueMatch = presence_p.getValueMatch();
        if (!presence_p.isOwnership() && (oppositeDiff = presence_p.getOpposite()) != null) {
            this.setOppositeReferenceDependencies(presence_p, oppositeDiff);
        }
        if ((symmetrical = presence_p.getSymmetrical()) != null) {
            this.setSymmetricalValuePresenceDependencies(presence_p, symmetrical);
        }
        if (presence_p.getElementMatch().isPartial()) {
            this.setPartialReferencingElementDependencies(presence_p);
        }
        if (valueMatch != null && valueMatch.isPartial()) {
            this.setPartialReferencedValueDependencies(presence_p);
        }
        if (presence_p.isOwnership()) {
            this.setOwnershipDependencies(presence_p);
        }
    }

    protected void setSymmetricalOwnershipDependencies(IReferenceValuePresence<E> first_p, IReferenceValuePresence<E> second_p) {
        assert (first_p.isSymmetricalOwnershipTo(second_p));
        this.markImplies(first_p, second_p, second_p.getPresenceRole());
        this.markImplies(second_p, first_p, first_p.getPresenceRole());
        this.markRequires(first_p, second_p, first_p.getPresenceRole());
        this.markRequires(second_p, first_p, second_p.getPresenceRole());
    }

    protected void setSymmetricalValuePresenceDependencies(IValuePresence<E> first_p, IValuePresence<E> second_p) {
        assert (first_p.isSymmetricalTo(second_p));
        this.markImplies(first_p, second_p, second_p.getPresenceRole());
        this.markImplies(second_p, first_p, first_p.getPresenceRole());
        this.markRequires(first_p, second_p, first_p.getPresenceRole());
        this.markRequires(second_p, first_p, second_p.getPresenceRole());
    }

    protected void setThreeWayProperties(IElementPresence<E> presence_p) {
        IMatch elementMatch = presence_p.getElementMatch();
        Object ancestorElement = elementMatch.get(Role.ANCESTOR);
        if (ancestorElement != null) {
            boolean diffWithAncestor = this.detectContentDifferences(elementMatch, presence_p.getPresenceRole(), Role.ANCESTOR, false);
            if (diffWithAncestor) {
                ((IDifference.Editable)((Object)presence_p)).markAsConflicting();
            }
        } else {
            ((IDifference.Editable)((Object)presence_p)).markAsDifferentFromAncestor();
        }
    }

    protected void setThreeWayProperties(IAttributeValuePresence<E> presence_p) {
        boolean aligned;
        Object ancestorHolder = presence_p.getElementMatch().get(Role.ANCESTOR);
        if (ancestorHolder == null) {
            aligned = false;
        } else {
            Object attribute = presence_p.getFeature();
            ITreeDataScope ancestorScope = this._comparison.getScope(Role.ANCESTOR);
            assert (ancestorScope != null);
            List<?> valuesInAncestor = ancestorScope.getAttributeValues(ancestorHolder, attribute);
            if (presence_p.isOrder()) {
                Role presenceRole = presence_p.getPresenceRole();
                List<?> values = presence_p.getPresenceScope().getAttributeValues(presence_p.getElementMatch().get(presenceRole), presence_p.getFeature());
                int maxIndex = -1;
                aligned = true;
                for (Object value : values) {
                    ObjectAndIndex matchingAncestorValue = this.findEqualAttributeValue(attribute, value, valuesInAncestor, ancestorScope);
                    if (matchingAncestorValue.getObject() == null) continue;
                    if (matchingAncestorValue.getIndex() < maxIndex) {
                        aligned = false;
                        break;
                    }
                    maxIndex = matchingAncestorValue.getIndex();
                }
            } else {
                ObjectAndIndex equalInAncestor = this.findEqualAttributeValue(attribute, presence_p.getValue(), valuesInAncestor, ancestorScope);
                boolean bl = aligned = equalInAncestor.getObject() != null;
            }
        }
        if (!aligned) {
            IValuePresence symmetrical = presence_p.getSymmetrical();
            if (symmetrical != null && !symmetrical.isAlignedWithAncestor()) {
                ((IDifference.Editable)((Object)presence_p)).markAsConflicting();
                ((IDifference.Editable)((Object)symmetrical)).markAsConflicting();
            } else {
                ((IDifference.Editable)((Object)presence_p)).markAsDifferentFromAncestor();
            }
        }
    }

    protected void setThreeWayProperties(IReferenceValuePresence<E> presence_p) {
        boolean aligned;
        Object ancestorHolder = presence_p.getElementMatch().get(Role.ANCESTOR);
        if (ancestorHolder == null) {
            aligned = false;
        } else {
            IMatch<E> valueMatch = presence_p.getValueMatch();
            Object ancestorValue = valueMatch == null ? null : valueMatch.get(Role.ANCESTOR);
            ITreeDataScope ancestorScope = this._comparison.getScope(Role.ANCESTOR);
            assert (ancestorScope != null);
            FArrayList ancestorValues = new FArrayList(ancestorScope.getReferenceValues(ancestorHolder, presence_p.getFeature()), IEqualityTester.BY_REFERENCE);
            if (presence_p.isOrder()) {
                Object reference = presence_p.getFeature();
                Role presenceRole = presence_p.getPresenceRole();
                List values = presence_p.getPresenceScope().getReferenceValues(presence_p.getElementMatch().get(presenceRole), reference);
                int maxIndex = -1;
                aligned = true;
                for (Object value : values) {
                    int index;
                    Object matchAncestor;
                    IMatch<E> currentValueMatch = this.getMapping().getMatchFor(value, presenceRole);
                    if (currentValueMatch == null || (matchAncestor = currentValueMatch.get(Role.ANCESTOR)) == null || (index = this.detectReferenceValueAmong(reference, matchAncestor, (List<E>)ancestorValues, false, ancestorScope)) < 0) continue;
                    if (index < maxIndex) {
                        aligned = false;
                        break;
                    }
                    maxIndex = index;
                }
            } else {
                aligned = ancestorValues.contains(ancestorValue);
            }
        }
        if (!aligned) {
            IValuePresence symmetrical = presence_p.getSymmetrical();
            if (symmetrical != null && !symmetrical.isAlignedWithAncestor()) {
                ((IDifference.Editable)((Object)presence_p)).markAsConflicting();
                ((IDifference.Editable)((Object)symmetrical)).markAsConflicting();
            } else {
                ((IDifference.Editable)((Object)presence_p)).markAsDifferentFromAncestor();
            }
        }
    }

    protected static class ObjectAndIndex {
        private Object _object;
        private int _index;

        public ObjectAndIndex(Object object_p, int index_p) {
            assert (object_p != null && index_p >= 0);
            this._object = object_p;
            this._index = index_p;
        }

        public ObjectAndIndex() {
            this._object = null;
            this._index = -1;
        }

        public boolean equals(Object peer_p) {
            boolean result = false;
            if (peer_p instanceof ObjectAndIndex) {
                ObjectAndIndex peer = (ObjectAndIndex)peer_p;
                result = this._object == null && peer.getObject() == null || this._object != null && this._object.equals(peer.getObject());
                result = result && this._index == peer.getIndex();
            }
            return result;
        }

        public Object getObject() {
            return this._object;
        }

        public int getIndex() {
            return this._index;
        }

        public int hashCode() {
            return (this._object != null ? this._object.hashCode() : 0) + Integer.valueOf(this._index).hashCode();
        }
    }
}

