/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.env.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.impl.AbstractAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.io.IOResources;

public final class FileBasedAleEnvironment
extends AbstractAleEnvironment {
    public static final String BEHAVIORS_KEY = "ale";
    public static final String METAMODELS_KEY = "ecore";
    private File platformFile;
    private IFile workspaceFile;
    private LinkedHashSet<String> metamodels = new LinkedHashSet();
    private LinkedHashSet<String> behaviors = new LinkedHashSet();

    public FileBasedAleEnvironment(IFile dslFile) {
        this.load(dslFile);
        this.workspaceFile = dslFile;
        this.platformFile = IOResources.toFile(this.workspaceFile).orElse(null);
    }

    public FileBasedAleEnvironment(File dslFile) {
        this.platformFile = dslFile;
        Set<IFile> ifiles = IOResources.toIFiles(dslFile);
        this.workspaceFile = ifiles.isEmpty() ? null : ifiles.iterator().next();
        try {
            this.load(new FileInputStream(dslFile));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public FileBasedAleEnvironment(InputStream input) throws IOException {
        this.load(input);
    }

    private void load(IFile file) {
        try {
            this.load(file.getContents());
        }
        catch (IOException | CoreException throwable) {
            // empty catch block
        }
    }

    @Override
    public LinkedHashSet<String> getBehaviorsSources() {
        return this.behaviors;
    }

    @Override
    public LinkedHashSet<String> getMetamodelsSources() {
        return this.metamodels;
    }

    public void save(IAleEnvironment environment) throws IOException {
        Properties newProperties = new Properties();
        newProperties.put(METAMODELS_KEY, String.join((CharSequence)",", environment.getMetamodelsSources()));
        newProperties.put(BEHAVIORS_KEY, String.join((CharSequence)",", environment.getBehaviorsSources()));
        if (this.workspaceFile != null) {
            FileBasedAleEnvironment.write(this.workspaceFile, newProperties);
        } else if (this.platformFile != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("#\n");
            for (Map.Entry<Object, Object> entry : newProperties.entrySet()) {
                sb.append(entry.getKey() + " = " + entry.getValue() + "\n");
            }
            Files.write(this.platformFile.toPath(), sb.toString().getBytes(), new OpenOption[0]);
        }
    }

    private void load(InputStream input) throws IOException {
        try {
            Properties properties = new Properties();
            properties.load(input);
            String allMetamodels = (String)properties.get(METAMODELS_KEY);
            String allBehaviors = (String)properties.get(BEHAVIORS_KEY);
            if (allMetamodels != null) {
                String[] rawMetamodels = allMetamodels.split(",");
                this.metamodels.addAll(FileBasedAleEnvironment.trim(rawMetamodels));
            }
            if (allBehaviors != null) {
                String[] rawBehaviors = allBehaviors.split(",");
                this.behaviors.addAll(FileBasedAleEnvironment.trim(rawBehaviors));
            }
        }
        finally {
            input.close();
        }
    }

    private static void write(IFile workspaceFile, Properties newProperties) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("#\n");
        for (Map.Entry<Object, Object> entry : newProperties.entrySet()) {
            sb.append(entry.getKey() + " = " + entry.getValue() + "\n");
        }
        ByteArrayInputStream readableProperties = new ByteArrayInputStream(sb.toString().getBytes());
        try {
            if (!workspaceFile.exists()) {
                workspaceFile.create((InputStream)readableProperties, false, (IProgressMonitor)new NullProgressMonitor());
            } else {
                workspaceFile.setContents((InputStream)readableProperties, 2, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private static List<String> trim(String[] uris) {
        return Arrays.stream(uris).map(String::trim).collect(Collectors.toList());
    }
}

