/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter.notapi;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IRootEObjectProvider;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.runtime.impl.QueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.services.AnyServices;
import org.eclipse.acceleo.query.services.BooleanServices;
import org.eclipse.acceleo.query.services.CollectionServices;
import org.eclipse.acceleo.query.services.ComparableServices;
import org.eclipse.acceleo.query.services.NumberServices;
import org.eclipse.acceleo.query.services.ResourceServices;
import org.eclipse.acceleo.query.services.StringServices;
import org.eclipse.acceleo.query.services.XPathServices;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.interpreter.DiagnosticLogger;
import org.eclipse.emf.ecoretools.ale.core.interpreter.IServiceCallListener;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.ExtensionLookupEngine;
import org.eclipse.emf.ecoretools.ale.core.interpreter.notapi.DynamicFeatureRegistry;
import org.eclipse.emf.ecoretools.ale.core.interpreter.services.DynamicEObjectServices;
import org.eclipse.emf.ecoretools.ale.core.interpreter.services.EvalBodyService;
import org.eclipse.emf.ecoretools.ale.core.interpreter.services.FactoryService;
import org.eclipse.emf.ecoretools.ale.core.interpreter.services.LogService;
import org.eclipse.emf.ecoretools.ale.core.interpreter.services.SelectedCallService;
import org.eclipse.emf.ecoretools.ale.core.interpreter.services.TrigoServices;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;

public class EvalEnvironment {
    public static final String INIT_ERROR = "An error occured during initialization of an EObject";
    private IQueryEnvironment qryEnv;
    private DynamicFeatureRegistry dynamicFeatures;
    private DiagnosticLogger logger;
    private List<IServiceCallListener> listeners;
    private IAleEnvironment environment;

    public EvalEnvironment(IAleEnvironment environment, DiagnosticLogger logger, List<IServiceCallListener> listeners) {
        this.environment = environment;
        this.qryEnv = environment.getContext();
        this.logger = logger;
        this.listeners = listeners;
        this.registerImplem(environment.getBehaviors().getUnits());
        this.populateEnvironmentWithDefaultServices(null, null);
    }

    public IQueryEnvironment getQueryEnvironment() {
        return this.qryEnv;
    }

    public DynamicFeatureRegistry getFeatureAccess() {
        return this.dynamicFeatures;
    }

    public List<IServiceCallListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IServiceCallListener>();
        }
        return this.listeners;
    }

    public DiagnosticLogger getLogger() {
        return this.logger;
    }

    private void populateEnvironmentWithDefaultServices(CrossReferenceProvider xRefProvider, IRootEObjectProvider rootProvider) {
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.qryEnv, (Object)new AnyServices((IReadOnlyQueryEnvironment)this.qryEnv));
        ServiceUtils.registerServices((IQueryEnvironment)this.qryEnv, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.qryEnv, (Object)((Object)new DynamicEObjectServices((IReadOnlyQueryEnvironment)this.qryEnv, xRefProvider, rootProvider, this.dynamicFeatures)));
        ServiceUtils.registerServices((IQueryEnvironment)this.qryEnv, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.qryEnv, (Object)new XPathServices((IReadOnlyQueryEnvironment)this.qryEnv));
        ServiceUtils.registerServices((IQueryEnvironment)this.qryEnv, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.qryEnv, ComparableServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.qryEnv, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.qryEnv, NumberServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.qryEnv, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.qryEnv, StringServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.qryEnv, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.qryEnv, BooleanServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.qryEnv, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.qryEnv, CollectionServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.qryEnv, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.qryEnv, ResourceServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.qryEnv, (Set)services);
        if (this.qryEnv.getLookupEngine() instanceof ExtensionLookupEngine) {
            IService selectedCall = new SelectedCallService(this.qryEnv, (ExtensionLookupEngine)this.qryEnv.getLookupEngine()).createService();
            ServiceUtils.registerServices((IQueryEnvironment)this.qryEnv, (Set)Sets.newHashSet((Object[])new IService[]{selectedCall}));
        }
        try {
            Method logMethod = LogService.class.getMethod("log", Object.class);
            this.qryEnv.registerService((IService)new JavaMethodService(logMethod, null));
            this.qryEnv.registerService(this.newCreateService());
            Method cosMethod = TrigoServices.class.getMethod("cosinus", Double.class);
            this.qryEnv.registerService((IService)new JavaMethodService(cosMethod, null));
            Method sinMethod = TrigoServices.class.getMethod("sinus", Double.class);
            this.qryEnv.registerService((IService)new JavaMethodService(sinMethod, null));
            Method tanMethod = TrigoServices.class.getMethod("tan", Double.class);
            this.qryEnv.registerService((IService)new JavaMethodService(tanMethod, null));
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
    }

    public void registerImplem(List<ModelUnit> allImplemModels) {
        List<EClass> domain = this.qryEnv.getEPackageProvider().getEClassifiers().stream().filter(cls -> cls instanceof EClass).map(cls -> (EClass)cls).collect(Collectors.toList());
        this.dynamicFeatures = new DynamicFeatureRegistry(allImplemModels, domain);
        this.createServices(allImplemModels).forEach(arg_0 -> ((IQueryEnvironment)this.qryEnv).registerService(arg_0));
    }

    private List<EvalBodyService> createServices(List<ModelUnit> allImplemModels) {
        LinkedHashMap res = new LinkedHashMap();
        allImplemModels.stream().forEach(implemModel -> implemModel.getClassExtensions().stream().flatMap(cls -> cls.getMethods().stream()).forEach(implemOp -> {
            EvalBodyService evalBodyService = res.put(implemOp, new EvalBodyService(this.environment, (org.eclipse.emf.ecoretools.ale.implementation.Method)implemOp, this, this.logger));
        }));
        ArrayList newClassOperations = new ArrayList();
        allImplemModels.stream().forEach(implemModel -> implemModel.getClassDefinitions().stream().flatMap(cls -> cls.getMethods().stream()).forEach(implemOp -> {
            boolean bl = newClassOperations.add(new EvalBodyService(this.environment, (org.eclipse.emf.ecoretools.ale.implementation.Method)implemOp, this, this.logger));
        }));
        List<ExtendedClass> allExtendedClasses = allImplemModels.stream().flatMap(implem -> implem.getClassExtensions().stream()).collect(Collectors.toList());
        Map<ExtendedClass, Integer> priorityMap = this.getPriorities(allExtendedClasses);
        res.keySet().stream().forEach(op -> {
            int prio = (Integer)priorityMap.get(op.eContainer());
            ((EvalBodyService)((Object)((Object)res.get(op)))).setPriority(prio);
        });
        List<EvalBodyService> allOpServices = res.entrySet().stream().map(entry -> (EvalBodyService)((Object)((Object)entry.getValue()))).collect(Collectors.toList());
        allOpServices.addAll(newClassOperations);
        return allOpServices;
    }

    private Map<ExtendedClass, Integer> getPriorities(List<ExtendedClass> allCls) {
        HashMap<ExtendedClass, Integer> priorities = new HashMap<ExtendedClass, Integer>();
        allCls.forEach(cls -> {
            int n = this.getPriority((ExtendedClass)cls, (Map<ExtendedClass, Integer>)priorities);
        });
        return priorities;
    }

    private int getMaxPriority(List<ExtendedClass> superCls, Map<ExtendedClass, Integer> priorities) {
        Optional<Integer> max = superCls.stream().map(cls -> this.getPriority((ExtendedClass)cls, priorities)).max((a, b) -> Integer.compare(a, b));
        if (max.isPresent()) {
            return max.get();
        }
        return 0;
    }

    private int getPriority(ExtendedClass cls, Map<ExtendedClass, Integer> priorities) {
        Integer priority = priorities.get(cls);
        if (priority == null) {
            if (!cls.getExtends().isEmpty()) {
                priorities.put(cls, 0);
                int p = this.getMaxPriority((List<ExtendedClass>)cls.getExtends(), priorities) + 1;
                priorities.put(cls, p);
                return p;
            }
            priorities.put(cls, 0);
            return 0;
        }
        return priority;
    }

    public void initialize(Set<EObject> model) {
        try {
            this.dynamicFeatures.dynamicModelConstructor(model, (IQueryEvaluationEngine)new QueryEvaluationEngine(this.qryEnv));
        }
        catch (Exception e) {
            BasicDiagnostic initError = new BasicDiagnostic(4, "org.eclipse.emf.ecoretools.ale.core", 0, INIT_ERROR, new Object[]{model});
            this.logger.notify((Diagnostic)initError);
        }
    }

    private IService newCreateService() throws NoSuchMethodException, SecurityException {
        Method createMethod = FactoryService.class.getMethod("create", EClass.class);
        return new JavaMethodService(createMethod, new FactoryService(this)){

            public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
                Set res = super.getType(call, services, validationResult, queryEnvironment, argTypes);
                if (!argTypes.isEmpty()) {
                    return Sets.newHashSet((Object[])new IType[]{argTypes.get(0)});
                }
                return res;
            }
        };
    }
}

