/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.validation;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.ClassOpenedMoreThanOnce;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.DiagnosticsFactory;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.IncorrectExtendOrder;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.Message;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.NotAnOpenableClass;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.OpenClassNotFound;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.TypeHasNamesakes;
import org.eclipse.emf.ecoretools.ale.core.validation.BaseValidator;
import org.eclipse.emf.ecoretools.ale.core.validation.IValidator;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureInsert;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureRemove;
import org.eclipse.emf.ecoretools.ale.implementation.ForEach;
import org.eclipse.emf.ecoretools.ale.implementation.If;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;
import org.eclipse.emf.ecoretools.ale.implementation.UnresolvedEClassifier;
import org.eclipse.emf.ecoretools.ale.implementation.VariableAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.VariableDeclaration;
import org.eclipse.emf.ecoretools.ale.implementation.VariableInsert;
import org.eclipse.emf.ecoretools.ale.implementation.VariableRemove;
import org.eclipse.emf.ecoretools.ale.implementation.While;

public class OpenClassValidator
implements IValidator {
    private BaseValidator base;
    private Map<String, ExtendedClass> duplicatedExensions = new HashMap<String, ExtendedClass>();

    @Override
    public void setBase(BaseValidator baseValidator) {
        this.base = baseValidator;
    }

    @Override
    public List<Message> validateModelBehavior(List<ModelUnit> units) {
        ArrayList<Message> msgs = new ArrayList<Message>();
        this.duplicatedExensions.clear();
        ArrayListMultimap extensionByBase = ArrayListMultimap.create();
        units.stream().flatMap(unit -> unit.getClassExtensions().stream()).forEach(arg_0 -> OpenClassValidator.lambda$1((Multimap)extensionByBase, arg_0));
        extensionByBase.keySet().forEach(arg_0 -> this.lambda$2((Multimap)extensionByBase, arg_0));
        return msgs;
    }

    @Override
    public List<Message> validateModelUnit(ModelUnit unit) {
        ArrayList<Message> msgs = new ArrayList<Message>();
        return msgs;
    }

    @Override
    public List<Message> validateExtendedClass(ExtendedClass xtdClass) {
        EClass baseClass;
        ArrayList<Message> msgs = new ArrayList<Message>();
        if (this.duplicatedExensions.containsKey(xtdClass.getName())) {
            ClassOpenedMoreThanOnce classOpenedMoreThanOnce = DiagnosticsFactory.eINSTANCE.createClassOpenedMoreThanOnce();
            classOpenedMoreThanOnce.setSource((EObject)xtdClass);
            classOpenedMoreThanOnce.setLocation(DiagnosticsFactory.eINSTANCE.createCodeLocation());
            classOpenedMoreThanOnce.getLocation().setStartPosition(this.base.getStartOffset(xtdClass));
            classOpenedMoreThanOnce.getLocation().setEndPosition(this.base.getEndOffset(xtdClass));
            classOpenedMoreThanOnce.getLocation().setLine(this.base.getLines(xtdClass).get(0));
            classOpenedMoreThanOnce.getLocation().setSource(this.base.getSourceFile(xtdClass));
            classOpenedMoreThanOnce.setCurrentDeclaration(xtdClass);
            classOpenedMoreThanOnce.setPreviousDeclaration(this.duplicatedExensions.get(xtdClass.getName()));
            msgs.add(classOpenedMoreThanOnce);
        }
        if ((baseClass = xtdClass.getBaseClass()) == null) {
            NotAnOpenableClass notAnOpenableClass = DiagnosticsFactory.eINSTANCE.createNotAnOpenableClass();
            notAnOpenableClass.setSource((EObject)xtdClass);
            notAnOpenableClass.setLocation(DiagnosticsFactory.eINSTANCE.createCodeLocation());
            notAnOpenableClass.getLocation().setStartPosition(this.base.getStartOffset(xtdClass));
            notAnOpenableClass.getLocation().setEndPosition(this.base.getStartOffset(xtdClass) + "open class ".length() + xtdClass.getName().length());
            notAnOpenableClass.getLocation().setLine(this.base.getLines(xtdClass).get(0));
            notAnOpenableClass.getLocation().setSource(this.base.getSourceFile(xtdClass));
            notAnOpenableClass.setOpenClass(xtdClass);
            msgs.add(notAnOpenableClass);
        } else {
            this.validateExtendedClassHasNoNamesake(xtdClass, msgs);
            this.validateExtendedClassExists(xtdClass, baseClass, msgs);
            EList superTypes = baseClass.getESuperTypes();
            List extendsBaseClasses = xtdClass.getExtends().stream().map(xtd -> xtd.getBaseClass()).collect(Collectors.toList());
            int upperIndex = -1;
            for (EClass superType : superTypes) {
                int currentIndex = extendsBaseClasses.indexOf(superType);
                if (currentIndex != -1 && currentIndex <= upperIndex) {
                    IncorrectExtendOrder incorrectExtendOrder = DiagnosticsFactory.eINSTANCE.createIncorrectExtendOrder();
                    incorrectExtendOrder.setSource((EObject)xtdClass);
                    incorrectExtendOrder.setLocation(DiagnosticsFactory.eINSTANCE.createCodeLocation());
                    incorrectExtendOrder.getLocation().setStartPosition(this.base.getStartOffset(xtdClass));
                    incorrectExtendOrder.getLocation().setEndPosition(this.base.getStartOffset(xtdClass) + ("open class " + xtdClass.getName() + " extends " + xtdClass.getBaseClass().getName()).length());
                    incorrectExtendOrder.getLocation().setLine(this.base.getLines(xtdClass).get(0));
                    incorrectExtendOrder.getLocation().setSource(this.base.getSourceFile(xtdClass));
                    incorrectExtendOrder.setSuperType(superType);
                    incorrectExtendOrder.setSuperSuperType((EClass)extendsBaseClasses.get(upperIndex));
                    msgs.add(incorrectExtendOrder);
                    continue;
                }
                upperIndex = currentIndex;
            }
        }
        return msgs;
    }

    private void validateExtendedClassExists(ExtendedClass xtdClass, EClass baseClass, List<Message> msgs) {
        boolean baseClassDoesntExist = UnresolvedEClassifier.class.equals((Object)baseClass.getInstanceClass());
        if (baseClassDoesntExist) {
            OpenClassNotFound openClassDoesNotExist = DiagnosticsFactory.eINSTANCE.createOpenClassNotFound();
            openClassDoesNotExist.setSource((EObject)xtdClass);
            openClassDoesNotExist.setLocation(DiagnosticsFactory.eINSTANCE.createCodeLocation());
            openClassDoesNotExist.getLocation().setStartPosition(this.base.getStartOffset(xtdClass));
            openClassDoesNotExist.getLocation().setEndPosition(this.base.getStartOffset(xtdClass) + "open class ".length() + xtdClass.getName().length());
            openClassDoesNotExist.getLocation().setLine(this.base.getLines(xtdClass).get(0));
            openClassDoesNotExist.getLocation().setSource(this.base.getSourceFile(xtdClass));
            openClassDoesNotExist.setOpenClass(xtdClass);
            msgs.add(openClassDoesNotExist);
        }
    }

    private void validateExtendedClassHasNoNamesake(ExtendedClass xtdClass, List<Message> msgs) {
        boolean hasNamesakes;
        Collection namesakes = this.base.getQryEnv().getEPackageProvider().getTypes(xtdClass.getName());
        boolean bl = hasNamesakes = namesakes.size() > 1;
        if (hasNamesakes) {
            TypeHasNamesakes openClassHasNamesakes = DiagnosticsFactory.eINSTANCE.createTypeHasNamesakes();
            openClassHasNamesakes.setSource((EObject)xtdClass);
            openClassHasNamesakes.getNamesakes().addAll(namesakes);
            openClassHasNamesakes.setLocation(DiagnosticsFactory.eINSTANCE.createCodeLocation());
            openClassHasNamesakes.getLocation().setStartPosition(this.base.getStartOffset(xtdClass));
            openClassHasNamesakes.getLocation().setEndPosition(this.base.getStartOffset(xtdClass) + "open class ".length() + xtdClass.getName().length());
            openClassHasNamesakes.getLocation().setLine(this.base.getLines(xtdClass).get(0));
            openClassHasNamesakes.getLocation().setSource(this.base.getSourceFile(xtdClass));
            msgs.add(openClassHasNamesakes);
        }
    }

    @Override
    public List<Message> validateRuntimeClass(RuntimeClass classDef) {
        return Collections.emptyList();
    }

    @Override
    public List<Message> validateMethod(Method mtd) {
        return Collections.emptyList();
    }

    @Override
    public List<Message> validateFeatureAssignment(FeatureAssignment featAssign) {
        return Collections.emptyList();
    }

    @Override
    public List<Message> validateFeatureInsert(FeatureInsert featInsert) {
        return Collections.emptyList();
    }

    @Override
    public List<Message> validateFeatureRemove(FeatureRemove featRemove) {
        return Collections.emptyList();
    }

    @Override
    public List<Message> validateVariableAssignment(VariableAssignment varAssign) {
        return Collections.emptyList();
    }

    @Override
    public List<Message> validateVariableDeclaration(VariableDeclaration varDecl) {
        return Collections.emptyList();
    }

    @Override
    public List<Message> validateVariableInsert(VariableInsert varInsert) {
        return Collections.emptyList();
    }

    @Override
    public List<Message> validateVariableRemove(VariableRemove varRemove) {
        return Collections.emptyList();
    }

    @Override
    public List<Message> validateForEach(ForEach loop) {
        return Collections.emptyList();
    }

    @Override
    public List<Message> validateIf(If ifStmt) {
        return Collections.emptyList();
    }

    @Override
    public List<Message> validateWhile(While loop) {
        return Collections.emptyList();
    }

    private static /* synthetic */ void lambda$1(Multimap multimap, ExtendedClass xtd) {
        boolean bl = multimap.put((Object)xtd.getBaseClass(), (Object)xtd);
    }

    private /* synthetic */ void lambda$2(Multimap multimap, EClass base) {
        Collection extensions = multimap.get((Object)base);
        if (extensions.size() > 1) {
            extensions.stream().skip(1L).filter(xtd -> xtd.getExtends().isEmpty()).forEach(xtd -> {
                ExtendedClass extendedClass = this.duplicatedExensions.put(xtd.getName(), (ExtendedClass)xtd);
            });
        }
    }
}

