/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ui.hover;

import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hover.DispatchingEObjectTextHover;
import org.eclipse.xtext.ui.editor.hover.IEObjectHoverProvider;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class AleDispatchingEObjectHover
extends DispatchingEObjectTextHover {
    @Inject
    IEObjectHoverProvider hoverProvider;
    IEObjectHoverProvider.IInformationControlCreatorProvider lastCreatorProvider = null;

    public Object getHoverInfo(EObject first, ITextViewer textViewer, IRegion hoverRegion) {
        if (first instanceof Keyword) {
            this.lastCreatorProvider = this.hoverProvider.getHoverInfo(first, textViewer, hoverRegion);
            return this.lastCreatorProvider == null ? null : this.lastCreatorProvider.getInfo();
        }
        this.lastCreatorProvider = null;
        return super.getHoverInfo(first, textViewer, hoverRegion);
    }

    public IInformationControlCreator getHoverControlCreator() {
        return this.lastCreatorProvider == null ? super.getHoverControlCreator() : this.lastCreatorProvider.getHoverControlCreator();
    }

    protected Pair<EObject, IRegion> getXtextElementAt(XtextResource resource, int offset) {
        Pair<EObject, IRegion> result = super.getXtextElementAt(resource, offset);
        if (result == null) {
            result = AleDispatchingEObjectHover.resolveKeywordAt(resource, offset);
        }
        return result;
    }

    private static Pair<EObject, IRegion> resolveKeywordAt(XtextResource resource, int offset) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null) {
            ILeafNode leaf = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)offset);
            if (leaf != null && leaf.isHidden() && leaf.getOffset() == offset) {
                leaf = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)(offset - 1));
            }
            if (leaf != null && leaf.getGrammarElement() instanceof Keyword) {
                Keyword keyword = (Keyword)leaf.getGrammarElement();
                if (Arrays.asList("open", "behavior").contains(keyword.getValue())) {
                    return Tuples.create((Object)keyword, (Object)new Region(leaf.getOffset(), leaf.getLength()));
                }
            }
        }
        return null;
    }
}

