/*
 * generated by Xtext 2.10.0
 */
package org.eclipse.emf.ecoretools.validation

import com.google.common.collect.Sets
import java.io.File
import java.util.ArrayList
import java.util.List
import org.eclipse.core.resources.IFile
import org.eclipse.core.resources.IMarker
import org.eclipse.core.resources.IProject
import org.eclipse.core.resources.IResource
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.emf.common.util.URI
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecoretools.AleXtextPlugin
import org.eclipse.emf.ecoretools.ale.OrderedSet
import org.eclipse.emf.ecoretools.ale.SeqType
import org.eclipse.emf.ecoretools.ale.Sequence
import org.eclipse.emf.ecoretools.ale.SetType
import org.eclipse.emf.ecoretools.ale.Unit
import org.eclipse.emf.ecoretools.ale.core.diagnostics.Message
import org.eclipse.emf.ecoretools.ale.core.env.impl.FileBasedAleEnvironment
import org.eclipse.emf.ecoretools.ale.core.interpreter.impl.AleInterpreter
import org.eclipse.emf.ecoretools.ale.core.io.IOResources
import org.eclipse.emf.ecoretools.ale.core.validation.ALEValidator
import org.eclipse.emf.ecoretools.ale.core.validation.impl.TypeChecker
import org.eclipse.emf.ecoretools.ale.ide.project.IAleProject
import org.eclipse.emf.ecoretools.ale.validation.DiagnosticsToEditorMarkerAdapter
import org.eclipse.emf.ecoretools.ale.validation.EditorMarkerFormatter
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer
import org.eclipse.xtext.Keyword
import org.eclipse.xtext.nodemodel.impl.HiddenLeafNode
import org.eclipse.xtext.nodemodel.util.NodeModelUtils
import org.eclipse.xtext.validation.Check
import org.eclipse.xtext.validation.Issue

/**
 * Delegate validation to ALE validator
 */
class AleValidator extends AbstractAleValidator {
	
	@Check
	def checkIsValid(Unit root) {
		
		val IFile aleFile = WorkspaceSynchronizer.getFile(root.eResource);
		cleanUpMarkers(aleFile);
		
		val IProject project = aleFile.project;
		val env = IAleProject.from(project).environment;

		val interpreter = env.interpreter as AleInterpreter
		try {
			interpreter.initScope(Sets.newHashSet(),Sets.newHashSet(#[project.name]))
			val parsedSemantics = env.behaviors.parsedFiles
			
			val parsed = parsedSemantics.findFirst[sem | aleFile == IOResources.toIFile(new File(sem.sourceFile))]
			val aleFileIsNotInEnv = parsed === null
			if (aleFileIsNotInEnv) {
				aleFile.createFileNotInEnvMarker()
				return
			}
			
			/*
	    	 * Register services
	    	 */
	    	val List<String> services = 
	    		parsedSemantics
		    	.map[getRoot()]
		    	.filterNull
		    	.map[getServices()]
		    	.flatten
		    	.toList
	    	interpreter.registerServices(services)
			
			val ALEValidator validator = new ALEValidator(env);
			validator.validate(parsedSemantics);
			val List<Message> msgs = validator.getMessages();
			
			logInternalErrors(aleFile, msgs)
			
			val markerFactory = new DiagnosticsToEditorMarkerAdapter([ str | aleFile.createMarker(str) ], new EditorMarkerFormatter(new TypeChecker(null, env.context)))
			
			msgs.filter[ msg |
					try { 
						val file = env.behaviors.findParsedFileDefining(msg.source)
						if (! file.isPresent) {
							return false
						}
						return IOResources.toIFile(new File(file.get.sourceFile)) == aleFile
					}
					catch (Exception e) {
						AleXtextPlugin.error("Unable to check whether the error comes from the current editor: " + msg, e)
						return true
					}
				]
				.forEach[msg | markerFactory.doSwitch(msg)]
		}
		catch (Exception e) {
			val marker = aleFile.createMarker(AleMarkerTypes.DEFAULT)
			marker.setAttribute(IMarker.MESSAGE, "An internal error occurred while validating the file: " + e.message)
			marker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_ERROR)
			marker.setAttribute(IMarker.CHAR_START, 0)
			marker.setAttribute(IMarker.CHAR_END, 0)
			
			AleXtextPlugin.error("An internal error occurred while validating " + aleFile, e)
		}
		finally {
			env.close()
		}
		
	}
	
	@Check
	def checkSequenceInitialization(Sequence sequence) {
		checkNoExtraSpaceAfterKeyword(sequence, "Sequence", "Sequence initialization")
	}
	
	@Check
	def checkOrderedSetInitialization(OrderedSet orderedSet) {
		checkNoExtraSpaceAfterKeyword(orderedSet, "OrderedSet", "OrderedSet initialization")
	}
	
	@Check
	def checkSequenceTypeDeclaration(SeqType seqType) {
		checkNoExtraSpaceAfterKeyword(seqType, "Sequence", "Sequence type declaration")
	}
	
	@Check
	def checkOrderedSetTypeDeclaration(SetType setType) {
		checkNoExtraSpaceAfterKeyword(setType, "OrderedSet", "OrderedSet type declaration")
	}
	
	def checkNoExtraSpaceAfterKeyword(EObject grammarElement, String keyword, String message) {		
		val node = NodeModelUtils.getNode(grammarElement)
		val keywordNode = node.children.findFirst[it.grammarElement instanceof Keyword
				&& (it.grammarElement as Keyword).value.equals(keyword)]
		if (keywordNode.nextSibling instanceof HiddenLeafNode) {
			messageAcceptor.acceptError("Extra space in " + message, grammarElement,
				keywordNode.endOffset, keywordNode.nextSibling.length, "")
		}
	}
	
	private static def void logInternalErrors(IFile aleFile, List<Message> messages) {
		messages.filter(typeof(InternalError))
				.forEach[ internalError | AleXtextPlugin.error("An internal error occurred during validation of " + aleFile.fullPath, internalError.cause)]
	}
	
	// copied from WorkbenchDsl (which introduce cyclic dependency if used)
	static def void resolveUris(FileBasedAleEnvironment dsl) {
		val newSemantics = new ArrayList<String>();
		val ws = ResourcesPlugin.getWorkspace();
		dsl.getBehaviorsSources()
			.forEach[elem |
				val uri = URI.createURI(elem);
				if(ws !== null && uri.isPlatform()) {
					val file = ws.getRoot().findMember(uri.toPlatformString(true));
					val path = file.getLocationURI().getRawPath();
					newSemantics.add(path);
				}
				else {
					newSemantics.add(elem);
				}
			]
		dsl.getBehaviorsSources().clear();
		dsl.getBehaviorsSources().addAll(newSemantics);
	}
	
	private def cleanUpMarkers(IFile file) {
		file.deleteMarkers(AleMarkerTypes.DEFAULT, true, IResource.DEPTH_ZERO);
		file.deleteMarkers(AleMarkerTypes.SOURCE_FILE_NOT_IN_ENV, true, IResource.DEPTH_ZERO);
	}
	
	/** Adds a marker warning about the file not being part of ALE environment */
	private static def createFileNotInEnvMarker(IFile file) {
		val marker = file.createMarker(AleMarkerTypes.SOURCE_FILE_NOT_IN_ENV)
		marker.setAttribute(IMarker.MESSAGE, "This file is not part of the project's ALE environment, it won't be validated")
		marker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_WARNING)
		marker.setAttribute(IMarker.CHAR_START, 0)
		marker.setAttribute(IMarker.LINE_NUMBER, 0)
		marker.setAttribute(IMarker.LOCATION, "line: " + 0 + " " + file.fullPath.toString())
		
		// Attributes used by Xtext to find the associated quick fix
		
		marker.setAttribute(Issue.CODE_KEY, AleMarkerTypes.SOURCE_FILE_NOT_IN_ENV)
		marker.setAttribute(Issue.COLUMN_KEY, 0)
		marker.setAttribute(Issue.URI_KEY, URI.createPlatformResourceURI(file.fullPath.toString(), true).toString)
		marker.setAttribute("FIXABLE_KEY", true);
		
		/*
		 * MUST BE SET LAST.
		 * 
		 * Looks like the editor is updated when CHAR_END is set,
		 * and the editor must be updated once all other attributes
		 * are properly set.
		 * 
		 * See https://www.eclipse.org/forums/index.php?t=msg&th=1104367&goto=1829410&#msg_1829410
		 */
		marker.setAttribute(IMarker.CHAR_END, 0)
	}
}
