/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons.BaseConcurrentModelExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons.MoccmlExecutionPlatform;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IMoccmlRunConfiguration;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.extensions.languages.MoccmlLanguageAdditionExtension;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.extensions.languages.MoccmlLanguageAdditionExtensionPoint;
import org.eclipse.gemoc.executionframework.engine.commons.EngineContextException;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.ActionModel;
import org.eclipse.gemoc.xdsmlframework.api.core.ExecutionMode;
import org.eclipse.gemoc.xdsmlframework.api.extensions.languages.LanguageDefinitionExtension;
import org.eclipse.gemoc.xdsmlframework.api.extensions.languages.LanguageDefinitionExtensionPoint;

public class MoccmlModelExecutionContext
extends BaseConcurrentModelExecutionContext<IMoccmlRunConfiguration, MoccmlExecutionPlatform, LanguageDefinitionExtension> {
    protected ActionModel _feedbackModel;
    protected String moccmlscenarioModelPath = null;
    public boolean hasARegisteredScenario = false;
    protected MoccmlLanguageAdditionExtension _moccmlLanguageAdditionExtension;

    public MoccmlModelExecutionContext(IMoccmlRunConfiguration runConfiguration, ExecutionMode executionMode) throws EngineContextException {
        super(runConfiguration, executionMode);
        this._moccmlLanguageAdditionExtension = this.getMoccmlLanguageAddition(runConfiguration.getLanguageName());
        this.moccmlscenarioModelPath = runConfiguration.getMoccmlScenarioModelPath();
        if (this.moccmlscenarioModelPath.length() > 1) {
            this.hasARegisteredScenario = true;
        }
    }

    public ActionModel getFeedbackModel() {
        return this._feedbackModel;
    }

    public String getMoccmlscenarioModelPath() {
        return this.moccmlscenarioModelPath;
    }

    public void setMoccmlscenarioModelPath(String moccmlscenarioModelPath) {
        this.moccmlscenarioModelPath = moccmlscenarioModelPath;
    }

    public Resource setUpFeedbackModel() {
        URI feedbackPlatformURI = URI.createPlatformResourceURI((String)this.getWorkspace().getMSEModelPath().removeFileExtension().addFileExtension("feedback").toString(), (boolean)true);
        try {
            Resource resource = this.getResourceModel().getResourceSet().getResource(feedbackPlatformURI, true);
            this._feedbackModel = (ActionModel)resource.getContents().get(0);
            return resource;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected LanguageDefinitionExtension getLanguageDefinitionExtension(String languageName) throws EngineContextException {
        LanguageDefinitionExtension languageDefinition = LanguageDefinitionExtensionPoint.findDefinition((String)languageName);
        if (languageDefinition == null) {
            String message = "Cannot find xdsml definition for the language " + ((IMoccmlRunConfiguration)this._runConfiguration).getLanguageName() + ", please verify that is is correctly deployed.";
            throw new EngineContextException(message);
        }
        return languageDefinition;
    }

    public MoccmlLanguageAdditionExtension getMoccmlLanguageAddition(String languageName) throws EngineContextException {
        MoccmlLanguageAdditionExtension languageAddition = MoccmlLanguageAdditionExtensionPoint.findMoccmlLanguageAdditionForLanguage((String)languageName);
        if (languageAddition == null) {
            String message = "Cannot find moccml addition for the language " + ((IMoccmlRunConfiguration)this._runConfiguration).getLanguageName() + ", please verify that is is correctly deployed.";
            throw new EngineContextException(message);
        }
        return languageAddition;
    }

    public MoccmlLanguageAdditionExtension getMoccmlLanguageAdditionExtension() {
        return this._moccmlLanguageAdditionExtension;
    }

    protected MoccmlExecutionPlatform createExecutionPlatform() throws CoreException {
        try {
            LanguageDefinitionExtension moccmlLangDef = this.getLanguageDefinitionExtension(((IMoccmlRunConfiguration)this._runConfiguration).getLanguageName());
            MoccmlLanguageAdditionExtension languageAddition = this.getMoccmlLanguageAddition(((IMoccmlRunConfiguration)this._runConfiguration).getLanguageName());
            MoccmlExecutionPlatform platform = new MoccmlExecutionPlatform(languageAddition, moccmlLangDef, this._runConfiguration);
            platform.setCodeExecutor(languageAddition.instanciateCodeExecutor());
            return platform;
        }
        catch (EngineContextException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getDefaultRunDeciderName() {
        return "Solver decider";
    }
}

