/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.event.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.executionframework.behavioralinterface.behavioralInterface.BehavioralInterface;
import org.eclipse.gemoc.executionframework.behavioralinterface.behavioralInterface.Event;
import org.eclipse.gemoc.executionframework.event.manager.CallNotification;
import org.eclipse.gemoc.executionframework.event.manager.ICallRequest;
import org.eclipse.gemoc.executionframework.event.manager.IEventManager;
import org.eclipse.gemoc.executionframework.event.manager.IImplementationRelationship;
import org.eclipse.gemoc.executionframework.event.manager.IRelationshipManager;
import org.eclipse.gemoc.executionframework.event.manager.ISubtypingRelationship;
import org.eclipse.gemoc.executionframework.event.manager.ReturnNotification;
import org.eclipse.gemoc.executionframework.event.model.event.EventOccurrence;
import org.eclipse.gemoc.executionframework.event.model.event.EventOccurrenceType;

public class RelationshipManager
implements IRelationshipManager {
    private final IEventManager eventManager;
    private final Map<String, BehavioralInterface> uriToBehavioralInterface = new HashMap<String, BehavioralInterface>();
    private final Set<IImplementationRelationship> implementationRelationships = new HashSet<IImplementationRelationship>();
    private final Map<String, List<IImplementationRelationship>> inputImplementationRelationships = new HashMap<String, List<IImplementationRelationship>>();
    private final Map<String, List<ISubtypingRelationship>> inputSubtypingRelationships = new HashMap<String, List<ISubtypingRelationship>>();
    private final Map<String, List<ISubtypingRelationship>> outputSubtypingRelationships = new HashMap<String, List<ISubtypingRelationship>>();

    public RelationshipManager(IEventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setExecutedResource(Resource executedResource) {
        this.inputSubtypingRelationships.values().stream().flatMap(l -> l.stream()).forEach(r -> r.setExecutedResource(executedResource));
    }

    @Override
    public void notifyEventOccurrence(EventOccurrence eventOccurrence) {
        Event event = eventOccurrence.getEvent();
        BehavioralInterface behavioralInterface = (BehavioralInterface)event.eContainer();
        String uri = behavioralInterface.eResource().getURI().toString();
        if (eventOccurrence.getType() == EventOccurrenceType.ACCEPTED) {
            this.inputImplementationRelationships.computeIfAbsent(uri, bi -> new ArrayList()).forEach(r -> r.processEventOccurrence(eventOccurrence));
            this.inputSubtypingRelationships.computeIfAbsent(uri, bi -> new ArrayList()).forEach(r -> r.processEventOccurrence(eventOccurrence));
        } else {
            this.eventManager.emitEventOccurrence(eventOccurrence);
            this.outputSubtypingRelationships.computeIfAbsent(uri, bi -> new ArrayList()).forEach(r -> r.processEventOccurrence(eventOccurrence));
        }
    }

    @Override
    public void notifyCallRequest(ICallRequest callRequest) {
        this.eventManager.processCallRequest(callRequest);
    }

    @Override
    public void notifyCall(CallNotification callNotification) {
        this.implementationRelationships.forEach(rel -> rel.processCallNotification(callNotification));
    }

    @Override
    public void notifyCall(ReturnNotification returnNotification) {
        this.implementationRelationships.forEach(rel -> rel.processReturnNotification(returnNotification));
    }

    @Override
    public void registerImplementationRelationship(IImplementationRelationship implementationRelationship) {
        this.implementationRelationships.add(implementationRelationship);
        String uri = implementationRelationship.getBehavioralInterface().eResource().getURI().toString();
        List relationships = this.inputImplementationRelationships.computeIfAbsent(uri, k -> new ArrayList());
        relationships.add(implementationRelationship);
        implementationRelationship.configure(e -> this.notifyEventOccurrence((EventOccurrence)e), cr -> this.notifyCallRequest((ICallRequest)cr));
        this.uriToBehavioralInterface.computeIfAbsent(uri, k -> implementationRelationship.getBehavioralInterface());
    }

    @Override
    public void unregisterImplementationRelationship(IImplementationRelationship implementationRelationship) {
        String uri = implementationRelationship.getBehavioralInterface().eResource().getURI().toString();
        List<IImplementationRelationship> relationships = this.inputImplementationRelationships.get(uri);
        if (relationships != null) {
            relationships.remove(implementationRelationship);
        }
        this.implementationRelationships.remove(implementationRelationship);
    }

    @Override
    public void registerSubtypingRelationship(ISubtypingRelationship subtypingRelationship) {
        String subtypeUri = subtypingRelationship.getSubtype().eResource().getURI().toString();
        String supertypeUri = subtypingRelationship.getSupertype().eResource().getURI().toString();
        List inputRelationships = this.inputSubtypingRelationships.computeIfAbsent(supertypeUri, k -> new ArrayList());
        inputRelationships.add(subtypingRelationship);
        List outputRelationships = this.outputSubtypingRelationships.computeIfAbsent(subtypeUri, k -> new ArrayList());
        outputRelationships.add(subtypingRelationship);
        subtypingRelationship.configure(e -> this.notifyEventOccurrence((EventOccurrence)e));
        this.uriToBehavioralInterface.computeIfAbsent(subtypeUri, k -> subtypingRelationship.getSubtype());
        this.uriToBehavioralInterface.computeIfAbsent(supertypeUri, k -> subtypingRelationship.getSupertype());
    }

    @Override
    public void unregisterSubtypingRelationship(ISubtypingRelationship subtypingRelationship) {
        List<ISubtypingRelationship> outputRelationships;
        String subtypeUri = subtypingRelationship.getSubtype().eResource().getURI().toString();
        String supertypeUri = subtypingRelationship.getSupertype().eResource().getURI().toString();
        List<ISubtypingRelationship> inputRelationships = this.inputSubtypingRelationships.get(supertypeUri);
        if (inputRelationships != null) {
            inputRelationships.remove(subtypingRelationship);
        }
        if ((outputRelationships = this.outputSubtypingRelationships.get(subtypeUri)) != null) {
            outputRelationships.remove(subtypingRelationship);
        }
    }

    private Set<BehavioralInterface> getAllBehavioralInterfaces() {
        HashSet<BehavioralInterface> result = new HashSet<BehavioralInterface>();
        BiConsumer<String, List> c = (k, v) -> {
            if (v != null && !v.isEmpty()) {
                result.add(this.uriToBehavioralInterface.get(k));
            }
        };
        this.inputImplementationRelationships.forEach(c);
        this.inputSubtypingRelationships.forEach(c);
        this.outputSubtypingRelationships.forEach(c);
        return result;
    }

    @Override
    public Set<Event> getEvents() {
        return this.getAllBehavioralInterfaces().stream().flatMap(i -> i.getEvents().stream()).collect(Collectors.toSet());
    }
}

