/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typing.IJvmTypeReferenceProvider;
import org.eclipse.xtext.xtype.XComputedTypeReference;
import org.eclipse.xtext.xtype.impl.XComputedTypeReferenceImplCustom;

public class InferredTypeIndicator
implements IJvmTypeReferenceProvider {
    private boolean resolved = false;
    private final XExpression expression;

    public InferredTypeIndicator(XExpression expression) {
        this.expression = expression;
    }

    public InferredTypeIndicator() {
        this(null);
    }

    public static boolean isInferred(JvmTypeReference typeReference) {
        IJvmTypeReferenceProvider typeProvider;
        return typeReference instanceof XComputedTypeReference && (typeProvider = ((XComputedTypeReference)typeReference).getTypeProvider()) instanceof InferredTypeIndicator && !((InferredTypeIndicator)typeProvider).resolved;
    }

    public static void resolveTo(JvmTypeReference inferred, JvmTypeReference resolved) {
        if (!InferredTypeIndicator.isInferred(inferred)) {
            throw new IllegalStateException("Cannot resolve a reference that is not inferred");
        }
        XComputedTypeReference casted = (XComputedTypeReference)inferred;
        casted.setEquivalent(resolved);
        ((InferredTypeIndicator)casted.getTypeProvider()).resolved = true;
    }

    @Override
    public JvmTypeReference getTypeReference(XComputedTypeReferenceImplCustom context) {
        LightweightTypeReference expressionType;
        Resource resource = context.eResource();
        IResolvedTypes resolvedTypes = null;
        if (resource instanceof XtextResource) {
            IBatchTypeResolver typeResolver = (IBatchTypeResolver)((XtextResource)resource).getResourceServiceProvider().get(IBatchTypeResolver.class);
            if (typeResolver == null) {
                throw new IllegalStateException("typeResolver may not be null");
            }
            resolvedTypes = typeResolver.resolveTypes((EObject)context);
        }
        if (context.eIsSet((EStructuralFeature)TypesPackage.Literals.JVM_SPECIALIZED_TYPE_REFERENCE__EQUIVALENT)) {
            return context.getEquivalent();
        }
        if (this.expression != null && resolvedTypes != null && (expressionType = resolvedTypes.getActualType(this.expression)) != null) {
            JvmTypeReference result = expressionType.toJavaCompliantTypeReference();
            return result;
        }
        throw new IllegalStateException("equivalent could not be computed");
    }

    public XExpression getExpression() {
        return this.expression;
    }

    public String toString() {
        return String.format("InferredTypeIndicator[resolved=%s, expression=%s]", this.resolved, this.expression == null ? "null" : this.expression.eClass().getName());
    }
}

